<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.report-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
}

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.report-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.report-table-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.report-table-card table thead {
    background: #f7fafc;
}

.report-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.report-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.report-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.report-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    color: white;
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.btn-modern-primary:hover {
    background: linear-gradient(135deg, #5568d3 0%, #653f8f 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
}

.stats-summary {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    padding: 1.5rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    border-left: 4px solid #667eea;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}
</style>

<!-- Header Section -->
<div class="report-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fas fa-calendar-check"></i> Booking Reports
            </h2>
            <p class="mb-0 opacity-75">Generate and view detailed booking reports with filters and analytics</p>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="d-flex align-items-center mb-3">
        <i class="fas fa-filter text-primary me-2"></i>
        <h5 class="mb-0">Report Filters</h5>
    </div>
    <form method="post" action="<?php echo base_url('reports/booking'); ?>" class="row g-3">
        <div class="col-md-4">
            <label for="booking_from" class="form-label-modern">From Date</label>
            <input type="date" class="form-control form-control-modern" id="booking_from" name="booking_from" 
                   value="<?php echo isset($fromDate) ? $fromDate : ''; ?>" required>
        </div>
        <div class="col-md-4">
            <label for="booking_to" class="form-label-modern">To Date</label>
            <input type="date" class="form-control form-control-modern" id="booking_to" name="booking_to" 
                   value="<?php echo isset($toDate) ? $toDate : ''; ?>" required>
        </div>
        <div class="col-md-4">
            <label class="form-label-modern">&nbsp;</label>
            <div>
                <input type="hidden" id="bookingreport" name="bookingreport" value="1">
                <button type="submit" class="btn btn-modern-primary w-100">
                    <i class="fas fa-chart-line"></i> Generate Report
                </button>
            </div>
        </div>
    </form>
</div>

<?php if (!empty($tripsData)): ?>
<!-- Statistics Summary -->
<?php
$totalBookings = count($tripsData);
$completedBookings = 0;
$pendingBookings = 0;
$cancelledBookings = 0;
$totalRevenue = 0;

foreach ($tripsData as $data) {
    $status = isset($data['bookingDetails']['status']) ? strtolower($data['bookingDetails']['status']) : 'pending';
    if (in_array($status, array('ridecomplete', 'completed', 'rated'))) {
        $completedBookings++;
    } elseif (in_array($status, array('pending', 'accepted', 'in_progress'))) {
        $pendingBookings++;
    } elseif ($status == 'cancelled') {
        $cancelledBookings++;
    }
    
    $price = isset($data['bookingDetails']['price']) ? floatval($data['bookingDetails']['price']) : 0;
    $totalRevenue += $price;
}
?>
<div class="stats-summary">
    <div class="row">
        <div class="col-md-3">
            <p class="text-muted mb-1 small">Total Bookings</p>
            <h3 class="stats-number mb-0"><?php echo $totalBookings; ?></h3>
        </div>
        <div class="col-md-3">
            <p class="text-muted mb-1 small">Completed</p>
            <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $completedBookings; ?></h3>
        </div>
        <div class="col-md-3">
            <p class="text-muted mb-1 small">Pending</p>
            <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $pendingBookings; ?></h3>
        </div>
        <div class="col-md-3">
            <p class="text-muted mb-1 small">Total Revenue</p>
            <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo number_format($totalRevenue, 2); ?></h3>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Report Table -->
<?php if (!empty($tripsData)): ?>
<div class="report-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-table"></i> Booking Details
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="bookingReportTable">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Booking #</th>
                        <th>Date/Time</th>
                        <th>Customer</th>
                        <th>Driver</th>
                        <th>Vehicle</th>
                        <th>Service Type</th>
                        <th>Pickup</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $count = 1;
                    foreach ($tripsData as $tripId => $data) {
                        $booking = $data['bookingDetails'];
                        
                        // Booking number
                        $bookingNumber = 'BK-' . substr($tripId, 0, 8);
                        
                        // Booking date
                        $bookingDate = isset($booking['bookingDate']) ? $booking['bookingDate'] : (isset($booking['pickupDate']) ? $booking['pickupDate'] : 0);
                        $bookingDateFormatted = $bookingDate > 0 ? date('Y-m-d H:i:s', $bookingDate / 1000) : 'N/A';
                        
                        // Customer name
                        $customerName = isset($booking['userName']) ? $booking['userName'] : 'Unknown User';
                        
                        // Driver name
                        $driverName = isset($booking['driverName']) ? $booking['driverName'] : 'Not Assigned';
                        
                        // Vehicle name
                        $vehicleName = isset($booking['vehicleName']) ? $booking['vehicleName'] : 'N/A';
                        
                        // Service type
                        $serviceType = isset($booking['service_type']) ? strtoupper($booking['service_type']) : 'N/A';
                        
                        // Pickup address
                        $pickupAddress = isset($booking['pickupAddress']) ? $booking['pickupAddress'] : 'N/A';
                        if (strlen($pickupAddress) > 40) {
                            $pickupAddress = substr($pickupAddress, 0, 40) . '...';
                        }
                        
                        // Price
                        $price = isset($booking['price']) ? floatval($booking['price']) : 0;
                        $priceFormatted = '$' . number_format($price, 2);
                        
                        // Status
                        $status = isset($booking['status']) ? strtolower($booking['status']) : 'pending';
                        $statusColors = array(
                            'pending' => 'warning-modern',
                            'accepted' => 'info-modern',
                            'in_progress' => 'primary-modern',
                            'on_way' => 'primary-modern',
                            'ridecomplete' => 'success-modern',
                            'completed' => 'success-modern',
                            'ridecompleted' => 'success-modern',
                            'rated' => 'success-modern',
                            'dispute' => 'danger-modern',
                            'disputed' => 'danger-modern',
                            'cancelled' => 'danger-modern'
                        );
                        $statusColor = isset($statusColors[$status]) ? $statusColors[$status] : 'secondary-modern';
                        
                        $statusDisplay = ucwords(str_replace('_', ' ', $status));
                        if ($status == 'ridecompleted') $statusDisplay = 'Completed';
                        if ($status == 'ridecomplete') $statusDisplay = 'Completed';
                    ?>
                    <tr>
                        <td><?php echo $count++; ?></td>
                        <td>
                            <strong><?php echo $bookingNumber; ?></strong>
                        </td>
                        <td><?php echo $bookingDateFormatted; ?></td>
                        <td>
                            <div>
                                <strong><?php echo htmlspecialchars($customerName); ?></strong>
                                <?php if (isset($booking['userEmail']) && !empty($booking['userEmail'])): ?>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($booking['userEmail']); ?></small>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <?php if ($driverName != 'Not Assigned'): ?>
                                <span class="badge-modern badge-info-modern">
                                    <i class="fas fa-user"></i>
                                    <?php echo htmlspecialchars($driverName); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">Not Assigned</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($vehicleName != 'N/A'): ?>
                                <span class="badge-modern badge-primary-modern">
                                    <i class="fas fa-car"></i>
                                    <?php echo htmlspecialchars($vehicleName); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge-modern badge-warning-modern">
                                <i class="fas fa-clock"></i>
                                <?php echo htmlspecialchars($serviceType); ?>
                            </span>
                        </td>
                        <td><small><?php echo htmlspecialchars($pickupAddress); ?></small></td>
                        <td><strong><?php echo $priceFormatted; ?></strong></td>
                        <td>
                            <span class="badge-modern badge-<?php echo $statusColor; ?>">
                                <?php echo $statusDisplay; ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="<?php echo base_url('orders/view/' . $tripId); ?>" class="btn btn-sm btn-modern-primary">
                                <i class="fas fa-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php else: ?>
<div class="alert alert-info" style="border-radius: 15px; padding: 2rem; text-align: center;">
    <i class="fas fa-info-circle" style="font-size: 3rem; margin-bottom: 1rem; color: #4299e1;"></i>
    <h4>No bookings found</h4>
    <p class="mb-0">Please select a date range and generate the report.</p>
</div>
<?php endif; ?>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#bookingReportTable').DataTable({
        "order": [[ 2, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fas fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ bookings per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ bookings",
            "infoEmpty": "No bookings found",
            "infoFiltered": "(filtered from _MAX_ total bookings)"
        }
    });
});
</script>
