<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Delivery Reports & Analytics</h2>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Filters</h6>
        </div>
        <div class="card-body">
            <form method="get" action="<?php echo base_url('Reports/delivery'); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="date" name="fromDate" class="form-control" value="<?php echo isset($fromDate) ? $fromDate : date('Y-m-d', strtotime('-30 days')); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="date" name="toDate" class="form-control" value="<?php echo isset($toDate) ? $toDate : date('Y-m-d'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>City</label>
                            <select name="cityId" class="form-control">
                                <option value="">All Cities</option>
                                <?php foreach ($cities as $cityId => $city): ?>
                                    <option value="<?php echo $cityId; ?>" <?php echo (isset($selectedCityId) && $selectedCityId == $cityId) ? 'selected' : ''; ?>>
                                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" class="btn btn-primary btn-block">Generate Report</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card shadow mb-4">
                <div class="card-body">
                    <h6 class="text-muted">Total Orders</h6>
                    <h2 class="mb-0"><?php echo isset($stats['totalOrders']) ? $stats['totalOrders'] : 0; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow mb-4">
                <div class="card-body">
                    <h6 class="text-muted">Total Revenue</h6>
                    <h2 class="mb-0">$<?php echo isset($stats['totalRevenue']) ? number_format($stats['totalRevenue'], 2) : '0.00'; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow mb-4">
                <div class="card-body">
                    <h6 class="text-muted">Multi-Vendor Orders</h6>
                    <h2 class="mb-0"><?php echo isset($stats['multiVendorOrders']) ? $stats['multiVendorOrders'] : 0; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow mb-4">
                <div class="card-body">
                    <h6 class="text-muted">Storefront Orders</h6>
                    <h2 class="mb-0"><?php echo isset($stats['storefrontOrders']) ? $stats['storefrontOrders'] : 0; ?></h2>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders by City -->
    <?php if (!empty($stats['ordersByCity'])): ?>
    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Orders by City</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>City</th>
                            <th>Orders</th>
                            <th>Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByCity'] as $cityName => $count): ?>
                        <tr>
                            <td><?php echo $cityName; ?></td>
                            <td><?php echo $count; ?></td>
                            <td>$<?php echo isset($stats['revenueByCity'][$cityName]) ? number_format($stats['revenueByCity'][$cityName], 2) : '0.00'; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Orders by Zone -->
    <?php if (!empty($stats['ordersByZone'])): ?>
    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Orders by Zone</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Zone</th>
                            <th>Orders</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByZone'] as $zone => $count): ?>
                        <tr>
                            <td><?php echo strtoupper($zone); ?></td>
                            <td><?php echo $count; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Orders by Status -->
    <?php if (!empty($stats['ordersByStatus'])): ?>
    <div class="card shadow mb-4">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">Orders by Status</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByStatus'] as $status => $count): ?>
                        <tr>
                            <td><?php echo ucfirst(str_replace('_', ' ', $status)); ?></td>
                            <td><?php echo $count; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
