<style>
/* Professional Sidebar Styles */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.sidebar-wrapper {
    background: linear-gradient(180deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    width: 280px;
    box-shadow: 8px 0 32px rgba(0, 0, 0, 0.12);
    position: fixed;
    left: 0;
    top: 0;
    z-index: 1000;
    display: flex;
    flex-direction: column;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.sidebar-header {
    padding: 12px 24px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.12);
    display: flex;
    align-items: center;
    justify-content: space-between;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(10px);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    min-height: 70px;
}

.brand-logo {
    display: flex;
    align-items: center;
    font-size: 22px;
    font-weight: 700;
    color: #1f2937;
    letter-spacing: -0.3px;
    text-decoration: none;
    transition: all 0.3s ease;
    padding: 8px 16px;
    border-radius: 12px;
    background: #ffffff;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    width: 100%;
    justify-content: center;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.brand-logo:hover {
    background: #ffffff;
    transform: translateY(-1px);
    color: #1f2937;
    text-decoration: none;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.brand-logo i {
    margin-right: 10px;
    font-size: 24px;
    color: #667eea;
    transition: all 0.3s ease;
}

.brand-logo:hover i {
    color: #764ba2;
    transform: scale(1.05);
}

.brand-logo span {
    color: #1f2937;
    font-weight: 700;
}

.sidebar-close {
    display: none;
    color: #4b5563;
    cursor: pointer;
    font-size: 20px;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    transition: all 0.3s ease;
    margin-left: 12px;
    flex-shrink: 0;
    background: #f3f4f6;
}

.sidebar-close:hover {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #ffffff;
    transform: rotate(90deg) scale(1.05);
}

.sidebar-nav {
    display: flex;
    flex-direction: column;
    flex: 1;
    overflow: hidden;
    padding: 24px 0;
}

.sidebar-nav-content {
    flex: 1;
    overflow-y: auto;
    overflow-x: hidden;
    padding: 0 16px;
}

.metismenu {
    list-style: none;
    padding: 0;
    margin: 0;
}

.metismenu li {
    margin: 0 0 8px 0;
    padding: 0;
}

.metismenu a {
    display: flex;
    align-items: center;
    padding: 14px 20px;
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    font-size: 15px;
    font-weight: 500;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-radius: 12px;
    position: relative;
    margin: 0 8px;
    border-left: 3px solid transparent;
    background: rgba(255, 255, 255, 0);
}

.metismenu a::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 3px;
    height: 0;
    background: #ffffff;
    border-radius: 0 3px 3px 0;
    transition: height 0.3s ease;
}

.metismenu a:hover {
    background: rgba(255, 255, 255, 0.12);
    color: #ffffff;
    transform: translateX(4px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.metismenu a:hover::before {
    height: 60%;
}

.metismenu a.active {
    background: rgba(255, 255, 255, 0.18);
    color: #ffffff;
    font-weight: 600;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
}

.metismenu a.active::before {
    height: 70%;
}

.menu-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 14px;
    font-size: 18px;
    flex-shrink: 0;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    transition: all 0.3s ease;
}

.metismenu a:hover .menu-icon,
.metismenu a.active .menu-icon {
    background: rgba(255, 255, 255, 0.2);
    transform: scale(1.05);
}

.menu-title {
    flex: 1;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    letter-spacing: 0.2px;
}

/* Custom Scrollbar */
.sidebar-nav-content::-webkit-scrollbar {
    width: 5px;
}

.sidebar-nav-content::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
    margin: 8px 0;
}

.sidebar-nav-content::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.25);
    border-radius: 10px;
    transition: background 0.3s ease;
}

.sidebar-nav-content::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.4);
}

/* SimpleBar Override */
.sidebar-wrapper .sidebar-nav .simplebar-scrollbar::before {
    background: rgba(255, 255, 255, 0.3) !important;
    border-radius: 10px;
    opacity: 1 !important;
}

.sidebar-wrapper .sidebar-nav .simplebar-track {
    background: rgba(255, 255, 255, 0.05) !important;
    border-radius: 10px;
    right: 8px !important;
    width: 5px !important;
}

.sidebar-wrapper .sidebar-nav .simplebar-track.simplebar-vertical {
    width: 5px !important;
}

.sidebar-wrapper .sidebar-nav .simplebar-content-wrapper {
    padding-right: 0;
}

.sidebar-wrapper .sidebar-nav .simplebar-content {
    padding-right: 0 !important;
}

/* Active state indicator */
.metismenu a.active::after {
    content: '';
    position: absolute;
    right: 20px;
    top: 50%;
    transform: translateY(-50%);
    width: 6px;
    height: 6px;
    background: #ffffff;
    border-radius: 50%;
    box-shadow: 0 0 8px rgba(255, 255, 255, 0.5);
}

/* Sidebar Toggle Styles */
body.toggled .sidebar-wrapper {
    transform: translateX(-100%);
}

body.toggled .top-header .navbar {
    left: 0;
}

body.toggled .main-wrapper {
    margin-left: 0;
}

body.toggled .page-footer {
    left: 0;
}

body.toggled .overlay.btn-toggle {
    display: block;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
}

.overlay.btn-toggle {
    display: none;
}

/* Responsive */
@media (max-width: 992px) {
    .sidebar-wrapper {
        transform: translateX(-100%);
    }
    
    .sidebar-wrapper.active {
        transform: translateX(0);
    }
    
    body.toggled .sidebar-wrapper {
        transform: translateX(0);
    }
    
    body.toggled .sidebar-wrapper.active {
        transform: translateX(0);
    }
}

@media (max-width: 768px) {
    .sidebar-wrapper {
        width: 260px;
    }
    
    .sidebar-header {
        padding: 20px 18px;
    }
    
    .brand-logo {
        font-size: 20px;
        padding: 6px 10px;
    }
    
    .metismenu a {
        padding: 12px 16px;
        font-size: 14px;
        margin: 0 4px;
    }
    
    .menu-icon {
        width: 36px;
        height: 36px;
        font-size: 16px;
        margin-right: 12px;
    }
    
    .sidebar-nav-content {
        padding: 0 12px;
    }
}

/* Animation */
@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.metismenu li {
    animation: slideIn 0.3s ease forwards;
}

.metismenu li:nth-child(1) { animation-delay: 0.05s; }
.metismenu li:nth-child(2) { animation-delay: 0.1s; }
.metismenu li:nth-child(3) { animation-delay: 0.15s; }
.metismenu li:nth-child(4) { animation-delay: 0.2s; }
.metismenu li:nth-child(5) { animation-delay: 0.25s; }
.metismenu li:nth-child(6) { animation-delay: 0.3s; }
.metismenu li:nth-child(7) { animation-delay: 0.35s; }
.metismenu li:nth-child(8) { animation-delay: 0.4s; }
</style>
<aside class="sidebar-wrapper">
    <!-- Sidebar Header -->
    <div class="sidebar-header">
        <a href="<?php echo base_url('dashboard'); ?>" class="brand-logo">
            <i class="fas fa-calendar-check"></i>
            <span>X-driven</span>
        </a>
        <div class="sidebar-close d-lg-none">
            <i class="fas fa-times"></i>
        </div>
    </div>

    <!-- Sidebar Navigation -->
    <div class="sidebar-nav" data-simplebar="true" data-simplebar-auto-hide="false">
        <div class="sidebar-nav-content">
            <ul class="metismenu" id="sidenav">
                <!-- Dashboard -->
                <li>
                    <a href="<?php echo base_url('dashboard'); ?>" class="" title="Dashboard Overview">
                        <div class="menu-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <div class="menu-title">Dashboard</div>
                    </a>
                </li>

                <!-- Users Module -->
                <li>
                    <a href="<?php echo base_url('Customer'); ?>" class="" title="Manage Users">
                        <div class="menu-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="menu-title">Users</div>
                    </a>
                </li>

                <!-- Drivers Module -->
                <li>
                    <a href="<?php echo base_url('drivers'); ?>" class="" title="Manage Drivers">
                        <div class="menu-icon">
                            <i class="fas fa-car"></i>
                        </div>
                        <div class="menu-title">Drivers</div>
                    </a>
                </li>

                <!-- Bookings Module -->
                <li>
                    <a href="<?php echo base_url('Orders'); ?>" class="" title="Manage Bookings">
                        <div class="menu-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <div class="menu-title">Bookings</div>
                    </a>
                </li>

                <!-- Notifications Module -->
                <li>
                    <a href="<?php echo base_url('Promotion/notification'); ?>" class="" title="Manage Notifications">
                        <div class="menu-icon">
                            <i class="fas fa-bell"></i>
                        </div>
                        <div class="menu-title">Notifications</div>
                    </a>
                </li>

                <!-- Reports Module -->
                <li>
                    <a href="<?php echo base_url('Reports'); ?>" class="" title="View Reports">
                        <div class="menu-icon">
                            <i class="fas fa-chart-bar"></i>
                        </div>
                        <div class="menu-title">Reports</div>
                    </a>
                </li>

                <!-- Settings Module -->
                <li>
                    <a href="<?php echo base_url('dashboard/settings'); ?>" class="" title="System Settings">
                        <div class="menu-icon">
                            <i class="fas fa-cog"></i>
                        </div>
                        <div class="menu-title">Settings</div>
                    </a>
                </li>

                <!-- Logout -->
                <li>
                    <a href="<?php echo base_url('login/logout'); ?>" class="" title="Sign Out" onclick="return confirm('Are you sure you want to logout?');">
                        <div class="menu-icon">
                            <i class="fas fa-sign-out-alt"></i>
                        </div>
                        <div class="menu-title">Logout</div>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</aside>
<main class="main-wrapper">
    <div class="main-content">