<style>
.subcategory-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.subcategory-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid #667eea;
}

.subcategory-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.subcategory-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.subcategory-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.subcategory-table-card table thead {
    background: #f7fafc;
}

.subcategory-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.subcategory-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.subcategory-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.subcategory-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}
</style>

<!-- Header Section -->
<div class="subcategory-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-layer-group"></i> Subcategory Management
            </h2>
            <p class="mb-0 opacity-75">Organize products with subcategories under main categories</p>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo base_url('dashboard/addsubcategory'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-plus"></i> Add New Subcategory
            </a>
        </div>
    </div>
</div>

<!-- Statistics Card -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="subcategory-stats-card">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-layer-group"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Subcategories</p>
                    <h3 class="stats-number mb-0"><?php echo !empty($categories) ? count($categories) : 0; ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Subcategories Table -->
<div class="subcategory-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Subcategories List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="subcategoriesTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Subcategory Name</th>
                        <th>Parent Category</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($categories)) {
                        $count = 1;
                        foreach ($categories as $id => $category) {
                            $subcategoryName = isset($category['name']) ? $category['name'] : (isset($category['subcategoryName']) ? $category['subcategoryName'] : 'Unknown');
                            $categoryId = isset($category['categoryId']) ? $category['categoryId'] : '';
                            $parentCategoryName = 'Unknown';
                            
                            if ($categoryId && !empty($maincategories)) {
                                foreach ($maincategories as $mainId => $mainCategory) {
                                    if ($mainId == $categoryId) {
                                        $parentCategoryName = isset($mainCategory['name']) ? $mainCategory['name'] : (isset($mainCategory['categoryName']) ? $mainCategory['categoryName'] : 'Unknown');
                                        break;
                                    }
                                }
                            }
                    ?>
                    <tr>
                        <td><?php echo $count; ?></td>
                        <td>
                            <span class="badge-modern badge-primary-modern">
                                <i class="fa-solid fa-tag"></i>
                                <?php echo htmlspecialchars($subcategoryName); ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-folder"></i>
                                <?php echo htmlspecialchars($parentCategoryName); ?>
                            </span>
                        </td>
                        <td>
                            <div class="d-flex gap-2 justify-content-center">
                                <a href="<?php echo base_url('dashboard/editsubcategory/' . $id); ?>" class="btn btn-sm btn-info btn-modern" title="Edit">
                                    <i class="fa-solid fa-edit"></i> Edit
                                </a>
                                <a href="<?php echo base_url('dashboard/deletesubcategory/' . $id); ?>" 
                                    class="btn btn-sm btn-danger btn-modern" 
                                    title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this subcategory?');">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php
                            $count++;
                        }
                    } else {
                    ?>
                    <tr>
                        <td colspan="4" class="text-center py-5">
                            <i class="fa-solid fa-layer-group fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No subcategories found</p>
                            <a href="<?php echo base_url('dashboard/addsubcategory'); ?>" class="btn btn-modern btn-modern-primary">
                                <i class="fa-solid fa-plus"></i> Add First Subcategory
                            </a>
                        </td>
                    </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#subcategoriesTable').DataTable({
        "order": [[ 1, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ subcategories per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ subcategories",
            "infoEmpty": "No subcategories found",
            "infoFiltered": "(filtered from _MAX_ total subcategories)"
        }
    });
});
</script>
