
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Chunked Video Upload with Dropzone and AWS S3</title>
    <!-- Include Dropzone.js CSS and JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/dropzone.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/dropzone.min.js"></script>
    <style>
        #file-upload-container {
            border: 2px dashed #0087F7;
            padding: 20px;
            width: 50%;
            margin: 0 auto;
        }
    </style>
</head>
<body>
<?php

$error = $this->session->flashdata('error');
if ($error) {
    echo '<div class="alert alert-danger">' . $error . '</div>';
}
$error = $this->session->flashdata('error1');
if ($error) {
    echo '<div class="alert alert-danger">' . $error . '</div>';
}
?>
hhahaha
<div id="file-upload-container" class="dropzone">
    <div class="dz-message">Drag & Drop video file here or click to upload</div>
</div>

<script>
    const chunkSize = 5 * 1024 * 1024; // 5 MB chunk size
    let totalChunks = 0;
    let uploadId = null;

    const myDropzone = new Dropzone('#file-upload-container', {
        url: 'http://137.184.111.69/athletic/upload/startUpload',
        paramName: 'file',
        addRemoveLinks: true,
        autoProcessQueue: false,
        maxFiles: 1,
        acceptedFiles: '.mp4, .mov, .avi, .mkv',
        init: function () {
            this.on("addedfile", function (file) {
                totalChunks = Math.ceil(file.size / chunkSize);
                console.log('Total Chunks:', totalChunks);
                const formData = new FormData();
                formData.append('fileName', file.name);

                $.ajax({
                    url: 'http://137.184.111.69/athletic/upload/startUpload',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(obj) {
                        console.log(obj);
                        const data=JSON.parse(obj);
                        console.log("data",data);


                        if (data.uploadId) {
                            uploadId = data.uploadId;
                            console.log('Upload ID:', uploadId);

                            // Begin chunked upload
                            uploadNextChunk(file, 0);
                        } else {
                            console.error('Error starting upload:', data.error);
                        }
                    },
                    error: function(error) {
                        console.error('Error starting upload:', error);
                    }
                });
            });
        }
    });

    function uploadNextChunk(file, currentChunk) {
        if (currentChunk >= totalChunks) {
            completeUpload(file.name, uploadId);
            return;
        }

        const start = currentChunk * chunkSize;
        const end = Math.min(start + chunkSize, file.size);
        const chunk = file.slice(start, end);
        const formData = new FormData();

        formData.append('file', chunk);
        formData.append('fileName', file.name);
        formData.append('partNumber', currentChunk + 1);
        formData.append('uploadId', uploadId);

        fetch('http://137.184.111.69/athletic/upload/uploadPart', {
            method: 'POST',
            body: formData,
        })
        .then(response => response.json())
        .then(data => {
            console.log(data);
            if (data.status === 'chunk_uploaded') {
                console.log(`Chunk ${currentChunk + 1} uploaded`);

                // Upload next chunk
                uploadNextChunk(file, currentChunk + 1);
            } else {
                console.error('Error uploading chunk:', data.error);
            }
        })
        .catch(error => {
            console.error('Error uploading chunk:', error);
        });
    }

    function completeUpload(fileName, uploadId) {
    const formData = new FormData();
    formData.append('fileName', fileName);
    formData.append('uploadId', uploadId);

    $.ajax({
        url: 'http://137.184.111.69/athletic/upload/completeUpload',
        type: 'POST',
        data: formData,
        contentType: false, // Necessary for FormData
        processData: false, // Prevent jQuery from processing data
        success: function(obj) {
            const data=JSON.parse(obj);
            console.log(data);

            if (data.message === 'Upload complete') {
                console.log('Upload completed:', data.fileUrl);
                alert(`File uploaded successfully: ${data.fileUrl}`);
            } else {
                console.error('Error completing upload:', data.error);
            }
       
            },

        error: function(xhr, status, error) {
            console.error('Error completing upload:');
            console.log()
        }
    });
}

</script>

</body>
</html>
