<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }

  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");


    $this->template->template_render('settings', $data);
  }
  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'Settings has been updated');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }

  public function index()
  {
    
    $sessionData = $this->session->userdata('session_data');
    $data['freelancers'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'userType', '=', 'Admin');
    $data['users'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'userType', '=', 'User');
    $data['totalUsers'] = $this->common->readnumberofdocumentsincollection('Users');
    $data['categories'] = $this->common->readnumberofdocumentsincollection('Categories');
    $users = $this->common->readdatafromcollectionwhereclause("Users", 'userRole', '=', 'user');
    $data['users'] = count($users);
    foreach ($users as $key => $user) {
      $timestamps[$key]    = $user['createdDate'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F') . " - 3 months"));
    for ($i = 1; $i <= 5; $i++) {
      $timestamp = strtotime($labels[$i - 1] . ' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach ($labels as $label) {
      $labelStr .= '"' . $label . '", ';
    }

    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for ($i = 0; $i < count($labels); $i++) {
      $num = 0;
      foreach ($timestamps as $timestamp) {
        if ($labels[$i] == date('F', $timestamp / 1000)) {
          $num += 0.2;
        }
      }
      $dataStr .= $num . ',';
    }
    $data['dataStr'] = $dataStr;

    $data['userdetails'] = $sessionData;


    $this->template->template_render('dashboard', $data);
  }

  public function categories()
  {

    $data['categories'] = $this->common->readdatafromcollectionwhereclause('Categories');
    $this->template->template_render('categories', $data);
  }

  public function addcategory()
  {

    $this->template->template_render('addcategory');
  }

  public function insertcategory()
  {

    $post = $this->input->post();
    $data['title'] = $post['title'];
    $response = $this->common->addnewdatamodel('Categories', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
  }

  public function editcategory()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['category'] = $this->common->readdatadocument('Categories', $id);
    $this->template->template_render('addcategory', $data);
  }

  public function updatecategory()
  {
    $post = $this->input->post();
    $data['title'] = $post['title'];

    $response = $this->common->updatedatamodel('Categories', $post['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
  }
  
  public function deletecategory()
  {
    $id = $this->uri->segment(3);

    $response = $this->common->deletedatamodel('Categories', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
  }
}
