<!-- Include Google Maps JavaScript API -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAhi3mFu4ntWNTYUERmA6KB361ziLX2vhE&libraries=places"></script>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Add Place</h2>
            </div>
        </div>
    </div>
    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="<?= base_url('customer/add_place_action') ?>" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="placeType">Place Type</label>
                    <select class="form-control" id="placeType" name="placeType" required onchange="toggleCategoriesInput(this.value)">
                        <option value="restaurant">Restaurant</option>
                        <option value="hotel">Hotel</option>
                        <option value="groceries">Groceries</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="name">Place Name</label>
                    <input type="text" class="form-control" id="name" name="name" placeholder="Enter place name" required>
                </div>
                <div class="form-group">
                    <label for="description">Place Description</label>
                    <input type="text" class="form-control" id="description" name="description" placeholder="Enter place description" required>
                </div>
                <div class="form-group">
                    <label for="location">Location</label>
                    <input type="text" class="form-control" id="location" name="location" placeholder="Search location" required>
                    <!-- <input type="hidden" id="latitude" name="latitude">
                <input type="hidden" id="longitude" name="longitude"> -->
                </div>
                <div class="form-group">
                    <label for="image">Upload Image</label>
                    <input type="file" class="form-control" id="image" name="image" required>
                </div>

                <div class="form-group" id="categories-group">
                    <label for="categories">Categories</label>
                    <input type="text" class="form-control" id="categories" name="categories" placeholder="Enter categories separated by commas">
                </div>
                <button type="submit" class="btn btn-primary">Add Place</button>
            </form>
        </div>
    </div>

    <script>
        function toggleCategoriesInput(placeType) {
            const categoriesGroup = document.getElementById('categories-group');
            const categoriesInput = document.getElementById('categories');
            if (placeType === 'hotel') {
                categoriesGroup.style.display = 'none';
                categoriesInput.removeAttribute('required');
            } else {
                categoriesGroup.style.display = 'block';
                categoriesInput.setAttribute('required', 'required');
            }
        }
    </script>

</div>

<script>
    // function initAutocomplete() {
    //     const locationInput = document.getElementById('location');
    //     const autocomplete = new google.maps.places.Autocomplete(locationInput);
    //     autocomplete.setFields(['geometry', 'formatted_address']);

    //     autocomplete.addListener('place_changed', function () {
    //         const place = autocomplete.getPlace();

    //         if (!place.geometry) {
    //             alert("Invalid location. Please select a valid place from the suggestions.");
    //             locationInput.value = ""; 
    //             return;
    //         }    
    //         document.getElementById('latitude').value = place.geometry.location.lat();
    //         document.getElementById('longitude').value = place.geometry.location.lng();
    //     });
    // }

    // window.onload = initAutocomplete;
</script>