<!-- Include Google Maps JavaScript API -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAhi3mFu4ntWNTYUERmA6KB361ziLX2vhE&libraries=places"></script>

<div class="container-fluid">
    <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Edit Place</h2>
            </div>
        </div>
    </div>
    <div class="card shadow mb-4 mt-5">
        <div class="card-body">
            <form action="<?= base_url('customer/update_place_action/' . $place['id']) ?>" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="name">Place Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="<?= $place['name'] ?>" required>
                </div>
                <div class="form-group">
                    <label for="description">Place Description</label>
                    <input type="text" class="form-control" id="description" name="description" value="<?= $place['description'] ?>" required>
                </div>
                <div class="form-group">
                    <label for="location">Location</label>
                    <input type="text" class="form-control" id="location" name="location" value="<?= $place['location'] ?>" required>
                    <!-- <input type="hidden" id="latitude" name="latitude" value="<?= $place['latitude'] ?>">
                <input type="hidden" id="longitude" name="longitude" value="<?= $place['longitude'] ?>"> -->
                </div>
                <div class="form-group">
                    <label for="placeType">Place Type</label>
                    <select class="form-control" id="placeType" name="placeType" required>
                        <option value="restaurant" <?= $place['placeType'] == 'restaurant' ? 'selected' : '' ?>>Restaurant</option>
                        <option value="hotel" <?= $place['placeType'] == 'hotel' ? 'selected' : '' ?>>Hotel</option>
                        <option value="groceries" <?= $place['placeType'] == 'groceries' ? 'selected' : '' ?>>Groceries</option>
                    </select>
                </div>
                <div class="form-group" id="categoriesWrapper">
                    <label for="categories">Categories (Please Separate Categories With Commas If Applicable)</label>
                    <input type="hidden" name="categories[]" value="All Foods">
                    <input type="text" class="form-control" id="categories" name="categories" value="<?= implode(',', array_diff($place['categories'], ['All Foods'])) ?>" placeholder="Enter categories separated by commas">
                </div>

                <div class="form-group">
                    <label for="image">Upload Image</label>
                    <input type="file" class="form-control" id="image" name="image" accept="image/*" onchange="previewImage(this)">
                    <br>
                    <img id="preview" src="<?= $place['imageUrl'] ?>" alt="Image Preview" style="max-width: 200px;">
                </div>
                <button type="submit" class="btn btn-primary">Update Place</button>
            </form>
        </div>
    </div>

    <script>
    const placeType = document.getElementById('placeType');
    const categoriesWrapper = document.getElementById('categoriesWrapper'); // This is the div that contains the categories input field

    // Check the selected placeType on page load and hide/show categories accordingly
    function toggleCategories() {
        if (placeType.value === 'restaurant' || placeType.value === 'groceries') {
            categoriesWrapper.style.display = 'block'; // Show categories input
        } else {
            categoriesWrapper.style.display = 'none'; // Hide categories input
        }
    }

    // Event listener for place type change
    placeType.addEventListener('change', toggleCategories);

    // Call the function on page load to ensure correct visibility
    toggleCategories();
</script>

    <script>


        function previewImage(input) {
            const file = input.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview').src = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        }
    </script>