<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Header with Add Button -->
    <div class="row column_title">
        <div class="col-md-12 d-flex justify-content-between align-items-center">
            <div class="page_title d-flex align-items-center gap-2">
                <h2>Menu</h2>
            </div>
            <a href="#" class="btn btn-info" data-toggle="modal" data-target="#addMenuItemModal">Add Menu Item</a>
        </div>
    </div>

    <!-- Card with DataTable -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="menuTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Food Name</th>
                            <th>Description</th>
                            <th>Price</th>
                            <th>Image</th>
                            <th>Type</th>
                            <th>Rating</th>
                            <th>Quantity</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($menuItems as $item): ?>
                            <tr>
                                <td><?= $item['foodName'] ?></td>
                                <td><?= $item['description'] ?></td>
                                <td><?= $item['price'] ?></td>
                                <td><img src="<?= $item['imageUrl'] ?>" alt="Food Image" style="max-width: 100px;"></td>
                                <td><?= $item['type'] ?></td>
                                <td><?= $item['rating'] ?></td>
                                <td><?= $item['totalQuantity'] ?></td>
                                <td>
                                    <a href="<?= base_url('customer/edit_menu_item/' . $item['menuID']) ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('customer/delete_menu_item/' . $item['menuID']) ?>" class="btn btn-sm btn-danger">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<!-- Modal for Adding Menu Item -->
<div class="modal fade" id="addMenuItemModal" tabindex="-1" role="dialog" aria-labelledby="addMenuItemModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMenuItemModalLabel">Add Menu Item</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="<?= base_url('customer/add_menu_item/' . $restaurantId) ?>" method="POST" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="foodName">Food Name</label>
                        <input type="text" class="form-control" id="foodName" name="foodName" required>
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="price">Price</label>
                        <input type="number" class="form-control" id="price" name="price" required>
                    </div>
                    <div class="form-group">
                        <label for="image">Food Image</label>
                        <input type="file" class="form-control" id="image" name="image" required>
                    </div>
                    <div class="form-group">
                        <label for="type">Type</label>
                        <input type="text" class="form-control" id="type" name="type" required>
                    </div>
                    <div class="form-group">
                        <label for="quantity">Quantity</label>
                        <input type="quantity" class="form-control" id="quantity" name="quantity" required>
                    </div>
                    <input type="hidden" name="restaurantId" value="<?= $restaurantId ?>">
                    <button type="submit" class="btn btn-primary">Add Item</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Delete Confirmation (Example) -->
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Initialize DataTables -->
<script>
    // $(document).ready(function() {
    //     $('#menuTable').DataTable({
    //         responsive: true,  // Enable responsiveness
    //         paging: true,      // Enable pagination
    //         searching: true,   // Enable search box
    //         ordering: true,    // Enable sorting on columns
    //     });
    // });
</script>
