<div class="container mt-4">
    <h2>Places Management</h2>

    <!-- Tabs -->
    <ul class="nav nav-tabs mt-4" id="placesTab" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="restaurant-tab" data-toggle="tab" href="#restaurant" role="tab">Restaurant</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="hotel-tab" data-toggle="tab" href="#hotel" role="tab">Hotel</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="groceries-tab" data-toggle="tab" href="#groceries" role="tab">Groceries</a>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content mt-3" id="placesTabContent">
        <!-- Restaurant Tab -->
        <div class="tab-pane fade show active" id="restaurant" role="tabpanel">
            <?php if (!empty($places['restaurant'])) : ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Location</th>
                            <th>Menu</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($places['restaurant'] as $place) : ?>
                            <tr>
                                <td><?= htmlspecialchars($place['name']) ?></td>
                                <td><?= htmlspecialchars($place['description']) ?></td>
                                <td><?= htmlspecialchars($place['location']) ?></td>
                                <td><a href="<?= base_url('customer/menu/' . $place['id']) ?>" class="btn btn-sm btn-info">Menu</a></td>
                                <td>
                                    <a href="<?= base_url('customer/edit_place/' . $place['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('customer/delete_place/' . $place['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this place?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else : ?>
                <p>No restaurants found.</p>
            <?php endif; ?>
        </div>

        <!-- Hotel Tab -->
        <div class="tab-pane fade" id="hotel" role="tabpanel">
            <?php if (!empty($places['hotel'])) : ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Location</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($places['hotel'] as $place) : ?>
                            <tr>
                                <td><?= htmlspecialchars($place['name']) ?></td>
                                <td><?= htmlspecialchars($place['description']) ?></td>
                                <td><?= htmlspecialchars($place['location']) ?></td>
                                <td>
                                    <a href="<?= base_url('customer/edit_place/' . $place['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('customer/delete_place/' . $place['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this place?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else : ?>
                <p>No hotels found.</p>
            <?php endif; ?>
        </div>

        <!-- Groceries Tab -->
        <div class="tab-pane fade" id="groceries" role="tabpanel">
            <?php if (!empty($places['groceries'])) : ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Location</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($places['groceries'] as $place) : ?>
                            <tr>
                                <td><?= htmlspecialchars($place['name']) ?></td>
                                <td><?= htmlspecialchars($place['description']) ?></td>
                                <td><?= htmlspecialchars($place['location']) ?></td>
                                <td>
                                    <a href="<?= base_url('customer/edit_place/' . $place['id']) ?>" class="btn btn-sm btn-warning">Edit</a>
                                    <a href="<?= base_url('customer/delete_place/' . $place['id']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this place?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else : ?>
                <p>No groceries found.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
