<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Kreait\Firebase\Exception\FirebaseException;
//use Throwable;

class Api extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding, Authorization");
        
        $this->load->helper('url');
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');

    }
  
    public function login()
	{

		$email = $this->input->post("email");
 		$password = $this->input->post("password");


		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();
		
		try {

			$signInResult = $auth->signInWithEmailAndPassword($email, $password);
            $my = $signInResult->data();
            $admin=$this->common->readdatadocument("Users",$my['localId']);	
            $admin['userId']=$my['localId'];
            $data['success']=1;
            $data['user']=$admin;
            header('Content-type: application/json');

            echo json_encode($data);
            exit;

			

		}  catch (\Kreait\Firebase\Exception\Auth\InvalidPassword $e) {
            $data['success']=0;
            $data['message']='Invalid email or password!';
            header('Content-type: application/json');

            echo json_encode($data);
            exit;
            
        } catch (\Kreait\Firebase\Exception\Auth\UserNotFound $e) {
            $data['success']=0;
            $data['message']='User not found!';
            header('Content-type: application/json');

            echo json_encode($data);
            exit;
       
        } catch (\Exception $e) {
            $data['success']=0;
            $data['message']= 'An error occurred: ' . $e->getMessage();
            header('Content-type: application/json');

            echo json_encode($data);
            exit;

        }
    }
public function listofdog(){
    $userId=$this->input->post('userId');
$dog=$this->common->readdatafromcollectionwhereclause("PetModel","userID","==",$userId);
$data['success']=1;
$data['pets']=$dog;
header('Content-type: application/json');

echo json_encode($data);
exit;          

}
public function adddog(){
    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();
    $jana=array();
    if ($_FILES['file']['tmp_name'] != '') {
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['file']['tmp_name']),
            [
                'name' => "permo" . rand() . time() . $_FILES['file']['name'],
            ]
        );

        $jana[0] = $uploadedFile->info()['mediaLink'];
    }
    $d=$this->input->post();
    $d['createdDate']=time()*1000;
    $d['isPrimaray']=false;
    $d['dob']=strtotime($d['dob'])*1000;
    $d['userImages']=$jana;
    $id=rand().time().rand();
    $d['id']=$id;
   $res= $this->common->adddatamodel("PetModel",$id,$d);
$data['success']=1;
$data['message']="Pets has been Added";
header('Content-type: application/json');

echo json_encode($data);
exit;          

    

}


public function addorder(){
    $d=$this->input->post();
    $petID=$this->input->post('petID');
    $userId=$this->input->post('userId');
    $petinfo=$this->common->readdatadocument("PetModel",$petID);
    $userinfo=$this->common->readdatadocument("Users",$userId);
    if($petinfo=="" || empty($petinfo)){
        $data['success']=1;
        $data['message']="Pets is not available";
        header('Content-type: application/json');

        echo json_encode($data);
        exit;          
    }else if($userinfo=="" || empty($userinfo)){
        $data['success']=1;
        $data['message']="User is not available";
        header('Content-type: application/json');

        echo json_encode($data);
        exit;          
    }else{
       $orderinfo=array();
       $orderinfo['Address']=$d['Address'];
       $orderinfo['lat']=$d['lat']*1;
       $orderinfo['lng']=$d['lng']*1;
       $orderinfo['petID']=$d['petID'];
       $orderinfo['price']=$d['price']*1;
       $orderinfo['userId']=$d['userId'];
       
       $orderinfo['Qty']=1; 
       $orderinfo['clientSecret']=$d['clientSecret'];
       $orderinfo['createdDate']=time()*1000;
       $orderinfo['dob']=$petinfo['dob']; 
       $orderinfo['gender']=$petinfo['gender']; 
       $orderinfo['petColor']=$petinfo['dogColor'];
       $orderinfo['petName']=$petinfo['dogName']; 
       
       $orderinfo['paymentStatus']="paid";
       $orderinfo['status']="Order";
       $orderinfo['kitOrdersData']=array("Order"=>time()*1000);
       $orderinfo['ownerName']=$d['ownerName'];
       $orderinfo['phone']=$d['phone'];
       $orderinfo['from']="web";
       $id=rand().time().rand();
    $orderinfo['id']=$id;
   $res= $this->common->adddatamodel("Orders",$id,$orderinfo);
$data['success']=1;
$data['message']="Order  has been Placed";
header('Content-type: application/json');

echo json_encode($data);
exit;          
   
       

    }

}

    public function signup(){
        try {
        $postData=$this->input->post();
        $email = $postData['email'] ?? '';
        $password = $postData['password'] ?? '';
        $firstName = $postData['firstName'] ?? '';
        $lastName = $postData['lastName'] ?? '';
        $phone = $postData['phone'] ?? '';
        $address = $postData['address'] ?? '';
        $lat = $postData['lat'] ?? '';
        $lng = $postData['lng'] ?? '';
        if (strlen($password) < 6) {
            $data['success']=0;
            $data['message']='Password must be at least 6 characters long.';
            header('Content-type: application/json');

            echo json_encode($data);
            exit;
        }
        $userProperties = [
            'email' => $email,
            'password' => $password,
            'phoneNumber' => $phone,
            'displayName' => "$firstName $lastName"
        ];
		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();

        $createdUser = $auth->createUser($userProperties);
        $userId = $createdUser->uid;
        $signUpMap = [
            'userId' => $userId,
            'password' => $password,
            'address' => $address,
            'deviceType' => 'Web',
            'email' => $email,
            'firstName' => $firstName,
            'fullname' => "$firstName $lastName",
            'lastName' => $lastName,
            'lat' => $lat*1,
            'lng' => $lng*1,
            'phoneNumber' => $phone,
            'userRole' => 'user',
            'createdDate' => time()
        ];
        $this->common->adddatamodel("Users",$userId,$signUpMap);
        header('Content-type: application/json');

        $data['success']=1;
        $data['message']= 'User created successfully';
        $data['userId']=$userId;
        echo json_encode($data);
        exit;          

    }catch (\Kreait\Firebase\Exception\AuthException $e) {
       
                     $data['success']=0;
                     $data['message']= 'error: ' . $e->getMessage();
                     header('Content-type: application/json');

                     echo json_encode($data);
                     exit;            
    } catch (\Exception $e) {
                    $data['success']=0;
                    $data['message']= 'error: ' . $e->getMessage();
                    header('Content-type: application/json');

                    echo json_encode($data);
                    exit;         
    }
}






}
