<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }
  
  public function results()
  {
    $data["settings"] = "";
    
    
    $this->template->template_render('settings', $data);
  }

  

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Settings has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
    $data['freelancers'] = $this->common->readnumberofdocumentsincollection('PetModel');
    $data['users'] = $this->common->readnumberofdocumentsincollectionbetween('Users', 'userRole', '=', 'user');
 //   $data['totalUsers'] = $this->common->readnumberofdocumentsincollection('Users');
    $data['categories'] = $this->common->readnumberofdocumentsincollection('Orders');
   
    $users = $this->common->readdatafromcollectionwhereclause("Users",'userRole', '!=', 'admin');
    $data['users']=count($users);
      foreach ($users as $key => $user) {
        $timestamps[$key]    = $user['createdDate'];
    }
    array_multisort($timestamps, SORT_ASC, $users);
    $labels = array();

    $labels[0] = date('F', strtotime(date('F')." - 3 months"));
    for($i =1; $i<=5; $i++) {
      $timestamp = strtotime($labels[$i-1].' + 1 month');
      $labels[$i] = date('F', $timestamp);
    }
    $labelStr = '';
    foreach($labels as $label) {
      $labelStr .= '"'.$label.'", ';
    }
    
    $data['labelStr'] = $labelStr;
    $dataStr = '';
    for($i =0; $i<count($labels); $i++) {
      $num = 0;
      foreach($timestamps as $timestamp) {
        if($labels[$i] == date('F', $timestamp/1000)) {
          $num += 1;
        }
      }
      $dataStr .= $num.',';
    }
    $data['dataStr'] = $dataStr;

   
    $this->template->template_render('dashboard', $data);
  }

  public function categories()
	{

		$data['categories'] = $this->common->readdatafromcollectionwhereclause('Category');
		$this->template->template_render('categories', $data);
	}

  public function orders()
	{

		$data['rides'] = $this->common->readdatafromcollectionwhereclause('Orders');
		$this->template->template_render('income', $data);
	}

  public function reviewandrating()
	{

		$data['rides'] = $this->common->readdatafromcollectionwhereclause('AppRating');
		$this->template->template_render('reviewandrating', $data);
	}

  public function updatetracking($id){
    $data=$this->input->post();
    $response = $this->common->updatedatamodel('Orders', $id, $data);
    redirect(base_url().'dashboard/orders');

  }

  public function balti(){
    $title="Order Info";
    $body="Your Order has been Accept";
    $token="dSJn3m98G0J9iiPT7AtQuI:APA91bG6HnFVVmrazvbYmq1Pg-BKqvmoVsb4h02AJg7-leDVTzngdB0D8al7Cqaf2xfve-QJ7lzXW3UZAPrferoOWpj7hoEU32PIQhkzOCzhOduRBzWV4Is";
      
   $data= $this->send_push_notification($token,$title,$body,$id,"accept");
    echo "<pre>";
    print_r($data);
    echo "</pre>";
  }
  public function send_push_notification($tokenId,$title,$body,$orderid,$type)
  {
      // Example device token
      $deviceToken =$tokenId;

      // Notification details
      $data = [
          'orderId' => $orderid,
          'status' => $type,
          'type'=>'order'
      ];

      // Send the notification
      $result = $this->firebase->sendPushNotification($deviceToken, $title, $body, $data);

      // Display result
      if ($result['success']) {
          echo "Notification sent successfully!<br>";
          echo "Result: " . print_r($result['result'], true);
      } else {
          echo "Failed to send notification!<br>";
          echo "Error: " . $result['error'];
      }
  }
  public function updateorder($id){   
    $orders=$this->common->readdatadocument('Orders', $id);
    $userinfo=$this->common->readdatadocument('Users', $orders['userId']);

    $data=$this->input->post();
    if($userinfo !=""){
      if($userinfo['token'] !=""){
    if($data['status']=="Ordered"){
    $title="Order Info";
    $body="Your Order has been Accept";
    $token=$userinfo['token'];
//senderId
//userIds
//timestamp
//type//
//message
//title//
    $petar=array();
    $petar[0]=$orders['userId'];
    $ceta=array();
    $ceta['senderId']="";
    $ceta['timestamp']=time()*1000;
    $ceta['type']="order";
    $ceta['message']=$body;
    $ceta['title']=$title;
    $ceta['userIds']=$petar;
    $ceta['orderId']=$id;

      $response = $this->common->addnewdatamodel('Notifications',$ceta);

      



    $this->send_push_notification($token,$title,$body,$id,$data['status']);
    }else{
      $title="Order Info";
      $body="Your Order has been ".$data['status'];
      $token=$userinfo['token'];

      $petar=array();
      $petar[0]=$orders['userId'];
      $ceta=array();
      $ceta['senderId']="";
      $ceta['timestamp']=time()*1000;
      $ceta['type']="order";
      $ceta['message']=$body;
      $ceta['title']=$title;
      $ceta['userIds']=$petar;
      $ceta['orderId']=$id;
  
        $response = $this->common->addnewdatamodel('Notifications',$ceta);
  


      $this->send_push_notification($token,$title,$body,$id,$data['status']);
    }
  }
  }


    // echo "<prE>";
    // print_r($orders);
    // print_r($userinfo);
    // print_r($data);
    // echo "</pre>";
    // exit;






    $mydata=$orders['kitOrdersData'];

    $mydata[$data['status']]=time()*1000;
    $jana['kitOrdersData']=$mydata;

    if($data['status']=="Ship" ||  $data['status']=="Shipped" ||  $data['status']=="Ordered" ||  $data['status']=="Transit" ||  $data['status']=="Transited" || $data['status']=="Deliver" || $data['status']=="Delivered" || $data['status']=="Complete" || $data['status']=="Completed" || $data['status']=="Process" || $data['status']=="Processed" || $data['status']=="Receive" || $data['status']=="Received"){
      $jana['status']=$data['status'];
    }
/*
    if($data['status']=="Completed"){
      $jana['result']=$this->input->post('result');
    }
*/
    //array_push($mydata,$jana);
		$response = $this->common->updatedatamodel('Orders', $id, $jana);
    /*
    if($data['status']=="Completed"){
        $d['userId']=$orders['userId'];
        $d['orderId']=$id;
        $d['result']=$this->input->post('result');
        $d['time']=time()*1000;
        $this->common->updateOrInsertFirestore('labResult', $d['userId'], $d);


    }
*/

redirect(base_url().'dashboard/orders');

    // echo "<pre>";
    // print_r($orders);
    // print_r($data);
    // print_r($mydata);
    // echo "</pre>";
  }

  public function subcategories()
	{
    $jana=array();
    $catelist = $this->common->readdatafromcollectionwhereclause('Category');
    foreach($catelist as $c=>$d){
      $jana[$c]=$d['name'];

    }
    $data['catelist']=$jana;
   
		$data['categories'] = $this->common->readdatafromcollectionwhereclause('SubCategory');
		$this->template->template_render('subcategories', $data);
	}

  public function addcategory()
	{

		$this->template->template_render('addcategory');
	}

  public function addsubcategory()
	{
    $data['catelist'] = $this->common->readdatafromcollectionwhereclause('Category');
		$this->template->template_render('addsubcategory',$data);
	}
//insertsubcategory
public function updatesubcategory()
	{
    $data = $this->input->post();
		$response = $this->common->updatedatamodel('SubCategory', $data['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'SubCategory updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));
	}

public function insertsubcategory()
	{
		$firebase = $this->firebase->init();
        $storage = $firebase->createStorage();
        $defaultBucket = $storage->getBucket();	
	    	$data = $this->input->post();
   
   
    $response = $this->common->addnewdatamodel('SubCategory', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'SubCategory added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));		
	}

  //addsubcategory
  public function insertcategory()
	{
		$firebase = $this->firebase->init();
        $storage = $firebase->createStorage();
        $defaultBucket = $storage->getBucket();	
		$data = $this->input->post();
   
    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['icon'] = $uploadedFile->info()['mediaLink'];
    }
    if ($_FILES['grayimage']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['grayimage']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['grayimage']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['grayIcon'] = $uploadedFile->info()['mediaLink'];
    }

    $response = $this->common->addnewdatamodel('Category', $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category added successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));		
	}
	public function editcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
		$data['category'] = $this->common->readdatadocument('Category', $id);
		$this->template->template_render('addcategory', $data);
	}

  
	public function editsubcategory()
	{
		$id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['catelist'] = $this->common->readdatafromcollectionwhereclause('Category');
    $data['category'] = $this->common->readdatadocument('SubCategory', $id);
		$this->template->template_render('addsubcategory', $data);
	}
	public function updatecategory()
	{
    $data = $this->input->post();
    if ($_FILES['image']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['image']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['image']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['icon'] = $uploadedFile->info()['mediaLink'];
    }
    if ($_FILES['grayimage']['tmp_name'] != '') {
      $fileName = "events" . rand() . time() . $_FILES['grayimage']['name'];
      $uploadedFile = $defaultBucket->upload(
        file_get_contents($_FILES['grayimage']['tmp_name']),
        [
          'name' => $fileName,
  'predefinedAcl' => 'publicRead'
        ]
      );
      // $data['image'] = 'https://firebasestorage.googleapis.com/v0/b/tattoo-f01b9.appspot.com/o/'.$fileName.'?alt=media';
    $data['grayIcon'] = $uploadedFile->info()['mediaLink'];
    }


		$response = $this->common->updatedatamodel('Category', $data['id'], $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category updated successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}


  public function deleteorder()
	{
    $id = $this->input->post('orderId');

		$response = $this->common->deletedatamodel('Orders', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Orders deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/orders'));
	}



  public function deletecategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('Category', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Category deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/categories'));
	}

  
  public function deletesubcategory()
	{
    $id = $this->uri->segment(3);

		$response = $this->common->deletedatamodel('SubCategory', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'SubCategory deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('dashboard/subcategories'));
	}
}