<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use Google\Cloud\Firestore\FirestoreClient;

class Template {

    protected $CI;

	//To initialize variables, functions and libraries
    public function __construct()
    {	
		$this->CI =& get_instance();
        $this->CI->load->library('session');

    }

    //To render admin contents
    public function template_render($content, $data = NULL)
    {
        if ( ! $content)
        {
            return NULL;
        }
        else
        {
            $x = $this->CI->config->item('firebase_app_key');
            $firestore = new FirestoreClient([
                'projectId' => $this->CI->config->item('firebase_project_id'),
                'keyFile' => json_decode(file_get_contents($x), true)
            ]);
            $reportRef = $firestore->collection('Reports');
		    $newReports = 0;
		    $documents = $reportRef->documents();
            foreach ($documents as $document) {
                if ($document->exists()) {
                    $report = $document->data();
                    if($report['isRead'] !== true) {
                        $newReports++;
                    }
                }
            }
            $data['newReports'] = $newReports;
            $data['adminName'] = $this->CI->session->userdata('session_data')['name'];
            $data['permissions'] = $this->CI->session->userdata('session_data')['permissions'];
            $this->template['header']  = $this->CI->load->view('header', $data, TRUE);
            $this->template['sidebar']  = $this->CI->load->view('sidebar', $data, TRUE);
            $this->template['topbar']  = $this->CI->load->view('topbar', $data, TRUE);
            $this->template['content'] = $this->CI->load->view($content, $data, TRUE);
            $this->template['footer']  = $this->CI->load->view('footer', $data, TRUE);
            return $this->CI->load->view('template', $this->template);
        }
	}
}