<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Restserver\Libraries\REST_Controller;

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Reminders extends REST_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load the reminder_model
        $this->load->model('reminder_model');
        // Load the form validation library
        $this->load->library('form_validation');
        // Configure the validation rules
        $this->form_validation->set_rules('user_id', 'UserId', 'required');
    }

    public function index_get($id)
    {
        // Get a single reminder by ID
        if ($id !== NULL) {
            $reminder = $this->reminder_model->get_reminder($id);
            if ($reminder) {
                $this->response($reminder, REST_Controller::HTTP_OK);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => 'reminder not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        } else {
            // Get all reminders
            $reminders = $this->reminder_model->get_reminders();
            $this->response($reminders, REST_Controller::HTTP_OK);
        }
    }

    public function index_post()
    {
        // Create a new reminder
        $data = $this->post();

        if ($this->form_validation->set_data($data) == FALSE) {
            $this->response([
                'status' => FALSE,
                'message' => validation_errors()
            ], REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $reminder_id = time();
            $reminder = $this->reminder_model->create_reminder($reminder_id, $data);
            if ($reminder) {
                $this->response([
                    'status' => TRUE,
                    'message' => 'reminder created successfully',
                    'data' => [$reminder_id => $reminder]
                ], REST_Controller::HTTP_CREATED);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => "Oops Something went wrong. Please try again."
                ], REST_Controller::HTTP_BAD_REQUEST);
            }
        }
        // $this->response([
        // 	'status' => TRUE,
        // 	'data' => ['data' => $password]
        // ]);
    }

    public function index_patch($id)
    {
        // Update an existing reminder by ID
        $data = $this->patch();
        $updated = $this->reminder_model->update_reminder($id, $data);
        if ($updated) {
            $this->response([
                'status' => TRUE,
                'message' => 'reminder updated successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Oops Something went wrong. Please try again.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function index_delete($id)
    {
        // Delete an existing reminder by ID
        $deleted = $this->reminder_model->delete_reminder($id);
        if ($deleted) {
            $this->response([
                'status' => TRUE,
                'message' => 'reminder deleted successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Failed to delete reminder'
            ], REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
