<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Restserver\Libraries\REST_Controller;

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Subscriptions extends REST_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load the subscription_model
        $this->load->model('subscription_model');
        // Load the form validation library
        $this->load->library('form_validation');
        // Configure the validation rules
        $this->form_validation->set_rules('id', 'Id', 'required');
    }

    public function index_get($id)
    {
        // Get a single subscription by ID
        if ($id !== NULL) {
            $subscription = $this->subscription_model->get_subscription($id);
            if ($subscription) {
                $this->response($subscription, REST_Controller::HTTP_OK);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => 'subscription not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        } else {
            // Get all subscriptions
            $subscriptions = $this->subscription_model->get_subscriptions();
            $this->response($subscriptions, REST_Controller::HTTP_OK);
        }
    }

    public function index_post()
    {
        // Create a new subscription
        $data = $this->post();

        if ($this->form_validation->set_data($data) == FALSE) {
            $this->response([
                'status' => FALSE,
                'message' => validation_errors()
            ], REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $subscription_id = $this->subscription_model->create_subscription($data);
            if ($subscription_id) {
                $this->response([
                    'status' => TRUE,
                    'message' => 'subscription created successfully',
                    'data' => ['subscription_id' => $subscription_id]
                ], REST_Controller::HTTP_CREATED);
            } else {
                $this->response([
                    'status' => FALSE,
                    'message' => "Oops Something went wrong. Please try again."
                ], REST_Controller::HTTP_BAD_REQUEST);
            }
        }
        // $this->response([
        // 	'status' => TRUE,
        // 	'data' => ['data' => $password]
        // ]);
    }

    public function index_patch($id)
    {
        // Update an existing subscription by ID
        $data = $this->patch();
        $updated = $this->subscription_model->update_subscription($id, $data);
        if ($updated) {
            $this->response([
                'status' => TRUE,
                'message' => 'subscription updated successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Oops Something went wrong. Please try again.'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function index_delete($id)
    {
        // Delete an existing subscription by ID
        $deleted = $this->subscription_model->delete_subscription($id);
        if ($deleted) {
            $this->response([
                'status' => TRUE,
                'message' => 'subscription deleted successfully'
            ], REST_Controller::HTTP_OK);
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'Failed to delete subscription'
            ], REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}
