<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Vendors extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->model('drivers_model');
		$this->load->model('vehicle_model');
		$this->load->model('common');
		$this->load->model('customer_model');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['vendorlist'] = $this->drivers_model->getall_vendor();
		
		$this->template->template_render('vendors_management', $data);
	}
	public function approvedVendor()
	{
		$data['vendorlist'] = $this->drivers_model->getall_approvedvendor();
		
		$this->template->template_render('vendors_management', $data);
	}
	public function adddrivers()
	{
		$this->template->template_render('drivers_add');
	}
	public function per_kmm()
	{
		$this->template->template_render('per_km');
	}

	public function driverratings()
	{
		$this->template->template_render('driver_ratings');
	}

	public function view_vehicle($id)
	{
		$this->data['driverdetails'] = $this->drivers_model->get_driverdetails($id);
		$this->data['vehicledetails'] = $this->vehicle_model->get_vehicleByDriver($id);
		$this->data["driverId"] = $id;
		$this->template->template_render('view_vehicle', $this->data);
	}

	public function edit_driver_info($id)
	{
		$this->data['driverdetails'] = $this->drivers_model->get_driverdetails($id);
		$this->data['vehicledetails'] = $this->vehicle_model->get_vehicleByDriver($id);
		$this->data['vehicleId'] = $this->vehicle_model->get_vehicleIdByDriver($id);
		$this->data['driverId'] = $id;
		$this->template->template_render('edit_driver', $this->data);
	}

	public function approveVendor($id)
	{
	
	
		$data["isApproved"] = true;
		$response = $this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Vendor Approved');	
		// if($driverdetails["stripeStatus"] == "approved"){
		
		// } else {
		// 	$this->session->set_flashdata('warningmessage', 'Driver Stripe Status is not approved yet.');				
		// }
		redirect('vendors');
	}

	public function disablevendor($id)
	{
		$data["isApproved"] = false;
		$response = $this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'Vendor Rejected');
		redirect('vendors');
	}

	public function suspendDriver($id)
	{
		$data["id"] = $id;
		$data["isVerified"] = "suspended";
		$data["isApproved"] = FALSE;
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Driver Suspended');
		redirect('drivers');
	}

	public function deleteDriver($id)
	{
		$response = $this->drivers_model->delete_driver($id);
		if(!$response){
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting auth.');
			redirect('drivers');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'Driver Deleted');
		redirect('drivers');
	}

	public function deletevendor($id)
	{
		$response = $this->drivers_model->delete_driver($id);
		if(!$response){
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting auth.');
			redirect('vendors');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'vendors Deleted');
		redirect('vendors');
	}
	public function Driveraccountinfo()
	{
		$this->template->template_render('driveraccountinformation');
	}



	public function insertdriver()
	{
		$this->form_validation->set_rules('licenseno', 'License Number', 'required|trim|is_unique[vehicles.v_registration_no]');
		$this->form_validation->set_message('is_unique', '%s is already exist');
		$this->form_validation->set_rules('name', 'Name', 'required|trim');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|trim');
		$this->form_validation->set_rules('address', 'Address', 'required|trim');
		$this->form_validation->set_rules('age', 'Age', 'required|trim');
		$this->form_validation->set_rules('licenseno', 'License Number', 'required|trim');
		$this->form_validation->set_rules('license_expdate', 'License Exp Date', 'required|trim');
		$this->form_validation->set_rules('total_exp', 'Total Experiance', 'required|trim');
		$this->form_validation->set_rules('doj', 'Date of Joining', 'required|trim');
		$testxss = xssclean($_POST);
		// print_r($_POST);
		// exit;

		foreach ($_POST as $key => $val) {
			if (strpos($key, "d_") === 0) {
				$name = substr($key, 2);
				$data["driver"][$name] = $val;
			}
		}

		$data["driver"]['carType']=$this->input->post('v_carType');

		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		if ($_FILES['v_proofOfInsurance']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfInsurance']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfInsurance']['name'],
				]
			);

			$data["vehicle"]['insuranceUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_proofOfRegistration']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfRegistration']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfRegistration']['name'],
				]
			);

			$data["vehicle"]['registrationUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontPicture']['name'],
				]
			);

			$data["vehicle"]['frontCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_leftPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_leftPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_leftPicture']['name'],
				]
			);

			$data["vehicle"]['leftCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_license']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_license']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_license']['name'],
				]
			);

			$data["vehicle"]['licenseUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rightPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rightPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rightPicture']['name'],
				]
			);

			$data["vehicle"]['rightCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rearPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rearPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rearPicture']['name'],
				]
			);

			$data["vehicle"]['rearCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontInterior']['name'],
				]
			);

			$data["vehicle"]['frontInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_backInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_backInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_backInterior']['name'],
				]
			);

			$data["vehicle"]['backInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}

		foreach ($_POST as $key => $val) {
			if (strpos($key, "v_") === 0) {
				$name = substr($key, 2);
				$data["vehicle"][$name] = $val;
			}
		}

		$data["driver"]["userRole"] = "driver";

		$response = $this->drivers_model->add_drivers($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New driver added successfully..');
			redirect('drivers');
		} else {
			$errormsg = 'Error! User Already Exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('drivers/adddrivers');
		}
	}
	public function editvendor()
	{
		$d_id = $this->uri->segment(3);
		$data['vendorinfo'] = $this->drivers_model->get_driverdetails($d_id);
		$data['id']=$d_id;
		$this->template->template_render('editvendor', $data);
	}


	public function updatevendorsdata($id)
	{
		$da = $this->input->post();
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		if ($_FILES['imagefile']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['imagefile']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['imagefile']['name'],
				]
			);

			$da["image"] = $uploadedFile->info()['mediaLink'];
		}
	
		//print_r($da);
		if ($da['newpassword'] != "") {

			$da['password'] = $da['newpassword'];
			$da['newpassword'] = "";
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);




			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'Usome thing error Please try later');

				//redirect('customer/editcustomer/'.$id);
			}
		} else {
			$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}



		redirect('vendors/editvendor/' . $id);
	}

	public function updatedriver()
	{
		foreach ($_POST as $key => $val) {
			if (strpos($key, "d_") === 0) {
				$name = substr($key, 2);
				$data["driver"][$name] = $val;
			}
		}
// echo "<pre>";
// print_r($this->input->post());
// echo "</pre>";
// print_r($data["driver"]);
if($data["driver"]['newpassword'] != ""){
	
	$data["driver"]['password']=$data["driver"]['newpassword'];
	$data["driver"]['newpassword']="";
	 $flag=$this->customer_model->update_customerpassword($data["driver"]['id'],$data["driver"]['password']);




	if($flag){
			
		
		
	}else{
$this->session->set_flashdata('warningmessage', 'Usome thing error Please try later');
redirect('drivers');
		//redirect('customer/editcustomer/'.$id);
	}

	
}

// echo "<pre>";
// print_r($data['driver']);
// echo "</pre>";
// exit;
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		if ($_FILES['v_proofOfInsurance']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfInsurance']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfInsurance']['name'],
				]
			);

			$data["vehicle"]['insuranceUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_proofOfRegistration']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfRegistration']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfRegistration']['name'],
				]
			);

			$data["vehicle"]['registrationUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontPicture']['name'],
				]
			);

			$data["vehicle"]['frontCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_leftPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_leftPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_leftPicture']['name'],
				]
			);

			$data["vehicle"]['leftCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_license']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_license']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_license']['name'],
				]
			);

			$data["vehicle"]['licenseUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rightPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rightPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rightPicture']['name'],
				]
			);

			$data["vehicle"]['rightCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rearPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rearPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rearPicture']['name'],
				]
			);

			$data["vehicle"]['rearCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontInterior']['name'],
				]
			);

			$data["vehicle"]['frontInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_backInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_backInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_backInterior']['name'],
				]
			);

			$data["vehicle"]['backInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}

		foreach ($_POST as $key => $val) {
			if (strpos($key, "v_") === 0) {
				$name = substr($key, 2);
				$data["vehicle"][$name] = $val;
			}
		}

		$response = $this->common->updatedatamodel("Users", $data["driver"]["id"], $data["driver"]);
		$response = $this->common->updatedatamodel("Vehicle", $data["vehicle"]["id"], $data["vehicle"]);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Data Edited successfully..');
			redirect('drivers');
		} else {
			$errormsg = 'Seomething went wrong.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('drivers');
		}
	}
}
