<?php
$datearray_json = json_encode($datearray);
$bookingcomplete_json= json_encode($bookingcomplete);
$nosales_json= json_encode($nosales);
$totalsale_json= json_encode($totalsale);
$retailsale_json= json_encode($retailsale);

?>
<div class="row">
       <div class="col-md-8 my-2">
           <h3 class="fmon">Dashboard</h3>
       </div>

   </div>
   <div class="row">
       <div class="col-md-3">
           <div class="card pCard">
               <div class="card-body">
                   <div class="d-flex align-items-center">
                       <img src="./assets/images/prod.png" alt="" width="50px">
                       <div class="ms-3">
                           <p class="m-0 fs1">Completed Bookings</p>
                           <p class="m-0 fs2">Get Lyft'd</p>
                       </div>
                   </div>
                   <div class="mt-3">
                       <h2 class="m-0" id="totalbooking">0</h2>
                       <small class="fs3">Total</small>
                   </div>
               </div>
           </div>
       </div>
       <div class="col-md-3">
           <div class="card cCard">
               <div class="card-body">
                   <div class="d-flex align-items-center">
                       <img src="./assets/images/cust.png" alt="" width="50px">
                       <div class="ms-3">
                           <p class="m-0 fs1">Product Sales</p>
                           <p class="m-0 fs2">Get Lyft'd</p>
                       </div>
                   </div>
                   <div class="mt-3">
                       <h2 class="m-0" id="totalproductsale">0</h2>
                       <small class="fs3">Total</small>
                   </div>
               </div>
           </div>
       </div>

       <div class="col-md-3">
           <div class="card dCard">
               <div class="card-body">
                   <div class="d-flex align-items-center">
                       <img src="./assets/images/driv.png" alt="" width="50px">
                       <div class="ms-3">
                           <p class="m-0 fs1">Base Revenue</p>
                           <p class="m-0 fs2">Get Lyft'd</p>
                       </div>
                   </div>
                   <div class="mt-3">
                       <h2 class="m-0" id="totalsale">0</h2>
                       <small class="fs3">Total</small>
                   </div>
               </div>
           </div>
       </div>
       <div class="col-md-3">
           <div class="card vCard">
               <div class="card-body">
                   <div class="d-flex align-items-center">
                       <img src="./assets/images/vendr.png" alt="" width="50px">
                       <div class="ms-3">
                           <p class="m-0 fs1">Retail Revenue</p>
                           <p class="m-0 fs2">Get Lyft'd</p>
                       </div>
                   </div>
                   <div class="mt-3">
                       <h2 class="m-0" id="retailsale">0</h2>
                       <small class="fs3">Total</small>
                   </div>
               </div>
           </div>
       </div>

   </div>

   <div class="row my-2">
       <div class="my-2"></div>
       <div class="col-md-12">
           <div class="card">
               <div class="row">
                   <div class="col-md-4 offset-md-8 d-flex justify-content-end mt-2 mb-4">
                       <div class="dropdown d-none">
                           <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"
                               aria-expanded="false">
                               Date Filter
                           </button>
                           <ul class="dropdown-menu">
                               <li><a class="dropdown-item" href="#">1 Day Ago</a></li>
                               <li><a class="dropdown-item" href="#">1 Week ago</a></li>
                               <li><button type="button" class="btn dropdown-item " data-bs-toggle="modal"
                                       data-bs-target="#exampleModal">
                                       Custom
                                   </button></li>
                           </ul>
                       </div>
                   </div>
               </div>
               <!-- Modal -->
               <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                   aria-hidden="true">
                   <div class="modal-dialog">
                       <div class="modal-content">
                           <div class="modal-header">
                               <h1 class="modal-title fs-5" id="exampleModalLabel">Select Custom Date</h1>
                               <button type="button" class="btn-close" data-bs-dismiss="modal"
                                   aria-label="Close"></button>
                           </div>
                           <div class="modal-body">
                               <input class="form-control" type="text" id="dateRangePicker"
                                   style="margin-bottom: 20px;">
                           </div>

                       </div>
                   </div>
               </div>


               <div id="chart"></div>
           </div>
       </div>
   </div>
   <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

   <script>
       var dateArray = <?php echo $datearray_json; ?>;
       var bookingArray=<?php echo $bookingcomplete_json; ?>;
       var valuesArray = Object.values(bookingArray);
       var nosaleArray=<?php echo $nosales_json; ?>;
       var saleArray = Object.values(nosaleArray);
       var totalsale_Array=<?php echo $totalsale_json; ?>;
       var totalsaleArray = Object.values(totalsale_Array);
       var retailsale_Array=<?php echo $retailsale_json; ?>;
       var retailsaleArray = Object.values(retailsale_Array);
       
       
        
console.log(dateArray,bookingArray,valuesArray); 
var chartOptions = {
    series: [{
        name: 'Completed Bookings',
        data: valuesArray
    }, {
        name: 'Product Sales',
        data: saleArray // Weekly aggregated data
    }, {
        name: 'Base Revenue',
        data: totalsaleArray // Weekly aggregated data
    }, {
        name: 'Retail Revenue',
        data: retailsaleArray // Weekly aggregated data
    }],
    colors: ['#39D6FF', '#7A8192', '#FF5733', '#33FF57'], // Different colors for each series
    chart: {
        height: 350,
        type: 'area',
    },
    dataLabels: {
        enabled: false
    },
    stroke: {
        curve: 'smooth'
    },
    xaxis: {
        type: 'datetime',
        categories: dateArray
    },
    tooltip: {
        x: {
            format: 'dd MMM yyyy' // Show date in day/month/year format for weeks
        },
    },
};

var chart = new ApexCharts(document.querySelector("#chart"), chartOptions);
chart.render();

$(function() {
    $('#dateRangePicker').daterangepicker({
        opens: 'left',
        locale: {
            format: 'YYYY-MM-DD'
        }
    }, function(start, end, label) {
        var startDate = start.format('YYYY-MM-DD');
        var endDate = end.format('YYYY-MM-DD');
        // console.log("data select")
        // Update chart data based on the selected date range
        updateChartData(startDate, endDate);
    });
});

function updateChartData(startDate, endDate) {
    // Fetch new data based on the selected date range and update the chart
    // This is just an example. Replace it with your data fetching logic.
    var newCategories = [
        "2018-09-19T00:00:00.000Z",
        "2018-09-19T01:30:00.000Z",
        "2018-09-19T02:30:00.000Z",
        "2018-09-19T03:30:00.000Z",
        "2018-09-19T04:30:00.000Z",
        "2018-09-19T05:30:00.000Z",
        "2018-09-19T06:30:00.000Z"
    ];
    var newData = [{
        name: 'Completed Bookings',
        data: [11, 32, 45, 32, 34, 52, 41] // Update with filtered data
    }, {
        name: 'Product Sales',
        data: [11, 32, 45, 32, 34, 52, 41] // Update with filtered data
    }, {
        name: 'Base Revenue',
        data: [20, 30, 40, 50, 60, 70, 80] // Update with filtered data
    }, {
        name: 'Retail Revenue',
        data: [15, 25, 35, 45, 55, 65, 75] // Update with filtered data
    }];

    chart.updateOptions({
        xaxis: {
            categories: newCategories
        },
        series: newData
    });
}

   </script>