<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Cannabus</title>
    <!-- bootstrap cdn -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- custom css -->
    <link rel="stylesheet" href="<?= base_url(); ?>assets/css/style.css" />

    <!-- fontawesone link -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <!--favicon-->
    <link rel="icon" href="<?= base_url(); ?>assets/images/favicon-32x32.png" type="image/png" />
</head>

<body class="bg-main pt-5 pb-5">
    <div class="container-flid mt-5 pt-5 mb-5 pb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 my-2">
                    <p class="text-center fs1">Cannabus</p>
                    <p class="mt-5 mb-0 text-center fs2">Login</p>
                    <p class="fs3 text-center">
                        Enter your Login details to access your account
                    </p>
            
                    <div class="row mb-2">
                        <div class="col-md-12 my-2">
                        <?php $successMessage = $this->session->flashdata('successmessage');
      $warningmessage = $this->session->flashdata('warningmessage');
      if (isset($successMessage)) {
        echo '<div id="alertmessage" class="col-md-12">
          <div class="alert alert-success alert-dismissible">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                   ' . output($successMessage) . '
                  </div>
          </div>';
      }
      if (isset($warningmessage)) {
        echo '<div id="alertmessage" class="col-md-12">
          <div class="alert alert-warning alert-dismissible">
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                   ' . output($warningmessage) . '
                  </div>
          </div>';
      }
      ?>
                            <form action="<?= base_url() . 'login/login_action'; ?>" method="post">
                                <div class="my-2 row justify-content-center">
                                    <div class="col-md-6 my-2">
                                        <label for="email" class="fs3 mb-2">Email</label>
                                        <div class="input-group">
                                            <span class="input-group-text ipt" id="basic-addon1"><i
                                                    class="fa-regular fa-envelope" style="color: #b0b3b3"></i></span>
                                            <input class="form-control formInp py-2" type="text" placeholder="Email" name="email" required/>
                                        </div>
                                    </div>
                                </div>
                                <div class="my-2 row justify-content-center">
                                    <div class="col-md-6 my-2 position-relative">
                                        <label for="email" class="fs3 mb-2">Password</label>
                                        <div class="input-group">
                                            <span class="input-group-text ipt" id="basic-addon1"><img
                                                    src="<?= base_url(); ?>assets/images/lock.png" alt="" width="16px" /></span>
                                            <input class="form-control formInp2 py-2" name="password" required type="password"
                                                placeholder="Password" />
                                            <span class="input-group-text ipt2">
                                                <i class="fa-regular fa-eye eye"></i></span>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center align-items-center">
                                        <button type="submit"  class="btn my-2 signB py-3">
                                                Login In
                                            </button>

                                        </div>
                                        <a href="<?php echo base_url('forgot'); ?>" class="mb-0 d-none">
                                            <p class="text-end mt-2 fs5">Forgot Password?</p>
                                        </a>
                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous">
    </script>

    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const eyeIcons = document.querySelectorAll(".eye");

        eyeIcons.forEach(function(icon) {
            icon.addEventListener("click", function() {
                const passwordField = document.querySelector(".formInp2");
                if (passwordField.type === "password") {
                    passwordField.type = "text";
                    this.classList.remove("fa-eye");
                    this.classList.add("fa-eye-slash");
                } else {
                    passwordField.type = "password";
                    this.classList.remove("fa-eye-slash");
                    this.classList.add("fa-eye");
                }
            });
        });
    });
    </script>
</body>

</html>