<?php
// echo "<pre>";
// print_r($orderdetail);
// echo "</pre>";

function formatDate($timestamp)
{
    // Convert milliseconds to seconds
    $seconds = $timestamp / 1000;
    // Format the timestamp as a readable date
    return date("Y-m-d H:i:s", $seconds);
}
?>
<div class="my-5">
    <div class="row">
        <div class="col-lg-12 mx-auto fmon">
            <!-- Order Information Card -->
            <div class="mb-4">
                <div class="card-header">
                    <h4 class="card-title fmon mb-3 text-center fw-bold">Order Details</h4>
                    <hr class="my-2">
                </div>
                <div class="card-body fmon">
                    <?php if (isset($orderdetail)): ?>
                    <!-- Dynamic Order ID and Other Details -->
                    <h5 class="card-subtitle mb-3 text-danger">Order ID: <?php echo  $orderdetail['id']; ?></h5>

                    <div class="row mb-3">
                        <div class="col">
                            <h6><strong>Date:</strong> <?php echo formatDate($orderdetail['date'])  ?></h6>
                            <h6><strong>Payment ID:</strong> <?php echo $orderdetail['pm_id']; ?></h6>
                            <h6><strong>Status:</strong> <?php echo ucfirst($orderdetail['orderStatus']); ?>
                        <?php if($orderdetail['orderStatus'] =="cancelled" || $orderdetail['orderStatus'] =="cancel"){ ?> 
                            <a href="<?php echo base_url().'Orders/markasdisputed/'.$order_id ?>"  style="color:red;">Mark As Disputed</a>
                          <?php  }?>  
                        </h6>
                            <h6><strong>Driver Status:</strong> <?php echo ucfirst($orderdetail['driverStatus']); ?>
                            </h6>
                        </div>
                        <div class="col">
                            <h6><strong>Vendor ID:</strong> <?php echo $orderdetail['vendorId']; ?></h6>
                            <h6><strong>Total Price:</strong> $<?php echo $orderdetail['price']; ?></h6>
                            <h6><strong>Subtotal:</strong> $<?php echo $orderdetail['subtotal']; ?></h6>
                            <h6><strong>Service Fee:</strong> $<?php echo $orderdetail['service']; ?></h6>
                        </div>
                    </div>
                    <hr>

<div class="container my-4">
    <h4 class="mb-3">Payment Information</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-primary">
                <tr>

                    <th scope="col">Price</th>
                    <th scope="col">Service</th>
                    <th scope="col">Tax</th>
                    <th scope="col">Driver Share</th>
                    <th scope="col">Delivery Admin</th>
                   


                    <th scope="col">Vendor Price</th>
                   
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th scope="row">$<?php echo $orderdetail['price']; ?></th>
                    <td>$<?php echo $orderdetail['service']; ?></td>
                    <td>$<?php echo $orderdetail['tax']; ?></td>
                     <td>$<?php echo $orderdetail['delivery']/2; ?></td>
                     <td>$<?php echo $orderdetail['delivery']/2; ?></td>
                    
                   
                      <td>$<?php echo $orderdetail['vendorPrice']; ?></td>
                     
                </tr>
                <!-- Add more rows here if needed -->
            </tbody>
        </table>
    </div>
</div>

                    
                    <!-- Address Information -->
                    <h5 class="card-subtitle mb-3">Shipping Address</h5>
                    <?php if (isset($orderdetail['address'])): ?>
                    <ul class="list-group mb-4">
                        <li class="list-group-item"><strong>Country:</strong>
                            <?php echo $orderdetail['address']['country']; ?></li>
                        <li class="list-group-item"><strong>City:</strong>
                            <?php echo $orderdetail['address']['city']; ?></li>
                        <li class="list-group-item"><strong>State:</strong>
                            <?php echo $orderdetail['address']['state1']; ?></li>
                        <li class="list-group-item"><strong>Street Address:</strong>
                            <?php echo $orderdetail['address']['streetAddress1'] . ', ' . $orderdetail['address']['streetAddress2']; ?>
                        </li>
                        <li class="list-group-item"><strong>Phone Number:</strong>
                            <?php echo $orderdetail['address']['phoneNumber']; ?></li>
                        <li class="list-group-item"><strong>Notes:</strong>
                            <?php echo $orderdetail['address']['notes']; ?></li>
                        <li class="list-group-item"><strong>Latitude:</strong>
                            <?php echo $orderdetail['address']['addressLat']; ?></li>
                        <li class="list-group-item"><strong>Longitude:</strong>
                            <?php echo $orderdetail['address']['addressLng']; ?></li>
                        <li class="list-group-item"><strong>Name:</strong>
                            <?php echo $orderdetail['address']['name']; ?></li>
                    </ul>
                    <?php endif; ?>
                    <hr>
                    <!-- Product Information -->
                    <h5 class="card-subtitle mb-3">Products</h5>
                    <?php if (isset($orderdetail['productsData']) && is_array($orderdetail['productsData'])): ?>
                    <table class="table table-bordered">
                        <thead class="table-light">
                            <tr>
                                <th>Product Name</th>
                                <th>Unit</th>
                                <th>Nicotine Level</th>
                                <th>Price</th>
                                <th>Rating</th>
                                <th>Image</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orderdetail['productsData'] as $product): ?>
                            <tr>
                                <td><?php echo $product['productName']; ?></td>
                                <td><?php echo $product['productUnit']; ?></td>
                                <td><?php echo $product['nicotineLevel']; ?></td>
                                <td>$<?php echo $product['productPrice']; ?></td>
                                <td><?php echo $product['averageRating']; ?> / 5</td>
                                <td>
                                    <img src="<?php echo $product['productUrl']; ?>" alt="Product" style="width: 80px;">
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <?php endif; ?>
                    <hr>
                    <!-- Order Tracking -->
                    <h5 class="card-subtitle mb-3">Tracking</h5>
                    <?php if (isset($orderdetail['track']) && is_array($orderdetail['track'])): ?>
                    <ul class="list-group">
                        <?php foreach ($orderdetail['track'] as $track): ?>
                        <li class="list-group-item">
                            <span class="fw-bold"><?php echo $track['name']; ?></span> - Date:
                            <?php echo formatDate($track['date']); ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                    <?php else: ?>
                    <p>No order details available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>