<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Drivers extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->model('drivers_model');
		$this->load->model('vehicle_model');
		$this->load->model('common');
		$this->load->model('customer_model');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		//$data['driverslist'] = $this->drivers_model->getall_drivers();
		$data['driverslist'] = $this->drivers_model->getall_drivers();
		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		// exit;
		$this->template->template_render('drivers_management', $data);
	}
	public function adddrivers()
	{
		$this->template->template_render('drivers_add');
	}
	public function per_kmm()
	{
		$this->template->template_render('per_km');
	}

	public function driverratings()
	{
		$this->template->template_render('driver_ratings');
	}

	public function view_vehicle($id)
	{
		$this->data['driverdetails'] = $this->drivers_model->get_driverdetails($id);
		$this->data['vehicledetails'] = $this->vehicle_model->get_vehicleByDriver($id);
		$this->data["driverId"] = $id;
		$this->template->template_render('view_vehicle', $this->data);
	}

	public function edit_driver_info($id)
	{
		$this->data['driverdetails'] = $this->drivers_model->get_driverdetails($id);
		$this->data['vehicledetails'] = $this->vehicle_model->get_vehicleByDriver($id);
		$this->data['vehicleId'] = $this->vehicle_model->get_vehicleIdByDriver($id);
		$this->data['driverId'] = $id;
		$this->template->template_render('edit_driver', $this->data);
	}

	public function approveDriver($id)
	{
		$driverdetails = $this->drivers_model->get_driverdetails($id);
		$data["id"] = $id;
		$data["isVerified"] = "approved";
		$data["isApproved"] = TRUE;
		$data["stripeStatus"] = "approved";
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Driver Approved');	
		// if($driverdetails["stripeStatus"] == "approved"){
		
		// } else {
		// 	$this->session->set_flashdata('warningmessage', 'Driver Stripe Status is not approved yet.');				
		// }
		redirect('drivers');
	}

	public function rejectDriver($id)
	{
		$data["id"] = $id;
		$data["isVerified"] = "notApproved";
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Driver Rejected');
		redirect('drivers');
	}

	public function suspendDriver($id)
	{
		$data["id"] = $id;
		$data["isVerified"] = "suspended";
		$data["isApproved"] = FALSE;
		$response = $this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Driver Suspended');
		redirect('drivers');
	}

	public function deleteDriver($id)
	{
		$response = $this->drivers_model->delete_driver($id);
		if(!$response){
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting auth.');
			redirect('drivers');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'Driver Deleted');
		redirect('drivers');
	}

	public function Driveraccountinfo()
	{
		$this->template->template_render('driveraccountinformation');
	}



	public function insertdriver()
	{
		$this->form_validation->set_rules('licenseno', 'License Number', 'required|trim|is_unique[vehicles.v_registration_no]');
		$this->form_validation->set_message('is_unique', '%s is already exist');
		$this->form_validation->set_rules('name', 'Name', 'required|trim');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|trim');
		
		
		$testxss = xssclean($_POST);
		// print_r($_POST);
		// exit;

		foreach ($_POST as $key => $val) {
			if (strpos($key, "d_") === 0) {
				$name = substr($key, 2);
				$data["driver"][$name] = $val;
			}
		}

		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		if ($_FILES['v_licenseFrontUrl']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_licenseFrontUrl']['tmp_name']),
				[
					'name' => "licenseFrontImage" . rand() . time() . $_FILES['v_licenseFrontUrl']['name'],
				]
			);

			$data["vehicle"]['licenseFrontUrl'] = $uploadedFile->info()['mediaLink'];
		}else{
			$data["vehicle"]['licenseFrontUrl'] = "";
		}
		if ($_FILES['v_licenseBackUrl']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_licenseBackUrl']['tmp_name']),
				[
					'name' => "licenseBackImage" . rand() . time() . $_FILES['v_licenseBackUrl']['name'],
				]
			);

			$data["vehicle"]['licenseBackUrl'] = $uploadedFile->info()['mediaLink'];
		}else{
			$data["vehicle"]['licenseBackUrl'] = "";
		}
		if ($_FILES['v_frontCarUrl']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontCarUrl']['tmp_name']),
				[
					'name' => "vehiclefrontcarImage" . rand() . time() . $_FILES['v_frontCarUrl']['name'],
				]
			);

			$data["vehicle"]['frontCarUrl'] = $uploadedFile->info()['mediaLink'];
		}else{
			$data["vehicle"]['frontCarUrl'] = "";
		}
		if ($_FILES['v_cnicFrontUrl']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_cnicFrontUrl']['tmp_name']),
				[
					'name' => "cnicFront" . rand() . time() . $_FILES['v_cnicFrontUrl']['name'],
				]
			);

			$data["vehicle"]['cnicFrontUrl'] = $uploadedFile->info()['mediaLink'];
		}else{
			$data["vehicle"]['cnicFrontUrl'] = "";
		}
		if ($_FILES['v_cnicBackUrl']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_cnicBackUrl']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_cnicBackUrl']['name'],
				]
			);

			$data["vehicle"]['cnicBackUrl'] = $uploadedFile->info()['mediaLink'];
		}else{
			$data["vehicle"]['cnicBackUrl'] = "";

		}
		

		foreach ($_POST as $key => $val) {
			if (strpos($key, "v_") === 0) {
				$name = substr($key, 2);
				$data["vehicle"][$name] = $val;
			}
		}

		$data["driver"]["userRole"] = "driver";
		$data["driver"]["isVerified"] = "approved";
		$data['driver']['isApproved']="";

		
		$response = $this->drivers_model->add_drivers($data);
			if ($response) {
			$this->session->set_flashdata('successmessage', 'New driver added successfully..');
			redirect('drivers');
		} else {
			$errormsg = 'Error! User Already Exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('drivers/adddrivers');
		}
	}
	public function editdriver()
	{
		$d_id = $this->uri->segment(3);
		$data['driverdetails'] = $this->drivers_model->get_driverdetails($d_id);
		$this->template->template_render('edit_driver', $data);
	}


	public function updatedriver()
	{
		foreach ($_POST as $key => $val) {
			if (strpos($key, "d_") === 0) {
				$name = substr($key, 2);
				$data["driver"][$name] = $val;
			}
		}
// echo "<pre>";
// print_r($this->input->post());
// echo "</pre>";
// print_r($data["driver"]);
if($data["driver"]['newpassword'] != ""){
	
	$data["driver"]['password']=$data["driver"]['newpassword'];
	$data["driver"]['newpassword']="";
	 $flag=$this->customer_model->update_customerpassword($data["driver"]['id'],$data["driver"]['password']);




	if($flag){
			
		
		
	}else{
$this->session->set_flashdata('warningmessage', 'Usome thing error Please try later');
redirect('drivers');
		//redirect('customer/editcustomer/'.$id);
	}

	
}

// echo "<pre>";
// print_r($data['driver']);
// echo "</pre>";
// exit;
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		if ($_FILES['v_proofOfInsurance']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfInsurance']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfInsurance']['name'],
				]
			);

			$data["vehicle"]['insuranceUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_proofOfRegistration']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_proofOfRegistration']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_proofOfRegistration']['name'],
				]
			);

			$data["vehicle"]['registrationUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontPicture']['name'],
				]
			);

			$data["vehicle"]['frontCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_leftPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_leftPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_leftPicture']['name'],
				]
			);

			$data["vehicle"]['leftCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_license']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_license']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_license']['name'],
				]
			);

			$data["vehicle"]['licenseUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rightPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rightPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rightPicture']['name'],
				]
			);

			$data["vehicle"]['rightCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_rearPicture']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_rearPicture']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_rearPicture']['name'],
				]
			);

			$data["vehicle"]['rearCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_frontInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_frontInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_frontInterior']['name'],
				]
			);

			$data["vehicle"]['frontInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}
		if ($_FILES['v_backInterior']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['v_backInterior']['tmp_name']),
				[
					'name' => "vehicleImage" . rand() . time() . $_FILES['v_backInterior']['name'],
				]
			);

			$data["vehicle"]['backInCarUrl'] = $uploadedFile->info()['mediaLink'];
		}

		foreach ($_POST as $key => $val) {
			if (strpos($key, "v_") === 0) {
				$name = substr($key, 2);
				$data["vehicle"][$name] = $val;
			}
		}

		$response = $this->common->updatedatamodel("Users", $data["driver"]["id"], $data["driver"]);
		$response = $this->common->updatedatamodel("Vehicle", $data["vehicle"]["id"], $data["vehicle"]);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Data Edited successfully..');
			redirect('drivers');
		} else {
			$errormsg = 'Seomething went wrong.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('drivers');
		}
	}
}
