<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rides extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
    $this->load->model('geofence_model');
  }
  
  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");
    
    
    $this->template->template_render('settings', $data);
  }

  

  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if($response) {
				$this->session->set_flashdata('successmessage', 'Data has been updated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
	{

    $rides = $this->common->readdatafromcollectionbetween("Rides");
    foreach($rides as $key => $ride) {
      $dirverId = $ride['driverId'];
      $userId = $ride['userId'];
      $driver = $this->common->readdatadocument('Users', $dirverId);
      $user = $this->common->readdatadocument('Users', $userId);
      $rides[$key]['driver'] = $driver;
      $rides[$key]['user'] = $user;
    }
    $data["rides"] = $rides;
		
		$this->template->template_render('rides_management', $data);
	}


}