<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Accountants extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		//	 $this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['accountants'] = $this->common->readdatafromcollectionwhereclause("Users", "role", "=", "accountant");
		$this->template->template_render('accountants', $data);
	}

	
	public function suspendAccountant()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Accountant Suspended');
		redirect(base_url().'accountants');
	}

	public function unSuspendAccountant()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Accountant Activated');
		redirect(base_url().'accountants');
	}

	public function deleteAccountant()
	{
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();

		$data["id"] = $this->uri->segment(3);
		$auth->deleteUser($data["id"]);
		$this->common->deletedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Accountant Deleted');
		redirect(base_url().'accountants');
	}

	public function addaccountant()
	{
		$this->template->template_render('accountant_add');
	}
	public function editaccountant()
	{
		$id = $this->uri->segment(3);

		$data['accountant'] = $this->common->readdatadocument("Users", $id);
		
		$this->template->template_render('accountant_add', $data);
	}

	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertaccountant()
	{
		$data = $this->input->post();
		$data["role"] = "accountant";
		
		$response = $this->customer_model->add_customer($data);
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Accountant added successfully');
			redirect(base_url().'accountants');
		} else {
			$errormsg = 'Error! Email address already exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'accountants/addaccountant');
		}
	}

	public function updateaccountant()
	{
		$data = $this->input->post();
		$response = $this->customer_model->update_customer($data);
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Accountant Updated successfully');
			redirect(base_url().'accountants');
		} else {
			$errormsg = 'Error! Some data is not correct.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'accountants/editaccountant/'.$data['id']);
		}
	}


	public function updatecustomerdata($type, $id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['password'] != "" && $da['password'] != NULL) {
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($da['old_email'] != $da['email']) {
			$flag = $this->customer_model->update_customeremail($id, $da['email']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($type == "customer") {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		} else {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		}
	}

	public function editcustomer()
	{
		$type = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$data['id'] = $id;
		$data['type'] = $type;
		$data['customerdetails'] = $this->common->readdatadocument("Users", $id);
		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}