<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->model('dashboard_model');
    }

    public function index()
    {
        if (!empty($this->session->userdata('session_data'))) {
			$firebase = $this->firebase->init();
            $database = $firebase->createDatabase();
            $reference = $database->getReference('Organizers');
            $snapshot = $reference->getSnapshot();
            $organizers = $snapshot->getValue();
            $totalEvents = 0;
            $activeEvents = 0;
            $today = date('m/d/Y');
            $todaysDate = strtotime($today);

            $events = array();
            foreach($organizers as $organizer) {
                $totalEvents += count($organizer);
                foreach($organizer as $key => $event) {
                    $events[$key] = $event;
                    $eventDate = str_replace('-', '/', $event['date']);

                    $eventDate = strtotime($eventDate);
                    // echo($eventDate." - ".$todaysDate);die;
                    if($eventDate > $todaysDate) {
                        $activeEvents += 1;
                    }
                }
            }
            $data['totalEvents'] = $totalEvents;
            $data['activeEvents'] = $activeEvents;

            usort($events, function($a, $b) {
                $a['date'] = str_replace('-', '/', $a['date']);
                $b['date'] = str_replace('-', '/', $b['date']);
                $a['date'] = strtotime($a['date']);
                $b['date'] = strtotime($b['date']);
                return $b['date'] <=> $a['date'];
            });
            
            $events = array_slice($events, 0, $activeEvents);
            $data['latestEvents'] = $events;
            $reference = $database->getReference('UserList');
            $snapshot = $reference->getSnapshot();
            $iosDownloads = $snapshot->getValue();
            $data['iosDownloads'] = $iosDownloads;
            $this->template->template_render('dashboard', $data);
		} else {
			redirect(base_url('login/login'));
		}
    }
    
}