<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Events extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->model('dashboard_model');
    }

    public function index()
    {
        if (!empty($this->session->userdata('session_data'))) {
            $firebase = $this->firebase->init();
            $database = $firebase->createDatabase();
            $reference = $database->getReference('Organizers');
            $snapshot = $reference->getSnapshot();
            $organizers = $snapshot->getValue();
            $totalEvents = 0;
            $events = array();
            foreach($organizers as $organizer) {
                $totalEvents += count($organizer);
                foreach($organizer as $key => $event) {
                    $events[$key] = $event;
                }
            }

            $data['totalEvents'] = $totalEvents;

            usort($events, function($a, $b) {
                $a['date'] = str_replace('-', '/', $a['date']);
                $b['date'] = str_replace('-', '/', $b['date']);
                $a['date'] = strtotime($a['date']);
                $b['date'] = strtotime($b['date']);
                return $b['date'] <=> $a['date'];
            });
            
            $events = array_slice($events, 0, 50);
            $data['latestEvents'] = $events;

            $this->template->template_render('events', $data);
        } else {
            redirect(base_url('login/login'));
        }
    }


}