<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Login extends CI_Controller
{
	//To load initial libraries, functions
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->model('common');
		$this->load->library('session');
	}

	public function index()    //Login Controller
	{
		// $firebase = $this->firebase->init();
		// $database = $firebase->createDatabase();
		// $reference = $database->getReference('Users');
		// $snapshot = $reference->getSnapshot();
		// $value = $snapshot->getValue();

		// var_dump($value);die;
		
		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('landing');
		}
	}

	public function login()    //Login Controller
	{
		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('login');
		}
	}


	public function login_action()
	{

		$email = $this->input->post("email");
		$password = $this->input->post("password");

		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();
		try {
		
			$signInResult = $auth->signInWithEmailAndPassword($email, $password);
			$my = $signInResult->data();

			if (!empty($my["idToken"] )) {

				$session_data = array(
					'adminName' => $my["displayName"],
					'adminEmail' => $my["localId"],
					'adminId' => $my["localId"],
					'firebaseToken' => $my["idToken"]
				);
				$this->session->set_userdata('session_data', $session_data);

				redirect(base_url('dashboard'));
			} else {
				$this->session->set_flashdata('warningmessage', 'Invalid email and/or password !');
				redirect(base_url('login/login'));
			}		
		} catch (Exception $e) {
			$this->session->set_flashdata('warningmessage',  $e->getMessage());
			redirect(base_url('login/login'));
		}	
		
	}

	public function logout()
	{
		// Removing session data
		$sess_array = array('adminId' => '');
		$this->session->unset_userdata('session_data', $sess_array);
		$this->session->sess_destroy();
		$this->session->set_flashdata('successmessage', 'Successfully logged out!');
		redirect(base_url('login'));
	}
}