<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Shippers extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['shippers'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "shipper");
		$this->template->template_render('shippers', $data);
	}

	public function shipperdetails()
	{
		$id = $this->uri->segment(3);
		
		$data['shipper'] = $this->common->readdatadocument("Users", $id);
		$data['shipper']["accountPayable"] = $this->common->readdatadocument("AccountPayable", $id);
		$data['shipper']["billApplication"] = $this->common->readdatadocument("BillApplication", $id);
		$data['shipper']["business"] = $this->common->readdatadocument("Business", $id);
		$data['shipper']["credit"] = $this->common->readdatadocument("CreditInfo", $id);
		
		
		//var_dump($data['shipper']["accountPayable"]);die;
		
		$this->template->template_render('shipper_details', $data);
	}

	
	public function suspendShipper()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Shipper Suspended');
		redirect(base_url().'shippers');
	}

	public function unSuspendShipper()
	{
		$data["id"] = $this->uri->segment(3);
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Shipper Activated');
		redirect(base_url().'shippers');
	}

	public function deleteshipper()
	{
		$firebase = $this->firebase->init();
		$auth = $firebase->createAuth();

		$data["id"] = $this->uri->segment(3);
		$auth->deleteUser($data["id"]);
		$this->common->deletedatamodel("Users", $data["id"], $data);
		$this->session->set_flashdata('successmessage', 'Shipper Deleted');
		redirect(base_url().'shippers');
	}

	public function addshipper()
	{
		$this->template->template_render('shipper_add');
	}
		public function addshipperdata(){
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();
		$data=$this->input->post();
		$bd=$this->input->post('bd');
		
		//print_r($this->input->post());
		$gd=$this->input->post('gd');
		if ($_FILES["gd"]["tmp_name"]["signaturefile"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["gd"]["name"]["signaturefile"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["gd"]["tmp_name"]["signaturefile"]),
			  [
				'name' => $fileName,
			  ]
			);
			$gd["signature"] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			$gd["signature"]="";
		  }
	

	
		$cr1=$this->input->post('cr1');
		$cr1['type']="Credit";
		
		$cr2=$this->input->post('cr2');
		$cr2['type']="Credit";
		
		$cr3=$this->input->post('cr3');
		$cr3['type']="Credit";
		
		//$ba=$this->input->post('ba');
	
		//apd
		//$apd=$this->input->post('apd');
		

		//$ci=$this->input->post('ci');

		//$tr=$this->input->post('tr');
		//$tr['type']="Trade";
	
		
		$currentDateTimeInMilliseconds = round(microtime(true) * 1000);
		$gd['Date']=$currentDateTimeInMilliseconds;
		$gd['cvcCode']=$gd['cvvCode'];
		$gd['deviceType']="Agent";
		$gd['userRole']="shipper";
		$gd['signature']="";
		$gd['userDate']=$currentDateTimeInMilliseconds;
	
	
		
		if ($_FILES["bd"]["tmp_name"]["einUrl"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["einUrl"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["einUrl"]),
			  [
				'name' => $fileName,
			  ]
			);
			$bd['einUrl'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			$bd['einUrl']="";
		  }
		  if ($_FILES["bd"]["tmp_name"]["taxUrl"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["taxUrl"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["taxUrl"]),
			  [
				'name' => $fileName,
			  ]
			);
			$bd['taxUrl'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			$bd['taxUrl']="";
		  }
		  if ($_FILES["bd"]["tmp_name"]["creditUrl"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["creditUrl"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["creditUrl"]),
			  [
				'name' => $fileName,
			  ]
			);
			$bd['creditUrl'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			$bd['creditUrl']="";
		  }
		  if ($_FILES["bd"]["tmp_name"]["secuirtyUrl"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["secuirtyUrl"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["secuirtyUrl"]),
			  [
				'name' => $fileName,
			  ]
			);
			$bd['secuirtyUrl'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			$bd['secuirtyUrl']="";
		  }


		  $auth = $firebase->createAuth();
		  $userProperties = [
			  'email' => $gd['email'],
			  'password' => $gd['password'],
			  'displayName' => $gd['comapnyName'],
		  ];
  
		  try {
			  $auth->createUser($userProperties);
			  $signInResult = $auth->signInWithEmailAndPassword($userProperties['email'], $userProperties['password']);
			  $my = $signInResult->data();
		//	  print_r();
			  $userid=$my['localId'];
			  $cr1['userId']=$userid;
			  $cr2['userId']=$userid;
			  $cr3['userId']=$userid;
			  //$ba['userId']=$userid;
			  //$apd['userId']=$userid;
			 // $ci['userId']=$userid;
			//  $tr['userId']=$userid;
			  $bd['userId']=$userid;	
			  $this->common->adddatamodel("Users",$userid,$gd);
			  $this->common->adddatamodel("Business",$userid,$bd);
			  //$this->common->adddatamodel("BillApplication",$userid,$ba);
			  $response = $this->common->adddatamodel("Reference", rand().time(), $cr1);
					  $response = $this->common->adddatamodel("Reference",rand().time(), $cr2);
					  $response = $this->common->adddatamodel("Reference", rand().time(), $cr3);
					  // $response = $this->common->adddatamodel("Reference", rand().time(), $tr);	  
					  $this->session->set_flashdata('successmessage', "New Shipper has been Added");
					  redirect(base_url('shippers/addshipper'));
			  
			} catch (\Throwable $e) {
		
			  $this->session->set_flashdata('warningmessage', $e->getMessage());
			  redirect(base_url('shippers/addshipper'));
			  
		  }
  

		  
	}
	public function editshipper()
	{
		$id = $this->uri->segment(3);

		$data['shipper'] = $this->common->readdatadocument("Users", $id);
		$data['shipper']["accPayable"] = $this->common->readdatadocument("AccountPayable", $id);
		$data['shipper']["billApp"] = $this->common->readdatadocument("BillApplication", $id);
		$data['shipper']["busiDetails"] = $this->common->readdatadocument("Business", $id);
		$data['shipper']["creditInfo"] = $this->common->readdatadocument("CreditInfo", $id);
		$allRefs = $this->common->readdatafromcollectionwhereclause("Reference", "userId", "=", $id);
		$i = 1;
		$j = 1;
		foreach($allRefs as $key => $value){
			
			if($value["type"] == 'Credit') {
				$data["shipper"]["cref".$i] = $value;
				$data["shipper"]["cref".$i]["refid"] = $key;
				$i++;
			}

			if($value["type"] == 'Trade') {
				$data["shipper"]["tref".$j] = $value;
				$data["shipper"]["tref".$j]["refid"] = $key;
				$j++;
			}
			
		}
		$data["shipper"]["sid"] = $id;
		$this->template->template_render('shipper_edit', $data);
	}

	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertshipper()
	{
		$data = $this->input->post();
		$data["role"] = "shipper";
		
		$response = $this->customer_model->add_customer($data);
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Shipper added successfully');
			redirect(base_url().'shippers');
		} else {
			$errormsg = 'Error! Email address already exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'shippers/addshipper');
		}
	}

	public function updateshipper()
	{
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();
		
		$data = $this->input->post();
		$sid = $data["sid"];
		$response = $this->common->updatedatamodel("Users", $sid, $data["gd"]);
		$response = $this->common->updatedatamodel("AccountPayable", $sid, $data["apd"]);
		$response = $this->common->updatedatamodel("BillApplication", $sid, $data["ba"]);
		
		
		if ($_FILES["bd"]["tmp_name"]["ein"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["ein"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["ein"]),
			  [
				'name' => $fileName,
			  ]
			);
			$data["bd"]['ein'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			unset($data["bd"]['ein']);
		  }

		  if ($_FILES["bd"]["tmp_name"]["taxId"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["taxId"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["taxId"]),
			  [
				'name' => $fileName,
			  ]
			);
			$data["bd"]['taxId'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			unset($data["bd"]['taxId']);
		  }

		  if ($_FILES["bd"]["tmp_name"]["creditCard"] != '') {
			$fileName = "Business/" . rand() . time() . $_FILES["bd"]["name"]["creditCard"];
			$uploadedFile = $defaultBucket->upload(
			  file_get_contents($_FILES["bd"]["tmp_name"]["creditCard"]),
			  [
				'name' => $fileName,
			  ]
			);
			$data["bd"]['creditCard'] = 'https://firebasestorage.googleapis.com/v0/b/rugelinternational-78887.appspot.com/o/'.urlencode($fileName).'?alt=media';
		  }else{
			unset($data["bd"]['creditCard']);
		  }

		  

		$response = $this->common->updatedatamodel("Business", $sid, $data["bd"]);


		$response = $this->common->updatedatamodel("Reference", $data["cr1"]["id"], $data["cr1"]);
		$response = $this->common->updatedatamodel("Reference", $data["cr2"]["id"], $data["cr2"]);
		$response = $this->common->updatedatamodel("Reference", $data["cr3"]["id"], $data["cr3"]);
		$response = $this->common->updatedatamodel("Reference", $data["tr"]["id"], $data["tr"]);
		
		
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Shipper Updated successfully');
			redirect(base_url().'shippers');
		} else {
			$errormsg = 'Error! Some data is not correct.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url().'shippers/editshipper/'.$sid);
		}
	}


	public function updatecustomerdata($type, $id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['password'] != "" && $da['password'] != NULL) {
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($da['old_email'] != $da['email']) {
			$flag = $this->customer_model->update_customeremail($id, $da['email']);

			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'some thing went wrong Please try again.');

				if ($type == "customer") {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				} else {
					redirect('customer/editcustomer/' . $type . '/' . $id);
				}
			}
		} else {
			$data['fullname'] = $da['fullname'];
			$data['email'] = $da['email'];
			$data['userName'] = $da['userName'];
			$data['userPhone'] = $da['userPhone'];
			$this->common->updatedatamodel("Users", $id, $data);
			$this->session->set_flashdata('successmessage', 'Users has been updated successfully');
		}

		if ($type == "customer") {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		} else {
			redirect('customer/editcustomer/' . $type . '/' . $id);
		}
	}

	public function editcustomer()
	{
		$type = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$data['id'] = $id;
		$data['type'] = $type;
		$data['customerdetails'] = $this->common->readdatadocument("Users", $id);
		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}