<div class="wrapper">
    <section class="col-12">
        <div class="row pb-3">
            <div class="col-10">
                <h2 class="page-header pt-3">
                    Carrier Details
                </h2>
            </div>
            <div class="col-2 pt-3">
                <button type="button" class="btn btn-outline-primary ms-1" onclick="location.href='<?php echo(base_url('carriers'));?>'">
                    <i class="fa-solid fa-arrow-left"></i> Back </button>

            </div>
        </div>
        <div class="card">
            <div class="card-body p-0">
                <section style="background-color: #eee;">
                    <div class="container py-5">

                        <div class="row">
                            <div class="col-lg-4">
                                <div class="card mb-4">
                                    <div class="card-body text-center">
                                        <?php if(!empty($carrier['image'])) { ?>
                                        <img src="<?=$carrier['image']?>" alt="avatar" class="rounded-circle img-fluid" style="width: 150px;">
                                        <?php } ?>
                                        <h5 class="my-3"><?=$carrier['name']??$carrier["contactName"]?></h5>
                                        <?php if(!empty($carrier['signature'])) { ?>

                                        <img src="<?=$carrier['signature']?>" alt="avatar" class="rounded-circle img-fluid" style="width: 150px;">
                                        <?php } ?>
                                        <?php if(!empty($carrier['licenseUrl'])) { ?>

                                        <img src="<?=$carrier['licenseUrl']?>" alt="avatar" class="rounded-circle img-fluid" style="width: 150px;">
                                        <?php } ?>

                                        <p class="text-muted mb-4"><?=$carrier['address']?></p>
                                        <div class="d-flex justify-content-center mb-2">
                                            <button type="button" class="btn btn-primary">Follow</button>
                                            <button type="button" class="btn btn-outline-primary ms-1">Message</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card mb-4 mb-lg-0">
                                    <div class="card-body p-0">
                                        <ul class="list-group list-group-flush rounded-3">
                                            <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                                <i class="fab fa-github fa-lg" style="color: #333333;"></i>
                                                <p class="mb-0">CarrierLinkedIn</p>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                                <i class="fab fa-twitter fa-lg" style="color: #55acee;"></i>
                                                <p class="mb-0">@Carrier</p>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                                <i class="fab fa-instagram fa-lg" style="color: #ac2bac;"></i>
                                                <p class="mb-0">CarrierInstagram</p>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                                <i class="fab fa-facebook-f fa-lg" style="color: #3b5998;"></i>
                                                <p class="mb-0">CarrierFacebook</p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 text-center" style="color: slategrey;">
                                                <h5>General Details</h5>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Carrier Name</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['name']??$carrier["contactName"]?></p>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Email</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['email']?></p>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Phone</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['phoneNumber']?></p>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Address</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['address']?></p>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <?php if($carrier['vehicle']) { ?>
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12 text-center" style="color: slategrey;">
                                                <h5>Vahicle Details</h5>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Make</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['vehicle']['make']?></p>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Model</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=$carrier['vehicle']['model']?></p>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Plate Expiry</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><?=date("d-m-Y", ($carrier['vehicle']['plateExpiryDate']/1000))?></p>
                                            </div>
                                        </div>
                                        <hr>

                                        <div class="row">
                                            <div class="col-sm-3">
                                                <p class="mb-0">Registration</p>
                                            </div>
                                            <div class="col-sm-9">
                                                <p class="text-muted mb-0"><img src="<?=$carrier['vehicle']['registrationUrl']?>" alt="Registration Snapshot" class="rounded-circle img-fluid" style="width: 150px;"></p>
                                            </div>
                                        </div>
                                        <hr>
                                    </div>
                                </div>
                                <?php } ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card mb-4 mb-md-0">
                                            <div class="card-body">
                                                <p class="mb-4"><span class="font-italic me-1" style="color: tomato;">Recent Trips</span>
                                                </p>
                                                <p class="mt-4 mb-1" style="font-size: .77rem;">Shipping Task Recent (100% done)</p>
                                                <div class="progress rounded" style="height: 5px;">
                                                    <div class="progress-bar" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="mt-4 mb-1" style="font-size: .77rem;">Shipping Task Recent (100% done)</p>
                                                <div class="progress rounded" style="height: 5px;">
                                                    <div class="progress-bar" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                                <p class="mt-4 mb-1" style="font-size: .77rem;">Shipping Task Recent (100%) done</p>
                                                <div class="progress rounded mb-2" style="height: 5px;">
                                                    <div class="progress-bar" role="progressbar" style="width: 100%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </section>
</div>