<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="" />
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors" />
    <meta name="generator" content="Hugo 0.84.0" />
    <title>CityVibes Admin Panel</title>

    <link rel="canonical" href="https://getbootstrap.com/docs/5.0/examples/heroes/" />

    <!-- Bootstrap core CSS -->
    <link href="<?=base_url()?>assets/dist/css/bootstrap.min.css" rel="stylesheet" />

    <style>
    .bd-placeholder-img {
        font-size: 1.125rem;
        text-anchor: middle;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
    }

    @media (min-width: 768px) {
        .bd-placeholder-img-lg {
            font-size: 3.5rem;
        }
    }
    </style>

    <!-- Custom styles for this template -->
    <link href="<?=base_url()?>assets/heroes.css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>admin/assets/toast/toast.min.css" />
    <script src="<?= base_url(); ?>admin/assets/toast/toast.min.js"></script>
</head>

<body>
    <main>
        <div class="bg-main2">
            <section class="vh-100">
                <div class="container py-5 h-100">
                    <div class="row d-flex justify-content-center align-items-center h-100">
                        <div class="col-12 col-md-8 col-lg-6 col-xl-5">
                            <div class="text-white" style="border-radius: 1rem; opacity: 1">
                                <div class="card-body p-5 text-center">
                                    <div class="mb-md-5 mt-md-4 pb-5">
                                        <img class="img-fluid" src="<?=base_url()?>assets/images/logom.png" />
                                        <form method="post" action="<?=basename('login/login_action')?>">
                                            <div class="mt-5 py-5">
                                                <input type="email" name="email" id="email" placeholder="Email" class="form-control form-control-lg rounded-pill custom-input" style="color:white" />
                                            </div>

                                            <div class="mt-2 mb-5">
                                                <input type="password" name="password" id="password" placeholder="Password" class="form-control form-control-lg rounded-pill custom-input" style="color:white" />
                                            </div>

                                            <button class="btn btn-lg px-5" type="submit" style="
                          background-color: rgb(149, 181, 211);
                          border-radius: 50px;
                        ">
                                                Login
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>

    <script src="<?=base_url()?>assets/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript">
    <?php if ($this->session->flashdata('successmessage')) { ?>
    const Toast = Swal.mixin({
        toast: true,
        position: 'top',
        showConfirmButton: false,
        timer: 5000
    });
    Toast.fire({
        type: 'success',
        title: '<?= $this->session->flashdata('successmessage'); ?>'
    });
    <?php } else if ($this->session->flashdata('warningmessage')) { ?>
    const Toast = Swal.mixin({
        toast: true,
        position: 'top',
        showConfirmButton: false,
        timer: 5000
    });
    Toast.fire({
        type: 'error',
        title: '<?= $this->session->flashdata('warningmessage'); ?>'
    });
    <?php } ?>
    </script>
</body>

</html>