<?php
if ($this->config->item('company_name') !== '') {
  $company_name =  $this->config->item('company_name');
} else {
  $company_name = 'Travel Club';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Log in</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Font Awesome -->

    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-giJF6kkoqNQ00vy+HMDP7azOuL0xtbfIcaT9wjKHr8RbDVddVHyTfAAsrekwKmP1" crossorigin="anonymous" />
    <!-- Theme style -->
    <style type="text/css">
    @import url("https://fonts.googleapis.com/css?family=Roboto:400,500,700,900&display=swap");

    body {
        padding: 30px 0;
        background: #ecf0f4;
        width: 100%;
        height: 100%;
        font-size: 18px;
        line-height: 1.5;
        font-family: "Roboto", sans-serif;
        color: #222;
    }

    .container {
        max-width: 1230px;
        width: 100%;
    }

    h1 {
        font-weight: 700;
        font-size: 45px;
        font-family: "Roboto", sans-serif;
    }

    .header {
        margin-bottom: 80px;
    }

    #description {
        font-size: 24px;
    }

    .form-wrap {
        background: rgba(255, 255, 255, 1);
        width: 100%;
        max-width: 850px;
        padding: 50px;
        margin: 0 auto;
        position: relative;
        -webkit-border-radius: 10px;
        -moz-border-radius: 10px;
        border-radius: 10px;
        -webkit-box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
        -moz-box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
        box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
    }

    .form-wrap:before {
        content: "";
        width: 90%;
        height: calc(100% + 60px);
        left: 0;
        right: 0;
        margin: 0 auto;
        position: absolute;
        top: -30px;
        background: #00bcd9;
        z-index: -1;
        opacity: 0.8;
        -webkit-border-radius: 10px;
        -moz-border-radius: 10px;
        border-radius: 10px;
        -webkit-box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
        -moz-box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
        box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
    }

    .form-group {
        margin-bottom: 25px;
    }

    .form-group>label {
        display: block;
        font-size: 18px;
        color: #000;
    }

    .custom-control-label {
        color: #000;
        font-size: 16px;
    }

    .form-control {
        height: 50px;
        background: #ecf0f4;
        border-color: transparent;
        padding: 0 15px;
        font-size: 16px;
        -webkit-transition: all 0.3s ease-in-out;
        -moz-transition: all 0.3s ease-in-out;
        -o-transition: all 0.3s ease-in-out;
        transition: all 0.3s ease-in-out;
    }

    .form-control:focus {
        border-color: #00bcd9;
        -webkit-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        -moz-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
    }

    textarea.form-control {
        height: 160px;
        padding-top: 15px;
        resize: none;
    }

    .btn {
        padding: 0.657rem 0.75rem;
        font-size: 18px;
        letter-spacing: 0.05em;
        -webkit-transition: all 0.3s ease-in-out;
        -moz-transition: all 0.3s ease-in-out;
        -o-transition: all 0.3s ease-in-out;
        transition: all 0.3s ease-in-out;
    }

    .btn-primary {
        color: #fff;
        background-color: #00bcd9;
        border-color: #00bcd9;
    }

    .btn-primary:hover {
        color: #00bcd9;
        background-color: #ffffff;
        border-color: #00bcd9;
        -webkit-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        -moz-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
    }

    .btn-primary:focus,
    .btn-primary.focus {
        color: #00bcd9;
        background-color: #ffffff;
        border-color: #00bcd9;
        -webkit-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        -moz-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
    }

    .btn-primary:not(:disabled):not(.disabled):active,
    .btn-primary:not(:disabled):not(.disabled).active,
    .show>.btn-primary.dropdown-toggle {
        color: #00bcd9;
        background-color: #ffffff;
        border-color: #00bcd9;
    }

    .btn-primary:not(:disabled):not(.disabled):active:focus,
    .btn-primary:not(:disabled):not(.disabled).active:focus,
    .show>.btn-primary.dropdown-toggle:focus {
        -webkit-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        -moz-box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 767px) {
        .form-wrap {
            margin: 1rem 0;
        }

        h1 {
            font-size: 28px;
        }

        #description {
            font-size: 15px;
        }
    }

    .main-signature {
        display: flex;
        overflow: hidden;
    }

    .flex-row {
        display: flex;
    }

    .wrapper {
        border: 1px solid #ced4da;
        border-right: 0;
    }

    canvas#signature-pad {
        background: #fff;
        width: 100%;
        height: 100%;
        cursor: crosshair;
    }

    button#clear {
        height: 100%;
        background: #0d6efd;
        border: 1px solid #0d6efd;
        color: #fff;
        font-weight: 600;
        cursor: pointer;
    }

    button#clear span {
        transform: rotate(90deg);
        display: block;
    }
    </style>
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>
<!-- Main content -->

<body class="bg-full-img">
    <div class="row">
        <?php $successMessage = $this->session->flashdata('successmessage');
      $warningmessage = $this->session->flashdata('warningmessage');
      if (isset($successMessage)) {
        echo '<div id="alertmessage" class="col-md-12">
          <div class="alert alert-success alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                   ' . output($successMessage) . '
                  </div>
          </div>';
      }
      if (isset($warningmessage)) {
        echo '<div id="alertmessage" class="col-md-12">
          <div class="alert alert-warning alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                   ' . output($warningmessage) . '
                  </div>
          </div>';
      }
      ?>
    </div>
    <form action="<?php echo base_url().'Login/Saveagrrement/'.$id ;?>" method="post" enctype="multipart/form-data">

        <section>
            <div class="container">
                <header class="header">
                    <h1 id="title" class="text-center">BROKER SHIPPER AGREEMENT</h1>
                    <p id="description" class="text-center">
                        THIS AGREEMENT (“Agreement”) is made and intended to be effective this (the) CURRENT DAY day of CURRENT MONTH AND YEAR
                        <br>
                        by and between Rugel International Corporation, having offices at 6536 Quincy St. Willowbrook, Illinois 60527 the (“BOKER”) and
                        <br>
                        MARCAL PAPER having offices at 1000 Market St. Paterson, NJ 50456 (“ SHIPPER '); collectively “PARTIES”.
                        <br>
                        SHIPPER CONTRACT BODY
                        <br>
                        FIELD NEED TO BE EXPANDABLE, EDITABLE AND SMALL LETTERS (Very Long Contract )
                        <br>
                        Because term and condition change constantly we will need the freedom of editing.
                    </p>
                </header>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-wrap">
                            <div id="survey-form">
                                <div class="row">
                                    <?php
                                      $brokerFields = $agreement['brokerFields'];
                                      foreach($brokerFields as $brokerField) {
                                    ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="broker-label" for="broker"><?=$brokerField['label']?></label>
                                            <input type="<?=$brokerField['type']?>" name="<?=$brokerField['name']?>" placeholder="<?=$brokerField['label']?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="main-signature">
                                                <div class="flex-row">

                                                    <img class="signature-img" src="https://customerscanvas.com/help/designers-manual/design-anatomy/images/ImagePlaceholders_04.png" alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="broker_signature-label" for="broker_signature">Signature</label>
                                            <div class="main-signature">
                                                <div class="flex-row">
                                                    <div class="wrapper">
                                                        <canvas id="signature-pad" width="400" height="200"></canvas>
                                                    </div>
                                                    <div class="clear-btn">
                                                        <button id="clear"><span> Clear </span></button>
                                                    </div>
                                                    <input type="hidden" name="imagestr" id="imagestr">
                                                    <img class="signature-img" src="" alt="" hidden="hidden">
                                                </div>
                                            </div>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="form-wrap">
                            <div id="survey-form">
                                <div class="row">
                                    <?php
                                      $shipperFields = $agreement['shipperFields'];
                                      foreach($shipperFields as $shipperField) {
                                    ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="broker-label" for="broker"><?=$shipperField['label']?></label>
                                            <input type="<?=$shipperField['type']?>" name="<?=$shipperField['name']?>" placeholder="<?=$shipperField['label']?>" class="form-control" required>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label id="shipper_signature-label" for="shipper_signature">Signature</label>

                                            <div class="main-signature">
                                                <div class="flex-row">
                                                    <div class="wrapper">
                                                        <canvas class="signature-pad" id="signature-pad" width="400" height="200"></canvas>
                                                    </div>
                                                    <div class="clear-btn clear-btn2">
                                                        <button id="clear" class="clear2"><span> Clear </span></button>
                                                    </div>
                                                    <img class="signature-img" src="" alt="" hidden="hidden">
                                                </div>
                                            </div>
                                            <input type="hidden" name="imagestr" id="imagestr">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <section class="my-5">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <div id="errorStr" style="color: red;"></div>
                        <button type="submit" name="frmSubmit" id="frmSubmit" class="float-end btn btn-primary btn-block">Submit</button>
                    </div>
                </div>
            </div>
        </section>
    </form>
    <!-- /.content-wrapper -->

    <script src="<?= base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-ygbV9kiqUc6oa4msXn9868pTtWMgiQaeYH7/t7LECLbyPA2x65Kgf80OJFdroafW" crossorigin="anonymous"></script>
    <script type="text/javascript">
    // var canvas = document.getElementById("signature-pad");
    // var canvas = document.getElementById("signature-pad");
    /*
    function signature(){
    const canvas = document.querySelector('canvas');
    const form = document.querySelector('form');
    const clearButton = document.querySelector('#clear');

    const ctx = canvas.getContext('2d');

    let writingMode = false;

    const handlePointerDown = (event) => {
        writingMode = true;
        ctx.beginPath();
        const [positionX, positionY] = getCursorPosition(event);
        ctx.moveTo(positionX, positionY);
    }

    const handlePointerUp = () => {
        writingMode = false;
    }

    const handlePointerMove = (event) => {
        if (!writingMode) return
        const [positionX, positionY] = getCursorPosition(event);
        ctx.lineTo(positionX, positionY);
        ctx.stroke();
    }

    const getCursorPosition = (event) => {
        positionX = event.clientX - event.target.getBoundingClientRect().x;
        positionY = event.clientY - event.target.getBoundingClientRect().y;
        return [positionX, positionY];
    }

    ctx.lineWidth = 3;
    ctx.lineJoin = ctx.lineCap = 'round';

    form.addEventListener('submit', (event) => {
        event.preventDefault();
        const imageURL = canvas.toDataURL();
        const image = document.createElement('img');
        image.src = imageURL;
        image.height = canvas.height;
        image.width = canvas.width;
        image.style.display = 'block';
        form.appendChild(image);
        clearPad();
      })

      const clearPad = () => {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
      }
      clearButton.addEventListener('click', (event) => {
        event.preventDefault();
        clearPad();
    })


    canvas.addEventListener('pointerdown', handlePointerDown, {passive: true});
    canvas.addEventListener('pointerup', handlePointerUp, {passive: true});
    canvas.addEventListener('pointermove', handlePointerMove, {passive: true});
    }

    signature();


    // var canvas = document.getElementById("signature-pad");
    const canvas = document.querySelector('.signature-pad');
    const form = document.querySelector('form');
    const clearButton = document.querySelector('.clear2');

    const ctx = canvas.getContext('2d');

    let writingMode = false;

    const handlePointerDown = (event) => {
        writingMode = true;
        ctx.beginPath();
        const [positionX, positionY] = getCursorPosition(event);
        ctx.moveTo(positionX, positionY);
    }

    const handlePointerUp = () => {
        writingMode = false;
    }

    const handlePointerMove = (event) => {
        if (!writingMode) return
        const [positionX, positionY] = getCursorPosition(event);
        ctx.lineTo(positionX, positionY);
        ctx.stroke();
    }

    const getCursorPosition = (event) => {
        positionX = event.clientX - event.target.getBoundingClientRect().x;
        positionY = event.clientY - event.target.getBoundingClientRect().y;
        return [positionX, positionY];
    }

    ctx.lineWidth = 3;
    ctx.lineJoin = ctx.lineCap = 'round';

    form.addEventListener('submit', (event) => {
        event.preventDefault();
        const imageURL = canvas.toDataURL();
        const image = document.createElement('img');
        image.src = imageURL;
        image.height = canvas.height;
        image.width = canvas.width;
        image.style.display = 'block';
        form.appendChild(image);
        clearPad();
      })
      const clearPad = () => {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
      }
      clearButton.addEventListener('click', (event) => {
        event.preventDefault();
        clearPad();
    })


    canvas.addEventListener('pointerdown', handlePointerDown, {passive: true});
    canvas.addEventListener('pointerup', handlePointerUp, {passive: true});
    canvas.addEventListener('pointermove', handlePointerMove, {passive: true});
    */

    // var canvas = document.getElementById("signature-pad");
    function isCanvasBlank(canvas) {
        return !canvas.getContext('2d')
            .getImageData(0, 0, canvas.width, canvas.height).data
            .some(channel => channel !== 0);
    }

    function signature() {
        const canvas = document.querySelector('canvas');
        const form = document.querySelector('form');
        const clearButton = document.querySelector('#clear');

        const ctx = canvas.getContext('2d');

        let writingMode = false;

        const handlePointerDown = (event) => {
            writingMode = true;
            ctx.beginPath();
            const [positionX, positionY] = getCursorPosition(event);
            ctx.moveTo(positionX, positionY);
        }

        const handlePointerUp = () => {
            writingMode = false;
        }

        const handlePointerMove = (event) => {
            if (!writingMode) return
            const [positionX, positionY] = getCursorPosition(event);
            ctx.lineTo(positionX, positionY);
            ctx.stroke();
        }

        const getCursorPosition = (event) => {
            positionX = event.clientX - event.target.getBoundingClientRect().x;
            positionY = event.clientY - event.target.getBoundingClientRect().y;
            return [positionX, positionY];
        }

        ctx.lineWidth = 3;
        ctx.lineJoin = ctx.lineCap = 'round';

        form.addEventListener('submit', (event) => {
            event.preventDefault();
            let image_base64 = canvas.toDataURL().replace(/^data:image\/png;base64,/, "");
            if (isCanvasBlank(canvas)) {
                $("#errorStr").text("Please provide your signature.");
                return false;
            }
            document.getElementById('imagestr').value = image_base64;
            clearPad();
            // document.forms[0].submit();
        })
        const clearPad = () => {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
        }
        clearButton.addEventListener('click', (event) => {
            event.preventDefault();
            clearPad();
        })


        canvas.addEventListener('pointerdown', handlePointerDown, {
            passive: true
        });
        canvas.addEventListener('pointerup', handlePointerUp, {
            passive: true
        });
        canvas.addEventListener('pointermove', handlePointerMove, {
            passive: true
        });
    }



    signature();


    // // var canvas = document.getElementById("signature-pad");
    // const canvas = document.querySelector('.signature-pad');
    // const form = document.querySelector('form');
    // const clearButton = document.querySelector('.clear2');

    // const ctx = canvas.getContext('2d');

    // let writingMode = false;

    // const handlePointerDown = (event) => {
    //     writingMode = true;
    //     ctx.beginPath();
    //     const [positionX, positionY] = getCursorPosition(event);
    //     ctx.moveTo(positionX, positionY);
    // }

    // const handlePointerUp = () => {
    //     writingMode = false;
    // }

    // const handlePointerMove = (event) => {
    //     if (!writingMode) return
    //     const [positionX, positionY] = getCursorPosition(event);
    //     ctx.lineTo(positionX, positionY);
    //     ctx.stroke();
    // }

    // const getCursorPosition = (event) => {
    //     positionX = event.clientX - event.target.getBoundingClientRect().x;
    //     positionY = event.clientY - event.target.getBoundingClientRect().y;
    //     return [positionX, positionY];
    // }

    // ctx.lineWidth = 3;
    // ctx.lineJoin = ctx.lineCap = 'round';

    // form.addEventListener('submit', (event) => {
    //     event.preventDefault();
    //     const imageURL = canvas.toDataURL();
    //     const image = document.querySelector('.signature-img1');
    //     image.src = imageURL;
    //     image.height = canvas.height;
    //     image.width = canvas.width;
    //     image.style.display = 'block';
    //     form.appendChild(image);
    //     clearPad();
    // })
    // const clearPad = () => {
    //     ctx.clearRect(0, 0, canvas.width, canvas.height);
    // }
    // clearButton.addEventListener('click', (event) => {
    //     event.preventDefault();
    //     clearPad();
    // })


    // canvas.addEventListener('pointerdown', handlePointerDown, {
    //     passive: true
    // });
    // canvas.addEventListener('pointerup', handlePointerUp, {
    //     passive: true
    // });
    // canvas.addEventListener('pointermove', handlePointerMove, {
    //     passive: true
    // });
    </script>

</body>

</html>