<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }
  
  public function codes()
  {
    $data["codes"] = $this->common->readdatafromcollectionbetween("Codes");
    
    $this->template->template_render('codes', $data);
  }

  

  public function generateCode()
  {
    $chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $code = "";
    for ($i = 0; $i < 6; $i++) {
        $code .= $chars[mt_rand(0, strlen($chars)-1)];
    }
    $data["code"] = $code;
    $data["used"] = false;
    $response = $this->common->addnewdatamodel("Codes", $data);
    if($response) {
				$this->session->set_flashdata('successmessage', 'New Code has been generated');
    }else{
			$this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/codes'));
  }



  public function index()
  {
    $data['locations'] = $this->common->readnumberofdocumentsincollectionbetween('Locations');
    $data['machines'] = $this->common->readnumberofdocumentsincollectionbetween('Machines');
    $data['users'] = $this->common->readnumberofdocumentsincollectionbetween('Users');
   
    $this->template->template_render('dashboard', $data);
  }

  public function locations()
  {
    $data["locations"] = $this->common->readdatafromcollectionbetween("Locations");
    
    $this->template->template_render('locations', $data);
  }

  public function machines()
  {
    $data["machines"] = $this->common->readdatafromcollectionbetween("Machines");
    
    $this->template->template_render('machines', $data);
  }

  public function deleteLocation($id)
  {
    $response = $this->common->deletedatamodel("Locations", $id);

    if($response) {
      $this->session->set_flashdata('successmessage', 'Location deleted');
    }else{
      $this->session->set_flashdata('warningmessage', 'System Error!.Please try again later');
    }

    redirect(base_url('dashboard/locations'));
  }

  public function deleteMachine($id)
  {
    $response = $this->common->deletedatamodel("Machines", $id);

    if($response) {
      $this->session->set_flashdata('successmessage', 'Machine deleted');
    }else{
      $this->session->set_flashdata('warningmessage', 'System Error!.Please try again later');
    }

    redirect(base_url('dashboard/machines'));
  }

  public function ads()
  {
    $data["ads"] = $this->common->readdatafromcollectionbetween("Ads");
    
    $this->template->template_render('ads', $data);
  }

  public function insertad()
  {
    $firebase = $this->firebase->init();
    $storage = $firebase->createStorage();
    $defaultBucket = $storage->getBucket();

    $image_url = '';

    if ($_FILES['image']['tmp_name'] != '') {
        $name = "ad" . rand() . time() . $_FILES['image']['name'];
        $uploadedFile = $defaultBucket->upload(
            file_get_contents($_FILES['image']['tmp_name']),
            [
              'name' => $name,
              'predefinedAcl' => 'publicRead'
            ]
          );
          $image_url = 'https://storage.googleapis.com/social-app-b8894.appspot.com/'.$name;
    }

    $data = $this->input->post();
    $data['image'] = $image_url;
    $data['isActive'] = true;
    $data['createdDate'] = time();
    $docId = $data['createdDate'];

    $response = $this->common->adddatamodel("Ads", $docId, $data);

    if($response) {
      $this->session->set_flashdata('successmessage', 'Ad saved');
    }else{
      $this->session->set_flashdata('warningmessage', 'System Error!.Please try again later');
    }
    
    redirect(base_url('dashboard/ads'));
  }

  public function deleteAd($id)
  {
    
    $response = $this->common->deletedatamodel("Ads", $id);

    if($response) {
      $this->session->set_flashdata('successmessage', 'Ad deleted');
    }else{
      $this->session->set_flashdata('warningmessage', 'System Error!.Please try again later');
    }

    redirect(base_url('dashboard/ads'));
  }

  public function reportedComments($id)
  {
    
    $data['reportedComments'] = $this->common->nextedreaddatafromcollectionwhereclause("Posts", $id, "Comments");
    $data['postId'] = $id;
    $this->template->template_render('reported_comments', $data);

  }

  public function deleteComment($postId, $docId)
  {
    $response = $this->common->nexteddeletedatamodel("Posts", $postId, "Comments", $docId);

    if($response) {
      $this->session->set_flashdata('successmessage', 'Comment deleted');
    }else{
      $this->session->set_flashdata('warningmessage', 'System Error!.Please try again later');
    }

    redirect(base_url('dashboard/reportedComments/'.$postId));
  }


}