<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Login extends CI_Controller
{
	//To load initial libraries, functions
	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('directory');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->load->model('common');
		$this->load->library('session');
		// $this->load->database();
	}

public function  signatureForm(){
			$data["agreement"] = $this->common->readdatadocument("contractform",1681170472);

			$this->load->view('signatureform',$data);	
}
public function Saveagrrement(){
	$data = $this->input->post();
	$firebase = $this->firebase->init();
	$storage = $firebase->createStorage();
	$defaultBucket = $storage->getBucket();
	
	$decodedString = base64_decode($data['imagestr']);
	$id = time();
	$id = (string) $id;
	$imageName = $id.'_signature.png';

	//file_put_contents(base_url().'assets/uploads/test.jpg', $decodedString);die;
	$image = $defaultBucket->upload($decodedString, [
		'name' => $imageName,
		'predefinedAcl' => 'publicRead',
		'metadata' => [
			'contentType' => 'image/png'
		]
	]);
	$downloadUrl = $image->info()['mediaLink'];
	
	echo($downloadUrl);die;
	$response = $this->common->adddatamodel("Contract", $id, $data); 
	$this->session->set_flashdata('successmessage', "Contract has been Added");
	redirect(base_url('Login/signatureForm'));
}

	//To load login page
	public function index()    //Login Controller
	{
		
		if (!empty($this->session->userdata('session_data'))) {
			$url = base_url('dashboard');
			header("location: $url");
		} else {
			$this->load->view('login');
		}
	}


	public function login_action()
	{

		$email = $this->input->post("email");
		$password = $this->input->post("password");

		$firebase = $this->firebase->init();

		$auth = $firebase->createAuth();
		try {
		
		$signInResult = $auth->signInWithEmailAndPassword($email, $password);
		$my = $signInResult->data();

		$data['admin'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "admin");
        $data["adminId"] = array_keys($data['admin'])[0];
		$adminId = $data['adminId'];



		if (!empty($my["idToken"] )) {

			$session_data = array(
				'userId' => $my["localId"],
				'name' => $my["displayName"],
				'email' => $my["localId"],
				'adminId' => $adminId,
				'firebaseToken' => $my["idToken"]
			);
			$this->session->set_userdata('session_data', $session_data);

			redirect(base_url('dashboard'));
		} else {
			$this->session->set_flashdata('warningmessage', 'Invalid email or Password !');
			redirect(base_url('login'));
		}		
			} catch (Exception $e) {
				$this->session->set_flashdata('warningmessage',  $e->getMessage()
);
			redirect(base_url('login'));
			}	
		
	}

	//To logout session from browser
	public function logout()
	{
		// Removing session data
		$sess_array = array('userId' => '');
		$this->session->unset_userdata('session_data', $sess_array);
		$this->session->sess_destroy();
		$this->session->set_flashdata('successmessage', 'Successfully Logged out !');
		redirect('login');
	}
}