<section class="section-home1">
    <div class="container my-5 pb-5">
        <div class="row g-5">
            <div class="claw-home-section d-flex">
                <h4 class="claw-home-title">Add New Machine</h4>
            </div>

            <div class="background-signup">
                <form class="row gy-4" action="<?=base_url()?>site/doaddmachine" method="POST" enctype="multipart/form-data">
                    <div class="col-md-6 mt-0">
                        <label class="label-form popup-label" for="type">Machine type/description</label>
                        <input class="form-control price-popup" type="text" name="type" placeholder="Machine type/description" required>
                    </div>

                    <div class="col-md-6 mt-0">
                        <label class="label-form popup-label" for="placedDate">Date Machine Placed</label>
                        <input class="form-control price-popup" type="date" name="placedDate" placeholder="Saturday, may 25, 2023" required>
                    </div>

                    <div class="col-md-6">
                        <label class="label-form popup-label" for="locationId">Where is this machine placed?</label>
                        <select class="form-control price-popup" name="locationId" id="normal-select-1" placeholder-text="Select location">
                            <option selected class="select-dropdown__list-item">Select location</option>
                            <?php
                                foreach($locations as $key => $location) {
                            ?>
                            <option value="<?=$key?>" class="select-dropdown__list-item"><?=$location['name']?></option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="label-form popup-label" for="commission">Commission</label>
                        <input class="form-control price-popup" type="number" step="0.01" name="commission" placeholder="Enter percentage without %" required>
                    </div>

                    <div class="col-md-6">
                        <label class="label-form popup-label" for="vendCost">Cost to Play/Vend</label>
                        <input class="form-control price-popup" type="number" step="0.01" name="vendCost" placeholder="(.50=50 cents, 1.00=$1, etc.)" required>
                    </div>

                    <div class="col-md-6">
                        <label class="label-form popup-label" for="prizeCost">Average Prize Cost</label>
                        <input class="form-control price-popup" type="number" step="0.01" name="prizeCost" placeholder="(.50=50 cents, 1.00=$1, etc.)" required>
                    </div>

                    <div class="col-md-12">
                        <div class="middle-align">
                            <input class="markPaid checkaddMachine" type="checkbox" name="netCommission">
                            <label class="label-form popup-label mb-0" for="netCommission">Calculate commission after prize costs? (net) (Leave unchecked to calculate off gross sales.)</label>
                        </div>
                    </div>

                    <div class="col-md-12 mt-3">
                        <div class="middle-align">
                            <input class="markPaid checkaddMachine" type="checkbox" name="handCount">
                            <label class="label-form popup-label mb-0" for="handCount">Check this box if you hand count cash on location. (e.g. bulk vending)</label>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="col-md-4 m-top-col-8">
                            <label class="label-form popup-label" for="location_image">Machine image</label>
                            <input type='file' name="image" id="readUrl" hidden>
                            <div class="img-content-popup position-relative">
                                <h6 class="img-photo-popup-title">Choose Photo</h6>
                                <img id="uploadedImage" src="#" alt="Uploaded Image" accept="image/png, image/jpeg" style="display:none;">
                                <div class="cross-icon position-absolute">
                                    <i class="fa-solid fa-xmark"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mx-auto d-flex flex-column mt-5">
                        <button class="btn btn-lg btn-job-seeker background-btn-color height-45 w-100 mb-4 save-collection" type="submit">Add Machine</button>
                    </div>
                </form>
            </div>

        </div>
    </div>

</section>