<script>
var vendCostGlobal = 0;
var prizeCostGlobal = 0;
var commissionGlobal = 0;

function resetValues() {
    $('#grossSaleDiv').text("$0.00");
    $('#prizeCostDiv').text("$0.00");
    $('#commissionOwedDiv').text("$0.00");
    $('#credits').val("");
    $('#prizes').val("");
}

function collection(machineName, machineId, locationId, imageUrl, vendCost, prizeCost, commission) {
    resetValues();
    vendCostGlobal = vendCost;
    prizeCostGlobal = prizeCost;
    commissionGlobal = commission;
    $('#machineName').text(machineName);
    $('#comm').text(commission);
    $('#machineId').val(machineId);
    $('#locationId').val(locationId);
    $("#uploadedImage").prop("src", imageUrl);
}

function calculateGross(value) {
    if (isNaN(value)) {
        alert("Invalid value, please enter numeric value");
        return false;
    }
    let grossSale = value * vendCostGlobal;
    let commissionOwed = (grossSale * commissionGlobal) / 100;
    $('#grossSale').val(grossSale);
    $('#grossSaleDiv').text("$" + grossSale);
    $('#commissionOwed').val(commissionOwed);
    $('#commissionOwedDiv').text("$" + commissionOwed);
    $('#commissionToBePaid').val(commissionOwed);
}

function calculatePrize(value) {
    if (isNaN(value)) {
        alert("Invalid value, please enter numeric value");
        return false;
    }
    let prizeCost = value * prizeCostGlobal;
    $('#prizeCost').val(prizeCost);
    $('#prizeCostDiv').text("$" + prizeCost);

}
</script>
<section class="section-home1">
    <div class="container my-5 pb-5">
        <div class="row g-5">
            <div class="claw-home-section">
                <h4 class="claw-home-title">ClawMaster</h4>
            </div>
            <?php
                foreach($myMachines as $key => $machine) {
            ?>
            <div class="col-xl-3  col-lg-4 col-md-6 col-sm-6">
                <div class="col-content new-media">
                    <a href="<?=base_url()?>site/machineInfo/<?=$key?>">
                        <div class="col-content location-div space-between flex-start">
                            <div class="col-img-content">
                                <img src="<?=$machine['image']?>" class="col-image" alt="" width="50" height="50">
                            </div>
                            <div class="col-h6-title-content">
                                <h6 class="h6-title"><?=$machine['type']?></h6>
                                <p class="para-col"><?=$machine['placedDate']?></p>
                            </div>
                        </div>
                    </a>
                    <div class="col-dollar-content">
                        <button class="btn btn-col-dollar" onclick="collection('<?=$machine['type']?>', '<?=$key?>', '<?=$machine['locationId']?>', '<?=$machine['location']['image']?>', '<?=$machine['vendCost']?>', '<?=$machine['prizeCost']?>',  '<?=$machine['commission']?>')">$</button>
                    </div>
                </div>
                <div class="location-content">
                    <img src="<?=base_url()?>assets/images-claw/Icon material-location-on.png" class="location-icon" alt="location">
                    <p class="location-para"><?=$machine['location']['address']?></p>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>

</section>

<!-- popup -->

<div class="container">
    <!-- Button -->
    <!-- <div class="btn-wrapper">
        <button class="myBtn" id="myBtn">حذف کن</button>
    </div> -->
    <!-- Modal -->
    <div class="modal-container" id="myModal">
        <div class="modal-wrapper">
            <div class="modal">
                <header class="header-popup">
                    <h3 class="header-popup-title">New Collection</h3>
                </header>
                <main class="main-popup">
                    <div class="col-h6-title-content-popup">
                        <h6 class="h6-title" id="machineName"></h6>
                        <!-- <p class="para-col">Super Mini Crane</p> -->
                    </div>
                    <div class="background-signup">
                        <form class="row gy-4" action="<?=base_url()?>site/addcollection" method="POST">
                            <input type="hidden" name="machineId" id="machineId" />
                            <input type="hidden" name="locationId" id="locationId" />
                            <input type="hidden" name="grossSale" id="grossSale" />
                            <input type="hidden" name="prizeCost" id="prizeCost" />
                            <input type="hidden" name="commissionOwed" id="commissionOwed" />
                            <div class="col-md-12">
                                <input class="form-control date popup" type="date" name="collectionDate" required>
                            </div>
                            <div class="col-md-6">
                                <label class="label-form popup-label" for="credits">Credits Played</label>
                                <input class="form-control price-popup" type="number" name="credits" id="credits" step="0.01" placeholder="00" onkeyup="calculateGross(this.value);" required>
                            </div>
                            <div class="col-md-6">
                                <label class="label-form popup-label" for="prizes">Prizes Won</label>
                                <input class="form-control price-popup" type="number" name="prizes" id="prizes" step="0.01" placeholder="00" onkeyup="calculatePrize(this.value);" required>
                            </div>

                            <div class="col-md-6">
                                <div class="col-h6-title-content-popup">
                                    <h6 class="h6-title">Calculation</h6>
                                    <ul class="ul-list-popup">
                                        <li class="li-list-item">
                                            <p class="sales-title">Gross Sales:</p>
                                            <p class="sales-title number-price" id="grossSaleDiv">$0.00</p>
                                        </li>

                                        <li class="li-list-item">
                                            <p class="sales-title">Prize Cost:</p>
                                            <p class="sales-title number-price" id="prizeCostDiv">$0.00</p>
                                        </li>

                                        <li class="li-list-item">
                                            <p class="sales-title">Commission Owed (<span id="comm"></span>% of Gross):</p>
                                            <p class="sales-title number-price" id="commissionOwedDiv">$0.00</p>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="col-md-8" style="margin-top: -1rem;">
                                <label class="label-form popup-label" for="commission">Commission to be Paid*</label>
                                <input class="form-control price-popup" type="number" step="0.01" name="commissionToBePaid" id="commissionToBePaid" placeholder="00" required>
                                <textarea class="form-control price-popup h-auto mt-4" id="textarea" name="notes" rows="5" placeholder="Optional notes specific to this collection..."></textarea>
                            </div>
                            <div class="col-md-4 m-top-col-8" style="margin-top: -1rem;">
                                <label class="label-form popup-label" for="location_image">Location image</label>
                                <div class="img-content-popup position-relative">
                                    <img id="uploadedImage" src="" alt="Uploaded Image" accept="image/png, image/jpeg">
                                    <div class="cross-icon position-absolute">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 d-flex flex-column">
                                <button class="btn btn-lg btn-job-seeker background-btn-color height-45 w-100 my-4" id="save" type="submit">Save Collection</button>
                                <button class="btn btn-job-seeker background-btn-color height-45 w-100 mb-4 save-collection" type="button">Cancel</button>
                            </div>
                        </form>
                    </div>
                </main>
            </div>
        </div>
    </div>
</div>


<div class="container">
    <!-- Button -->
    <!-- <div class="btn-wrapper">
        <button class="myBtn" id="myBtn">حذف کن</button>
    </div> -->
    <!-- Modal -->
    <div class="modal-container1" id="myModal1">
        <div class="modal-wrapper1">
            <div class="modal1">
                <header class="header-popup1">
                    <h3 class="header-popup-title1">! Reminder !</h3>
                    <p class="para-popup-remainder">Reset Machine Count Clear Date</p>
                    <button class="btn btn-lg btn-job-seeker background-btn-color w-100 mt-4 mb-0 ok-btn" type="button">Ok</button>
                </header>
            </div>
        </div>
    </div>
</div>