<section class="section-home1">
    <div class="container my-5 pb-5">
        <div class="row g-5">
            <div class="claw-home-section d-flex">
                <h4 class="claw-home-title locationManagement">Collection Reports</h4>
                <button class="btn btn-lg btn-job-seeker background-btn-color height-45 w-100 mb-0 paid addLocation download" type="button">Download Report</button>
            </div>
            <?php
                foreach($reports as $key => $report) {
            ?>
            <div class="col-xl-3  col-lg-4 col-md-6 col-sm-6">
                <div class="col-content location-div media-css space-between">
                    <div class="col-h6-title-content location-margin">
                        <h6 class="h6-title mb-0"><?=$report['machine']['type']?></h6>
                        <p class="location-para machine-para mb-1"><?=$report['collectionDate']?></p>
                        <ul class="ul-list-popup mb-0 justify-start">
                            <li class="li-list-item">
                                <p class="sales-title font-change mb-0 font-change">Gross Sales:</p>
                                <p class="sales-title font-change mb-0 font-change number-price">$<?=$report['grossSale']?> (<?=$report['credits']?> credits)</p>
                            </li>

                            <li class="li-list-item">
                                <p class="sales-title font-change mb-0 font-change">Prize Cost:</p>
                                <p class="sales-title font-change mb-0 font-change number-price">$<?=$report['prizeCost']?> (<?=$report['prizes']?> prizes)</p>
                            </li>

                            <li class="li-list-item">
                                <p class="sales-title font-change mb-0 font-change">Prize to Play Ratio :</p>
                                <p class="sales-title font-change mb-0 font-change number-price"><?=round(($report['prizes']/$report['credits'])*100, 2)?>%</p>
                            </li>

                            <li class="li-list-item">
                                <p class="sales-title font-change mb-0 font-change">Net Profit:</p>
                                <p class="sales-title font-change mb-0 font-change number-price">$<?=round($report['grossSale']-($report['commissionOwed']+$report['prizeCost']), 2)?></p>
                            </li>

                            <li class="li-list-item">
                                <p class="sales-title font-change mb-0 font-change">Commission:</p>
                                <p class="sales-title font-change mb-0 font-change number-price">$<?=$report['commissionOwed']?></p>
                            </li>
                        </ul>
                    </div>
                    <!-- <div class="col-img-content col-location-content">
                        <input class="markPaid checkaddMachine" type="checkbox" name="checkaddMachine" required>
                    </div> -->
                </div>
                <div class="location-btns space-between">
                    <button class="btn btn-location-edit hover-change">
                        <img src="<?=base_url()?>assets/images-claw/Icon awesome-camera.png" class="camera-img" alt="camera">
                    </button>
                    <button class="btn btn-location-edit btn-location-delete" onclick="deleteReport('<?=$key?>')">Delete</button>
                </div>
            </div>
            <?php } ?>

        </div>
    </div>

</section>

<!-- popup -->

<div class="container">
    <!-- Button -->
    <!-- <div class="btn-wrapper">
        <button class="myBtn" id="myBtn">حذف کن</button>
    </div> -->
    <!-- Modal -->
    <div class="modal-container" id="myModal">
        <div class="modal-wrapper">
            <div class="modal">
                <header class="header-popup">
                    <h3 class="header-popup-title">Add New Location</h3>
                </header>
                <main class="main-popup">
                    <div class="background-signup">
                        <form class="row gy-4" action="<?=base_url()?>" method="POST">
                            <div class="col-md-6">
                                <label class="label-form popup-label" for="locationName">Location name</label>
                                <input class="form-control price-popup" type="text" name="locationName" placeholder="Enter location name" required>
                            </div>

                            <div class="col-md-6">
                                <label class="label-form popup-label" for="locationAddress">Location Address</label>
                                <input class="form-control price-popup" type="text" name="locationAddress" placeholder="Search by name or address" required>
                            </div>

                            <div class="col-md-6">
                                <label class="label-form popup-label" for="locationContact">Location Contact</label>
                                <input class="form-control price-popup" type="number" name="locationContact" placeholder="Enter location contact" required>
                            </div>

                            <div class="col-md-6">
                                <label class="label-form popup-label" for="locationPhoneNumber">Location Phone Number</label>
                                <input class="form-control price-popup" type="number" name="locationPhoneNumber" placeholder="Enter Location Phone Number" required>
                            </div>

                            <div class="col-md-4 m-top-col-8">
                                <label class="label-form popup-label" for="location_image">Location image</label>
                                <input type='file' id="readUrl" hidden>
                                <div class="img-content-popup position-relative">
                                    <h6 class="img-photo-popup-title">Choose Photo</h6>
                                    <img id="uploadedImage" src="#" alt="Uploaded Image" accept="image/png, image/jpeg" style="display:none;">
                                    <div class="cross-icon position-absolute">
                                        <i class="fa-solid fa-xmark"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 d-flex flex-column">
                                <!-- <a href="./home.php"> -->
                                <button class="btn btn-lg btn-job-seeker background-btn-color height-45 w-100 mb-4 save-collection" type="button">Create Location</button>
                                <!-- </a> -->
                            </div>
                        </form>
                    </div>
                </main>
            </div>
        </div>
    </div>
</div>

<script>
function deleteReport(reportId) {
    window.location.href = '<?php echo base_url("site/deleteReport/"); ?>' + reportId;
}
</script>