<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		// $this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function index()
	{
		$data['admins'] = $this->common->readdatafromcollectionwhereclause("Users", 'userRole', '=', 'admin');
		$this->template->template_render('admin_management', $data);
	}




	public function audit()
	{
		$data['fromdate'] = "";
		$data['todate'] = "";
		if ($this->input->get('fromdate') != "" && $this->input->get('todate') != "") {
			$data['fromdate'] =	$this->input->get('fromdate');
			$data['todate'] =	$this->input->get('todate');
			//echo  strtotime($data['fromdate'])*1000;

			$data['logs'] = $this->common->readdatafromcollectionbetween("AuditLog", "time", ">", strtotime($data['fromdate']), "time", "<=", strtotime($data['todate']) + 86400);
			// print_r($data);
			// exit;


		} else {

			$data['logs'] = $this->common->readdatacollection("AuditLog");
		}



		$this->template->template_render('logs', $data);
	}

	public function suspendCustomer()
	{
		$id = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect(base_url() . 'admin');
	}

	public function unSuspendCustomer()
	{
		$id = $this->uri->segment(3);

		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url() . 'admin');
	}

	public function deleteAdmin()
	{
		$id = $this->uri->segment(3);
		$firebase = $this->firebase->init();
		// $auth = $firebase->createAuth();
		// $auth->deleteUser($id);

		$response = $this->common->deletedatamodel('Users', $id);

		if (!$response) {
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting admin.');
			redirect(base_url() . 'admin');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'Admin Deleted');
		redirect(base_url() . 'admin');
	}

	public function addAdmin()
	{
		$this->template->template_render('adminadd');
	}
	//editcustomer
	public function editcustomers($id)
	{


		$data['id'] = $id;

		$data["customerdetails"] = $this->common->readdatadocument("Users", $id);

		$this->template->template_render('editcustomer', $data);
	}
	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertadmin()
	{
		$data = $this->input->post();
		if ($data['sendReports'] == 'true') {
			$data['sendReports'] = true;
		} else {
			$data['sendReports'] = false;
		}
		$data["userRole"] = "admin";

		$data["image"] = NULL;
		$data["isActive"] = true;

		$alladmin = $this->common->readdatafromcollectionwhereclause("Users", 'userRole', '=', 'admin');
		$response = $this->customer_model->add_admin($data, $alladmin);

		if ($response) {
			$this->session->set_flashdata('successmessage', 'New Admin added successfully');
			redirect(base_url('admin'));
		} else {
			$errormsg = 'Error! User already exists or your data is incorrect.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url('admin/addAdmin'));
		}
	}

	public function updateadmin()
	{
		$data = $this->input->post();
		if ($data['sendReports'] == 'true') {
			$data['sendReports'] = true;
		} else {
			$data['sendReports'] = false;
		}
		// $firebase = $this->firebase->init();
		// $auth = $firebase->createAuth();
		// $properties = [
		// 	'displayName' => $data['name'],
		// 	'password' => $data['password'],
		// ];
		// $auth->updateUser($data['id'], $properties);




		$response = $this->common->updatedatamodel("Users", $data['id'], $data);

		if ($response) {
			$this->session->set_flashdata('successmessage', 'Admin data updated successfully');
			redirect(base_url('admin'));
		} else {
			$errormsg = 'Error! Admin data cannot be upated.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect(base_url('admin'));
		}
	}

	public function updatecustomerdata($id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['newpassword'] != "") {

			$da['password'] = $da['newpassword'];
			$da['newpassword'] = "";
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);




			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'User has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something wrong, Please try again later');

				redirect(base_url() . 'admin/editcustomer/' . $id);
			}
		} else {
			$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
			$this->session->set_flashdata('successmessage', 'User has been updated successfully');
		}



		redirect(base_url() . 'admin');
	}

	public function editAdmin()
	{
		$c_id = $this->uri->segment(3);
		$data['customerdetails'] = $this->customer_model->get_customerdetails($c_id);
		$data['customerdetails']['id'] = $c_id;
		$this->template->template_render('adminadd', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('admin');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('admin/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('admin');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('admin');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('admin');
		}
	}
}
