<div class="container mt-5">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Communication Tools</h2>
    <div class="d-flex gap-2">
      <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#sendAnnouncementModal">➕ Send Announcement</button>
      <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#sendNotificationModal">➕ Send Notification</button>
    </div>
  </div>

  <!-- Announcement & Notification Section -->
  <h4 class="mb-3">Announcements & Notifications</h4>
  <div class="table-responsive mb-4">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-light">
        <tr>
          <th>Type</th>
          <th>Subject</th>
          <th>Message</th>
          <th>Sent By</th>
          <th>Date Sent</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>Announcement</td>
          <td>System Maintenance</td>
          <td>We will be performing system maintenance...</td>
          <td>Admin</td>
          <td>2025-04-06</td>
        </tr>
        <tr>
          <td>Notification</td>
          <td>New Training Program</td>
          <td>A new training program has been added...</td>
          <td>Admin</td>
          <td>2025-04-05</td>
        </tr>
      </tbody>
    </table>
  </div>

  <!-- Messaging Section -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4>Messages</h4>
    <div class="d-flex gap-2">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#sendMessageModal">➕ Send Message</button>
    </div>
  </div>
  <!-- <h4 class="mb-3">Messages</h4> -->
  <div class="table-responsive mb-4">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-light">
        <tr>
          <th>Subject</th>
          <th>Message</th>
          <th>Sent To</th>
          <th>Sent By</th>
          <th>Date Sent</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>Program Update</td>
          <td>Your subscription has been updated...</td>
          <td>John Doe</td>
          <td>Admin</td>
          <td>2025-04-04</td>
        </tr>
        <tr>
          <td>Account Verification</td>
          <td>Please verify your account information...</td>
          <td>Jane Smith</td>
          <td>Admin</td>
          <td>2025-04-03</td>
        </tr>
      </tbody>
    </table>
  </div>
</div>

<!-- Send Announcement Modal -->
<div class="modal fade" id="sendAnnouncementModal" tabindex="-1" aria-labelledby="sendAnnouncementModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="sendAnnouncementForm">
        <div class="modal-header">
          <h5 class="modal-title" id="sendAnnouncementModalLabel">Send Announcement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <label class="form-label">Subject</label>
          <input type="text" class="form-control mb-2" name="announcement_subject" placeholder="Enter Announcement Subject" required/>

          <label class="form-label">Message</label>
          <textarea class="form-control mb-2" name="announcement_message" placeholder="Enter Announcement Message" rows="4" required></textarea>

          <!-- Audience Selection -->
          <label class="form-label">Send To</label>
          <select class="form-select mb-2" name="announcement_audience">
            <option value="coaches">Coaches</option>
            <option value="trainees">Trainees</option>
            <option value="both">Both</option>
          </select>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Send Announcement</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Send Message Modal -->
<div class="modal fade" id="sendMessageModal" tabindex="-1" aria-labelledby="sendMessageModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="sendMessageForm">
        <div class="modal-header">
          <h5 class="modal-title" id="sendMessageModalLabel">Send Message</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <label class="form-label">Subject</label>
          <input type="text" class="form-control mb-2" name="message_subject" placeholder="Enter Message Subject" required/>

          <label class="form-label">Message</label>
          <textarea class="form-control mb-2" name="message_body" placeholder="Enter Message Body" rows="4" required></textarea>

          <label class="form-label">Send To</label>
          <select class="form-select mb-2" name="message_audience">
            <option value="coaches">Coaches</option>
            <option value="trainees">Trainees</option>
            <option value="both">Both</option>
          </select>

          <!-- <label class="form-label">Send To (User Name or ID)</label>
          <input type="text" class="form-control mb-2" name="message_to" placeholder="Enter Recipient Name or ID" required/> -->
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Send Message</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Send Notification Modal -->
<div class="modal fade" id="sendNotificationModal" tabindex="-1" aria-labelledby="sendNotificationModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="sendNotificationForm">
        <div class="modal-header">
          <h5 class="modal-title" id="sendNotificationModalLabel">Send Notification</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <label class="form-label">Subject</label>
          <input type="text" class="form-control mb-2" name="notification_subject" placeholder="Enter Notification Subject" required/>

          <label class="form-label">Message</label>
          <textarea class="form-control mb-2" name="notification_message" placeholder="Enter Notification Message" rows="4" required></textarea>

          <!-- Audience Selection -->
          <label class="form-label">Send To</label>
          <select class="form-select mb-2" name="notification_audience">
            <option value="coaches">Coaches</option>
            <option value="trainees">Trainees</option>
            <option value="both">Both</option>
          </select>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-warning">Send Notification</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>