<div class="container mt-5">
    <!-- Pricing and Subscription Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Pricing & Subscription Management</h2>
        <div class="d-flex gap-2">
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createPlanModal">➕ Create Plan</button>
            <!-- <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#createDiscountModal">➕ Add Discount</button> -->
        </div>
    </div>

    <!-- Subscription Plans Table -->
    <div class="table-responsive mb-4">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Plan Name</th>
                    <th>Price</th>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Basic Plan</td>
                    <td>$50</td>
                    <td>Monthly</td>
                    <td>Access to beginner training programs</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editPlanModal">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deletePlanModal">Delete</button>
                    </td>
                </tr>
                <tr>
                    <td>Premium Plan</td>
                    <td>$450 <del class="text-muted">$600</del></td>
                    <td>Yearly</td>
                    <td>Advanced coaching with personal trainer</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editPlanModal">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deletePlanModal">Delete</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Discount List Table -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Discount Management</h2>
        <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#createDiscountModal">➕ Add Discount</button>
    </div>
    <!-- <h4 class="mb-3">Discounts List</h4> -->
    <div class="table-responsive mb-4">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Discount Code</th>
                    <th>Discount (%)</th>
                    <th>Valid Till</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>SPRING25</td>
                    <td>25%</td>
                    <td>2025-06-30</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editDiscountModal">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteDiscountModal">Delete</button>
                    </td>
                </tr>
                <tr>
                    <td>SUMMER15</td>
                    <td>15%</td>
                    <td>2025-08-15</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editDiscountModal">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteDiscountModal">Delete</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Pricing for Training Program Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Set Pricing for Training Programs</h2>
        <!-- <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#createDiscountModal">➕ Add Pricing for Training Programs</button> -->
    </div>
    <div class="table-responsive mb-4">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-light">
                <tr>
                    <th>Program Name</th>
                    <th>Price</th>
                    <th>Duration</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Beginner Training</td>
                    <td>$200</td>
                    <td>1 Month</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editProgramPriceModal" data-id="1" data-name="Beginner Training" data-price="200" data-duration="1 Month">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteProgramPriceModal" data-id="1" data-name="Beginner Training">Delete</button>
                    </td>
                </tr>
                <tr>
                    <td>Advanced Training</td>
                    <td>$500</td>
                    <td>3 Months</td>
                    <td>
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#editProgramPriceModal" data-id="2" data-name="Advanced Training" data-price="500" data-duration="3 Months">Edit</button>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteProgramPriceModal" data-id="2" data-name="Advanced Training">Delete</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Add Program Pricing Modal -->
    <div class="modal fade" id="addProgramPriceModal" tabindex="-1" aria-labelledby="addProgramPriceModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="addProgramPriceForm">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addProgramPriceModalLabel">Add Training Program Pricing</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <label class="form-label">Program Name</label>
                        <input type="text" class="form-control mb-2" name="name" placeholder="Enter Program Name" required />

                        <label class="form-label">Price ($)</label>
                        <input type="number" class="form-control mb-2" name="price" placeholder="Enter Price" required />

                        <label class="form-label">Duration</label>
                        <input type="text" class="form-control mb-2" name="duration" placeholder="Enter Duration" required />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add Program</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Program Pricing Modal -->
    <div class="modal fade" id="editProgramPriceModal" tabindex="-1" aria-labelledby="editProgramPriceModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editProgramPriceForm">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editProgramPriceModalLabel">Edit Training Program Pricing</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="editProgramId" />

                        <label class="form-label">Program Name</label>
                        <input type="text" class="form-control mb-2" name="name" id="editProgramName" required />

                        <label class="form-label">Price ($)</label>
                        <input type="number" class="form-control mb-2" name="price" id="editProgramPrice" required />

                        <label class="form-label">Duration</label>
                        <input type="text" class="form-control mb-2" name="duration" id="editProgramDuration" required />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Program Pricing Modal -->
    <div class="modal fade" id="deleteProgramPriceModal" tabindex="-1" aria-labelledby="deleteProgramPriceModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="deleteProgramPriceForm">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title" id="deleteProgramPriceModalLabel">Delete Training Program</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete the <strong id="deleteProgramName"></strong> program?</p>
                        <input type="hidden" name="id" id="deleteProgramId" />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger">Yes, Delete</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>




</div>

<!-- Modals for Create Plan, Discount, Program Pricing -->

<!-- Add Discount Modal -->
<div class="modal fade" id="createDiscountModal" tabindex="-1" aria-labelledby="createDiscountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form>
                <div class="modal-header bg-warning">
                    <h5 class="modal-title" id="createDiscountModalLabel">Add New Discount</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label class="form-label">Discount Code</label>
                    <input type="text" class="form-control mb-2" placeholder="e.g. SPRING25" />
                    <label class="form-label">Discount (%)</label>
                    <input type="number" class="form-control mb-2" placeholder="e.g. 25" />
                    <label class="form-label">Valid Till</label>
                    <input type="date" class="form-control mb-2" />
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-warning">Add Discount</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Discount Modal -->
<div class="modal fade" id="editDiscountModal" tabindex="-1" aria-labelledby="editDiscountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form>
                <div class="modal-header">
                    <h5 class="modal-title" id="editDiscountModalLabel">Edit Discount</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label class="form-label">Discount Code</label>
                    <input type="text" class="form-control mb-2" value="SPRING25" />
                    <label class="form-label">Discount (%)</label>
                    <input type="number" class="form-control mb-2" value="25" />
                    <label class="form-label">Valid Till</label>
                    <input type="date" class="form-control mb-2" value="2025-06-30" />
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Pricing for Training Program Modal -->
<div class="modal fade" id="editProgramPriceModal" tabindex="-1" aria-labelledby="editProgramPriceModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form>
                <div class="modal-header">
                    <h5 class="modal-title" id="editProgramPriceModalLabel">Set Pricing for Training Program</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label class="form-label">Program Name</label>
                    <input type="text" class="form-control mb-2" value="Beginner Training" />
                    <label class="form-label">Price ($)</label>
                    <input type="number" class="form-control mb-2" value="200" />
                    <label class="form-label">Duration</label>
                    <input type="text" class="form-control mb-2" value="1 Month" />
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>