<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Customer extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->model('customer_model');
		$this->load->model('common');
		$this->load->helper(array('form', 'url', 'string'));
		$this->load->library('form_validation');
		$this->load->library('session');
	}

	public function getDetail($id='2BtLSx35cxZah9w6EMGumhxHTmX2'){
		
			$data['user'] = $this->common->readdatadocument("Users",$id);
				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
				$this->load->view('vehicle_view',$data);

	}	

	public function index()
	{
		$data['customerlist'] = $this->customer_model->getall_customer();
		$data['reminderlist'] = $this->common->readdatafromcollectionwhereclause("Reminders");
		
		
		$this->template->template_render('customer_management', $data);
	}
	public function lettscusyomer()
	{
		$curl = curl_init();
	curl_setopt_array($curl, array(
	  CURLOPT_URL => 'https://us-central1-letts-of-london.cloudfunctions.net/widgets/getuserlist',
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => '',
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 0,
	  CURLOPT_FOLLOWLOCATION => true,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => 'GET',
	
	));
	
	$response = curl_exec($curl);
	
	curl_close($curl);
	$res=json_decode($response,true);
		$data['customerlist'] = $res;
	
		$curl = curl_init();
	
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-letts-of-london.cloudfunctions.net/widgets/getreminderlist',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		
		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		$res=json_decode($response,true);
	
		$data['reminderlist'] = $res;
		
		$this->template->template_render('customer_managementnew', $data);
	}
	public function filofaxcusyomer()
	{
		$curl = curl_init();
	curl_setopt_array($curl, array(
	  CURLOPT_URL => 'https://us-central1-filofax-96375.cloudfunctions.net/widgets/getuserlist',
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => '',
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 0,
	  CURLOPT_FOLLOWLOCATION => true,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => 'GET',
	
	));
	
	$response = curl_exec($curl);
	
	curl_close($curl);
	$res=json_decode($response,true);
		$data['customerlist'] = $res;
	

		$curl = curl_init();
	
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-filofax-96375.cloudfunctions.net/widgets/getreminderlist',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		
		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		$res=json_decode($response,true);
		$data['reminderlist']=$res;


		
		
		$this->template->template_render('customer_managementnew1', $data);
	}
	public function lettssuspendCustomers()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-letts-of-london.cloudfunctions.net/widgets/changeusers/'.$id,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'PUT',
		  CURLOPT_POSTFIELDS =>'{
			"isActive":false
		   
		}'

		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
	
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect(base_url().'customer/lettscusyomer');
	}
	public function lettsunSuspendCustomer()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-letts-of-london.cloudfunctions.net/widgets/changeusers/'.$id,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'PUT',
		  CURLOPT_POSTFIELDS =>'{
			"isActive":true
		   
		}'

		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url().'customer/lettscusyomer');
	}
	


	public function lettdeleteCustomer()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://us-central1-letts-of-london.cloudfunctions.net/widgets/deleteusers/'.$id,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'DELETE',
		));
		$response = curl_exec($curl);
		curl_close($curl);

		$this->session->set_flashdata('successmessage', 'Customer Deleted Successfully');
		redirect(base_url().'customer/lettscusyomer');
	}

	public function filosuspendCustomers()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-filofax-96375.cloudfunctions.net/widgets/changeusers/'.$id,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'PUT',
		  CURLOPT_POSTFIELDS =>'{
			"isActive":false
		   
		}'

		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
	
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect(base_url().'customer/filofaxcusyomer');
	}
	public function filounSuspendCustomer()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://us-central1-filofax-96375.cloudfunctions.net/widgets/changeusers/'.$id,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'PUT',
		  CURLOPT_POSTFIELDS =>'{
			"isActive":true
		   
		}'

		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url().'customer/filofaxcusyomer');
	}
	


	public function suspendCustomer()
	{
		$id = $this->uri->segment(3);
		$data["isActive"] = false;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Suspended');
		redirect(base_url().'customer');
	}

	public function unSuspendCustomer()
	{
		$id = $this->uri->segment(3);
		
		$data["isActive"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url().'customer');
	}


	public function adminvarify()
	{
		$id = $this->uri->segment(3);
		
		$data["isAdminVerify"] = true;
		$this->common->updatedatamodel("Users", $id, $data);
		$this->session->set_flashdata('successmessage', 'User Activated');
		redirect(base_url().'customer');
	}

	public function filodeleteCustomer()
	{
		$id = $this->uri->segment(3);
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://us-central1-filofax-96375.cloudfunctions.net/widgets/deleteusers/'.$id,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'DELETE',
		));
		$response = curl_exec($curl);
		curl_close($curl);

		$this->session->set_flashdata('successmessage', 'Customer Deleted Successfully');
		redirect(base_url().'customer/filofaxcusyomer');
	}

	public function deleteCustomer()
	{
		$id = $this->uri->segment(3);
		
		$response = $this->customer_model->delete_customer($id);
		if (!$response) {
			$this->session->set_flashdata('warningmessage', 'Something went wrong while deleting customer.');
			redirect(base_url().'customer');
		}
		$response = $this->common->deletedatamodel("Users", $id);
		$this->session->set_flashdata('successmessage', 'Customer Deleted Successfully');
		redirect(base_url().'customer');
	}

	public function addcustomer()
	{
		$this->template->template_render('customer_add');
	}
	//editcustomer
	public function editcustomers($id)
	{


		$data['id'] = $id;

		$data["customerdetails"] = $this->common->readdatadocument("Users", $id);

		$this->template->template_render('editcustomer', $data);
	}
	public function userreset()
	{
		$this->template->template_render('user_reset_credentials');
	}

	public function insertcustomer()
	{
		$data = $this->input->post();
		$data["userRole"] = "user";
		$data["city"] = NULL;
		$data["state"] = NULL;
		$data["token"] = NULL;
		$data["workAddress"] = NULL;
		$data["zipcode"] = NULL;
		$data["lat"] = 0;
		$data["lng"] = 0;
		$data["image"] = NULL;
		$data["clientSecret"] = NULL;
		$data["cusId"] = NULL;
		$data["ratings"] = NULL;
		$data["isApproved"] = TRUE;
		$data["isActive"] = true;

		$response = $this->customer_model->add_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'New customer added successfully');
			redirect('customer');
		} else {
			$errormsg = 'Error! User already Exists.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/addcustomer');
		}
	}



	public function updatecustomerdata($id)
	{
		$da = $this->input->post();
		//print_r($da);
		if ($da['newpassword'] != "") {

			$da['password'] = $da['newpassword'];
			$da['newpassword'] = "";
			$flag = $this->customer_model->update_customerpassword($id, $da['password']);




			if ($flag) {
				$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
				$this->session->set_flashdata('successmessage', 'User has been updated successfully');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something wrong, Please try again later');

				redirect(base_url().'customer/editcustomer/'.$id);
			}
		} else {
			$data["promotions"] = $this->common->updatedatamodel("Users", $id, $da);
			$this->session->set_flashdata('successmessage', 'User has been updated successfully');
		}



		redirect(base_url().'customer');
	}

	public function editcustomer()
	{
		$c_id = $this->uri->segment(3);
		$data['id'] = $c_id;
		$data['customerdetails'] = $this->customer_model->get_customerdetails($c_id);
		

		$this->template->template_render('editcustomer', $data);
	}

	public function resetCustomer()
	{
		// $data = $this->input->post();
		foreach ($_POST as $key => $val) {
			if (strpos($key, "new") === 0) {
				$name = substr($key, 3);
				$data["new"][$name] = $val;
			}
		}
		foreach ($_POST as $key => $val) {
			if (strpos($key, "old") === 0) {
				$name = substr($key, 3);
				$data["old"][$name] = $val;
			}
		}
		// print_r($data);
		// exit;
		$response = $this->customer_model->update_customer($data);
		if ($response) {
			$this->session->set_flashdata('successmessage', 'Customer updated successfully.');
			redirect('customer');
		} else {
			$errormsg = 'Error! Something went Wrong. Either the user does not exist or password does not match.';
			$this->session->set_flashdata('warningmessage', $errormsg);
			redirect('customer/userreset');
		}
	}

	public function updatecustomer()
	{
		$testxss = xssclean($_POST);
		if ($testxss) {
			$response = $this->customer_model->update_customer($this->input->post());
			if ($response) {
				$this->session->set_flashdata('successmessage', 'Customer updated successfully..');
				redirect('customer');
			} else {
				$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				redirect('customer');
			}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('customer');
		}
	}
}