<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo (isset($event)) ? 'Edit Event' : 'Add Event' ?>
                </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard/events">Events</a></li>
                    <li class="breadcrumb-item active"><?php echo (isset($event)) ? 'Edit Event' : 'Add Event' ?></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <?php
            if(isset($event)){
                $endPoint = "updateevent";
            }else{
                $endPoint = "insertevent";
            }
        ?>
        <form method="post" id="customer_add" class="card" action="<?php echo base_url() . "dashboard/". $endPoint ; ?>" enctype="multipart/form-data">
            <div class="card-body">

                <div class="row">
                    <input type="hidden" name="id" value="<?php echo (isset($event)) ? $event['id'] : '' ?>">

                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Name / Title</Title></label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['name'] : '' ?>" name="name" placeholder="Event Name">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Address</label>
                            <input type="text" required="true" class="form-control" name="address" value="<?php echo (isset($event)) ? $event['address'] : '' ?>" placeholder="Event Address">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Date</label>
                            <input type="datetime-local" required="true" class="form-control" value="<?php echo (isset($event)) ? date("Y-m-d\TH:i:s",$event['date']) : '' ?>" name="date">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price</label>
                            $<input type="number" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['price'] : '' ?>" name="price" placeholder="Event Price">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Image</label>
                            <input type="file" required="true" class="form-control" name="image">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Details</label>
                            <textarea required="true" class="form-control" name="details" placeholder="Event Details"><?php echo (isset($event)) ? $event['details'] : '' ?></textarea>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">

                    <button type="submit" class="btn btn-primary"> <?php echo (isset($event)) ? 'Update Event' : 'Add Event' ?></button>
                </div>
            </div>
        </form>
    </div>
</section>
<!-- /.content -->