<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800">All Events</h1>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <button class="btn btn-primary" onclick="location.href = '<?php echo(base_url()); ?>dashboard/addevent'">Add New Event</button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTableevent" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>id</th>
                            <th>Event Name</th>
                            <th>Address</th>
                            <th>Date</th>
                            <th>Price</th>
                            <th>Image</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>Event Name</th>
                            <th>Address</th>
                            <th>Date</th>
                            <th>Price</th>
                            <th>Image</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                    <tbody>
                        <?php
                           if (!empty($events)) {
                              $count = 1;
                              foreach ($events as $id => $event) {
                        ?>
                        <tr>
                            <td><?php echo output($event['addedby']); ?></td>
                            <td> <?php echo output($event['name']); ?></td>
                            <td> <?php echo output($event['address']); ?></td>
                            <td><?php echo output(date("d-m-Y h:i A",$event['date'])); ?></td>
                            <td><?php echo output($event['price']); ?></td>


                            <td>
                                <?php if ($event['image'] != "") { ?>

                                <img class="img-thumbnail" width="100" height="100" src="<?php echo output($event['image']); ?>">
                                <?php } else { ?>
                                <img class="img-thumbnail" src="http://placehold.jp/100x100.png">
                                <?php } ?>
                            </td>
                            <td>
                                <a class="icon" style="text-decoration: none;" href="<?php echo base_url(); ?>dashboard/editevent/<?php echo output($id); ?>">
                                    <button class="btn btn-info btn-block mt-2">Edit</button>
                                </a>
                                <a class="icon" style="text-decoration: none;" href="<?php echo base_url(); ?>dashboard/deleteevent/<?php echo output($id); ?>">
                                    <button class="btn btn-danger btn-block mt-2">Delete</button>
                                </a>
                            </td>
                        </tr>
                        <?php } } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->