<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Promotion Controller
 * 
 * NOTIFICATION ROUTING LOGIC:
 * 
 * This controller handles two types of notification routing:
 * 
 * 1. MARKET-BASED ROUTING (addnotificationdata, updatenotificationdata):
 *    - Routes notifications based on selected markets (cityIds)
 *    - If Houston is selected → sends to all Houston users (customers, vendors, drivers)
 *    - If Austin is selected → sends to all Austin users (customers, vendors, drivers)
 *    - If both are selected → sends to both groups
 *    - Uses filter_users_by_markets() helper function
 *    - Applies to admin broadcast notifications only
 * 
 * 2. CITY-SCOPED ROUTING (send_order_notification_to_drivers):
 *    - Routes to drivers in ONE specific city only
 *    - Used for order-related notifications (new orders, order updates)
 *    - Ensures strict city boundaries for operational notifications
 *    - Prevents cross-market contamination
 * 
 * NO CROSS-MARKET CONTAMINATION:
 * The following remain strictly city-scoped (not market-based):
 * - Orders: Each order belongs to one city only
 * - Drivers: Order notifications go to drivers in order's city only
 * - Vendors: Inventory and operations are city-scoped
 * - Inventory: Products and stock are city-scoped
 * - Product visibility: Products visible only in assigned city
 * 
 * Only admin broadcast notifications use market-based routing.
 */
class Promotion extends CI_Controller {
    function __construct()
 	{
	    parent::__construct();
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->model('common');
		$this->load->library('session');
	
		$this->load->library(array('form_validation','template'));
		define( 'API_ACCESS_KEY1', 'AAAAFqAjjzI:APA91bGlwApVaPeYiBww8P8N5vRKAqV5L2HMgC2lEtwS_9RdQfaK_9_SXoLfGJ9SJ3anynELX5gt-S8Vf8I-34QMkx84UB73LWIkI4j2pNeRzNhA3IG2F-JP9H3FRr-brdWU3Ht4DSUA');
	}

	public function index()   
	{
//echo "yes";
		$data["promotions"] = $this->common->readdatafromcollectionwhereclause("Promotions");
	
		$this->template->template_render('promotion', $data); 
	}

	public function notification(){
		$data["promotions"] = $this->common->readdatafromcollectionwhereclause("Notification","senderType","==","admin");
	
		$this->template->template_render('notification', $data); 
	}


public function updatenotificationdata(){
		$data = $this->input->post();
		$isAjax = $this->input->is_ajax_request();
		
		if (empty($data['id']) || empty($data['title']) || empty($data['message'])) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'ID, Title, and Message are required.'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'ID, Title, and Message are required.');
				redirect('promotion/notification');
				return;
			}
		}
		
		$id = $data['id'];
		
		// Get selected markets (cityIds)
		$selectedMarkets = isset($data['markets']) && is_array($data['markets']) ? $data['markets'] : array();
		
		// Get selected user types (optional - if empty, includes all types)
		$selectedUserTypes = isset($data['userTypes']) && is_array($data['userTypes']) ? $data['userTypes'] : array();
		
		// Validate market selection
		$marketValidation = validate_selected_markets($selectedMarkets);
		if (!$marketValidation['valid']) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => $marketValidation['message']));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', $marketValidation['message']);
				redirect('promotion/notification');
				return;
			}
		}
		
		$updateData = array(
			'title' => trim($data['title']),
			'message' => trim($data['message']),
			'selectedMarkets' => $selectedMarkets, // Update selected markets
			'selectedUserTypes' => $selectedUserTypes // Update selected user types
		);
		
		$response = $this->common->updatedatamodel("Notification", $id, $updateData);
		
		if ($response) {
			if ($isAjax) {
				echo json_encode(array('success' => true, 'message' => 'Notification has been updated successfully'));
				return;
			} else {
		$this->session->set_flashdata('successmessage', 'Notification has been updated successfully');
			}
		} else {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Failed to update notification'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Failed to update notification');
			}
		}

		if (!$isAjax) {
		redirect('promotion/notification');
		}
	}
public function updatepromodata($id=""){
		$data = $this->input->post();
		$isAjax = $this->input->is_ajax_request();
		
		// Validation
		if (empty($data['id']) || empty($data['title']) || empty($data['code'])) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'ID, Title, and Code are required.'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'ID, Title, and Code are required.');
				redirect('promotion');
				return;
			}
		}
		
		$id = $data['id'];
		
		// Validate date range
		if (!empty($data['startTime']) && !empty($data['endTime'])) {
			$startTimestamp = strtotime($data['startTime']);
			$endTimestamp = strtotime($data['endTime']);
			
			if ($endTimestamp < $startTimestamp) {
				if ($isAjax) {
					echo json_encode(array('success' => false, 'message' => 'End date must be after start date.'));
					return;
				} else {
					$this->session->set_flashdata('warningmessage', 'End date must be after start date.');
					redirect('promotion');
					return;
				}
			}
		}
		
		$updateData = array(
			'title' => trim($data['title']),
			'code' => trim($data['code']),
			'type' => isset($data['type']) ? trim($data['type']) : 'Percentage',
			'Percentage' => isset($data['Percentage']) ? (float)$data['Percentage'] : 0,
			'message' => isset($data['message']) ? trim($data['message']) : ''
		);
		
		if (!empty($data['startTime'])) {
			$updateData['startTime'] = strtotime($data['startTime']) * 1000;
		}
		if (!empty($data['endTime'])) {
			$updateData['endTime'] = strtotime($data['endTime']) * 1000;
		}

		$response = $this->common->updatedatamodel("Promotions", $id, $updateData);
		
		if ($response) {
			if ($isAjax) {
				echo json_encode(array('success' => true, 'message' => 'Promotion has been updated successfully'));
				return;
			} else {
		$this->session->set_flashdata('successmessage', 'Promotion has been updated successfully');
			}
		} else {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Failed to update promotion'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Failed to update promotion');
			}
		}

		if (!$isAjax) {
		redirect('promotion');
		}
	}
	public function editPromotion($id){


		$data['id']=$id;
		$data["promotions"] = $this->common->readdatadocument("Promotions",$id);

		 $this->template->template_render('addPromopage', $data); 
	
	}
	public function addPromopage(){
		$data = array();
		$data['promotions'] = null;
		$this->template->template_render('addPromopage', $data); 
	}
public function addNotification(){
	$data = array();
	// Get all cities for market selector
	$cities = $this->common->readdatafromcollectionwhereclause("Cities");
	$data['cities'] = $cities;
	$this->template->template_render('addnotificationpage', $data); 
}
	public function editNotification($id){
		$data['id'] = $id;
		$data["promotions"] = $this->common->readdatadocument("Notification", $id);
		// Get all cities for market selector
		$cities = $this->common->readdatafromcollectionwhereclause("Cities");
		$data['cities'] = $cities;
		 $this->template->template_render('addnotificationpage', $data); 
	}

 public function sendToOne()
    {
        $token = 'your-device-token-here';
        $title = 'Test Notification';
        $body = 'This is a test push to one device.';
        $data = ['type' => 'alert'];

        $result = $this->firebase->sendPushNotification($token, $title, $body, $data);

        echo json_encode($result);
    }
public function addnotificationdata()   
	{
		$data = $this->input->post();
		$isAjax = $this->input->is_ajax_request();
		
		// Validation
		if (empty($data['title']) || empty($data['message'])) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Title and Message are required.'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Title and Message are required.');
				redirect('Promotion/addNotification');
				return;
			}
		}
		
		// Get selected markets (cityIds)
		$selectedMarkets = isset($data['markets']) && is_array($data['markets']) ? $data['markets'] : array();
		
		// Get selected user types (optional - if empty, includes all types)
		$selectedUserTypes = isset($data['userTypes']) && is_array($data['userTypes']) ? $data['userTypes'] : array();
		
		// Validate market selection
		$marketValidation = validate_selected_markets($selectedMarkets);
		if (!$marketValidation['valid']) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => $marketValidation['message']));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', $marketValidation['message']);
				redirect('Promotion/addNotification');
				return;
			}
		}
		
		$id = "notification" . time();
		
		/**
		 * NOTIFICATION ROUTING LOGIC:
		 * 
		 * Notifications are routed based on selected markets (cityIds) and user types.
		 * - If Houston is selected → send to selected user types in Houston
		 * - If Austin is selected → send to selected user types in Austin
		 * - If both are selected → send to selected user types in both markets
		 * - If no user types selected → send to all user types (customers, vendors, drivers)
		 * 
		 * User Type Options:
		 * - 'user' = Customers
		 * - 'vendor' = Vendors
		 * - 'driver' = Drivers
		 * 
		 * IMPORTANT: This market-based routing applies to admin broadcast notifications only.
		 * Order-related driver notifications remain strictly city-scoped and use 
		 * send_order_notification_to_drivers() which filters by single cityId.
		 * 
		 * NO CROSS-MARKET CONTAMINATION:
		 * - Orders: Strictly city-scoped
		 * - Drivers: Strictly city-scoped for order notifications
		 * - Vendors: Strictly city-scoped for inventory/operations
		 * - Inventory: Strictly city-scoped
		 * - Product visibility: Strictly city-scoped
		 * - Admin notifications: Market-based routing with user type filtering (this function)
		 */
		
		// Filter users by selected markets and user types using helper function
		// If no user types selected, includes all user types (customers, vendors, drivers) in the selected markets
		$userFilterResult = filter_users_by_markets($selectedMarkets, $this->common, $selectedUserTypes);
		
		$listofid = $userFilterResult['userIds'];
		$tokenlist = $userFilterResult['tokens'];
		$userTypeCounts = $userFilterResult['userTypeCounts'];
		
		$notificationData = array(
			'id' => $id,
			'title' => trim($data['title']),
			'message' => trim($data['message']),
			'time' => time() * 1000,
			'senderID' => "RJb43Hc4PjSST6mRMzXtFYVd6t93",
			'type' => "adminnotification",
			'senderType' => "admin",
			'selectedMarkets' => $selectedMarkets, // Store selected city IDs for reference
			'selectedUserTypes' => $selectedUserTypes, // Store selected user types for reference
			'notificationType' => 'admin_broadcast', // Distinguish from order-related notifications
			'userID' => $listofid,
			'tokenlist' => $tokenlist
		);
		
		// Save notification to Firestore
		$response = $this->common->adddatamodel("Notification", $id, $notificationData);
		
		if ($response) {
			// Send push notifications to all users
			$title = trim($data['title']);
			$body = trim($data['message']);
			$notificationPayload = array('type' => 'adminnotification', 'id' => $id);
			
			// Send notifications in batches (FCM supports up to 1000 tokens per request)
			$batchSize = 1000;
			$batches = array_chunk($tokenlist, $batchSize);
			
			foreach ($batches as $batch) {
				$result = $this->send_notification($batch, $title, $body, $id, 'adminnotification');
			}
			
			// Get market names for display
			$marketNames = get_market_names($selectedMarkets, $this->common);
			
			// Format success message with market and user type breakdown
			$successMessage = format_notification_success_message(count($tokenlist), $userTypeCounts, $marketNames);
			
			if ($isAjax) {
				echo json_encode(array(
					'success' => true, 
					'message' => $successMessage,
					'stats' => array(
						'totalUsers' => count($tokenlist),
						'byType' => $userTypeCounts,
						'markets' => $marketNames
					)
				));
				return;
			} else {
				$this->session->set_flashdata('successmessage', $successMessage);
			}
		} else {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Failed to save notification'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Failed to save notification');
			}
		}
		
		if (!$isAjax) {
			redirect('Promotion/notification');
		}
	}
	function jana(){
		$j1=array(
			"dqXmsQfhfkJHpeU4soSQxS:APA91bEKNTpVLItjJodLjsO_GDiVmbrdOo5jfIdZvu9szVtf0PNBbkvP-9O50wLkQQZPTuyv0-odPFn45FJQK7Di_qu390qK_nvWemqUXUQsl_NR9_GEVOs",
		"eiaxxE7dxU9Cqs4n1wDwPw:APA91bHw9_u0Am6rTyVKmHVGTXRSeb2EdaSC95Fm55EaBml3nfmDampCMCHYoUI-vBOskYZhtMz4L85zjGZF5BJqvCUOchK7oqsPha0GryHYGT7eEr3EkIA",
"ciEIaAgoKkSDlaHICW_Juh:APA91bHUPZp7SSGyJ1QqNDTiECR3_abNnLKLBwsnX9B3MDiTkJGy-98POtnjPPxyrQjFGnXSq_GGGKiS3SYX0KVo0eltnetGvgbz5ofB2UCkGh_12PkLBzs",
"e6_oCXangEmxq-EIvJRqdn:APA91bGaopoOG3lPYmJriGI2iuucimVcwYc6VL-0chZRlAX5zDinlTmxLW_61AiqErrjFYj90KROtnD2W2ZlcegKQuyyxWL58VlJwRSUEpnekXN7fyIf9ac"
		);
		echo count($j1);
	//	exit;
		for($j=0;$j<count($j1);$j++){
			 $title = 'Test Notification';
        $body = 'This is a test push to one device.';
        $data = ['type' => 'alert'];
		$token=$j1[$j];
		echo $j;		
       $result = $this->firebase->sendPushNotification($token, $title, $body, $data);

       echo json_encode($result);
	   
		}
   
	}

	public function addpromodata()   
	{
		$data = $this->input->post();
		$isAjax = $this->input->is_ajax_request();
		
		// Validation
		if (empty($data['title']) || empty($data['code'])) {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Title and Code are required.'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Title and Code are required.');
				redirect('promotion/addPromopage');
				return;
			}
		}
		
		// Validate date range
		if (!empty($data['startTime']) && !empty($data['endTime'])) {
			$startTimestamp = strtotime($data['startTime']);
			$endTimestamp = strtotime($data['endTime']);
			
			if ($endTimestamp < $startTimestamp) {
				if ($isAjax) {
					echo json_encode(array('success' => false, 'message' => 'End date must be after start date.'));
					return;
				} else {
					$this->session->set_flashdata('warningmessage', 'End date must be after start date.');
					redirect('promotion/addPromopage');
					return;
				}
			}
		}
		
		$promoData = array(
			'id' => (string)time(),
			'title' => trim($data['title']),
			'code' => trim($data['code']),
			'type' => isset($data['type']) ? trim($data['type']) : 'Percentage',
			'Percentage' => isset($data['Percentage']) ? (float)$data['Percentage'] : 0,
			'message' => isset($data['message']) ? trim($data['message']) : ''
		);
		
		if (!empty($data['startTime'])) {
			$promoData["startTime"] = strtotime($data["startTime"]) * 1000;
		}
		if (!empty($data['endTime'])) {
			$promoData["endTime"] = strtotime($data["endTime"]) * 1000;
		}

		$response = $this->common->adddatamodel("Promotions", $promoData["id"], $promoData);
		
		if ($response) {
			if ($isAjax) {
				echo json_encode(array('success' => true, 'message' => 'New Promotion added successfully'));
				return;
			} else {
		$this->session->set_flashdata('successmessage', 'New Promotion added successfully');
			}
		} else {
			if ($isAjax) {
				echo json_encode(array('success' => false, 'message' => 'Failed to add promotion'));
				return;
			} else {
				$this->session->set_flashdata('warningmessage', 'Failed to add promotion');
			}
		}
		
		if (!$isAjax) {
		redirect('promotion');
		}
	}

public function mytest($id="111",$msg="new data",$type="promotion",$ntype="user"){
	$data["promotions"] = $this->common->readdatafromcollectionbetween2where("Users","userRole","=",$ntype,"token","!=","");
		$token=array();
		$userIdArray=array();
	


		foreach($data["promotions"] as $l=>$j){
			 if(!empty($j['token'])  && $j['token'] !=""){
			 	  $userIdArray[$l] = false;
			array_push($token, $j['token'])	; 	
			 }
	
		}
		// echo "<pre>";
		// print_r($token);

		$notification=$this->send_notification($token,"New Promotion",$msg,$id,$type);
// print_r($notification);
// echo "</pre>";
}

function send_notification($token_id,$title,$body,$id,$type){
	 
	$icon=base_url('uploads/logo.png');
	
	$finalPostArray = array('registration_ids' => $token_id,
								'notification' => array('body' => $body,
														'title' => $title,
														"image"=> $icon,
														   "sound"=> "sample4_out.caf"
													),
									'aps'=>array(
										"sound"=> "sample4_out.caf"
									),				
								"data"=> array("click_action"=> "FLUTTER_NOTIFICATION_CLICK",
												"type"=>$type,
												"id"=>$id,
												"sound"=> "sample4_out.caf", 
												"soundios"=> "sample4_out.caf",
												"vibrate"=> 1)); 
		
	
		
		
		$headers = array
				(
					'Authorization: key=' . API_ACCESS_KEY1,
					'Content-Type: application/json'
				);
	#Send Reponse To FireBase Server	
			$ch = curl_init();
			curl_setopt( $ch,CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send' );
			curl_setopt( $ch,CURLOPT_POST, true );
			curl_setopt( $ch,CURLOPT_HTTPHEADER, $headers );
			curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
			curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );
			curl_setopt( $ch,CURLOPT_POSTFIELDS, json_encode( $finalPostArray ) );
			$result['mystatus'] = curl_exec($ch );
			curl_close( $ch );
	#Echo Result Of FireBase Server
	//$result['firbasestatus']=$fields;
	return $result;
		}

	/**
	 * Send order-related notification to drivers in a specific city
	 * 
	 * IMPORTANT: This function is STRICTLY CITY-SCOPED for order-related notifications.
	 * It differs from market-based notification routing used in addnotificationdata().
	 * 
	 * ROUTING LOGIC DIFFERENCES:
	 * - Market-based routing (addnotificationdata): Routes to users in selected markets
	 *   (can be multiple cities: Houston, Austin, or both)
	 * - City-scoped routing (this function): Routes to drivers in ONE specific city only
	 *   (used for order assignments, order updates, etc.)
	 * 
	 * NO CROSS-MARKET CONTAMINATION:
	 * Order-related driver notifications MUST remain city-scoped to ensure:
	 * - Drivers only see orders in their assigned city
	 * - No cross-market order visibility
	 * - Proper operational boundaries
	 * 
	 * @param string $cityId The city ID where the order was placed (single city only)
	 * @param string $title Notification title
	 * @param string $body Notification message
	 * @param string $orderId The order ID
	 * @param string $type Notification type (e.g., 'neworder', 'orderupdate')
	 * @return array Result of the notification send
	 */
	function send_order_notification_to_drivers($cityId, $title, $body, $orderId, $type = 'order') {
		// Get all drivers
		$allDrivers = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "==", "driver");
		
		$tokenlist = array();
		
		// Filter drivers by city - STRICTLY city-scoped for order-related notifications
		foreach ($allDrivers as $driverId => $driver) {
			// Only include drivers in the specific city
			if (isset($driver['cityId']) && $driver['cityId'] == $cityId) {
				// Only include approved/active drivers
				if (isset($driver['isApproved']) && $driver['isApproved'] && isset($driver['token']) && $driver['token'] != "") {
					array_push($tokenlist, $driver['token']);
				}
			}
		}
		
		if (empty($tokenlist)) {
			return array('success' => false, 'message' => 'No active drivers found in this city');
		}
		
		// Send notifications in batches (FCM supports up to 1000 tokens per request)
		$batchSize = 1000;
		$batches = array_chunk($tokenlist, $batchSize);
		
		foreach ($batches as $batch) {
			$result = $this->send_notification($batch, $title, $body, $orderId, $type);
		}
		
		return array(
			'success' => true, 
			'message' => 'Notification sent to ' . count($tokenlist) . ' driver(s) in city',
			'driverCount' => count($tokenlist)
		);
	}

	public function addPromotion()   
	{
		$data = $this->input->post();
		$data["id"] = time();
		$data["startTime"] = strtotime($data["startTime"]) * 1000;
		$data["endTime"] = strtotime($data["endTime"]) * 1000;
		$data["noOfTrips"] = (int)$data["noOfTrips"];
		$data["remainingRides"] = NULL;
		$data["rideModels"] = NULL;
		$data["type"] = "driver";
		settype($data["id"], "string");

	$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

if ($_FILES['file']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['file']['tmp_name']),
				[
					'name' => "permo" . rand() . time() . $_FILES['file']['name'],
				]
			);

			$data['url'] = $uploadedFile->info()['mediaLink'];
		}


		$this->common->adddatamodel("Promotions", $data["id"], $data);
		$this->mytest($data["id"],$data['message'],'promotion',"driver");		
		
		$this->session->set_flashdata('successmessage', 'New Promotion added successfully');
		redirect('promotion');
	}

	public function deletePromotion($id)   
	{
		$this->common->deletedatamodel("Promotions", $id);
		$this->session->set_flashdata('successmessage', 'Promotion Deleted');
		redirect('promotion');
	}
		public function deleteNotification($id)   
	{
		$this->common->deletedatamodel("Notification", $id);
		$this->session->set_flashdata('successmessage', 'Notification Deleted');
		redirect('promotion/notification');
	}
	
	
}
