<style>
.form-header-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.form-card-modern {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.form-card-modern .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.form-card-modern .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
    font-size: 1rem;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-group-modern {
    margin-bottom: 1.5rem;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.4);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}
</style>

<div class="form-header-modern">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-<?php echo (isset($promotions)) ? 'edit' : 'plus-circle'; ?>"></i> 
                <?php echo (isset($promotions)) ? 'Edit Promotion' : 'Add New Promotion'; ?>
            </h2>
            <p class="mb-0 opacity-75"><?php echo (isset($promotions)) ? 'Update promotion details' : 'Create a new promotional campaign'; ?></p>
        </div>
        <div>
            <a href="<?php echo base_url('Promotion'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to Promotions
            </a>
        </div>
    </div>
</div>

<?php
$endpoint = isset($promotions) ? 'updatepromodata' : 'addpromodata';
$promoId = isset($id) ? $id : '';
$promoTitle = isset($promotions) && isset($promotions['title']) ? $promotions['title'] : '';
$promoCode = isset($promotions) && isset($promotions['code']) ? $promotions['code'] : '';
$promoType = isset($promotions) && isset($promotions['type']) ? $promotions['type'] : 'Percentage';
$promoPercentage = isset($promotions) && isset($promotions['Percentage']) ? $promotions['Percentage'] : '';
$promoMessage = isset($promotions) && isset($promotions['message']) ? $promotions['message'] : '';
$promoStartTime = '';
$promoEndTime = '';
if (isset($promotions) && !empty($promotions)) {
    if (isset($promotions['startTime']) && $promotions['startTime'] > 0) {
        $promoStartTime = date('Y-m-d', $promotions['startTime'] / 1000);
    }
    if (isset($promotions['endTime']) && $promotions['endTime'] > 0) {
        $promoEndTime = date('Y-m-d', $promotions['endTime'] / 1000);
    }
}
?>

<form method="post" id="promotionForm" action="<?php echo base_url('Promotion/' . $endpoint); ?>">
    <input type="hidden" name="id" id="id" value="<?php echo $promoId; ?>">
    
    <!-- Basic Information -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-info-circle text-primary"></i> Basic Information
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group-modern">
                    <label for="title" class="form-label-modern">Promotion Title <span class="text-danger">*</span></label>
                    <input type="text" 
                        class="form-control form-control-modern" 
                        id="title" 
                        name="title" 
                        placeholder="Enter promotion title" 
                        value="<?php echo htmlspecialchars($promoTitle); ?>" 
                        required>
                </div>
                <div class="col-md-6 form-group-modern">
                    <label for="code" class="form-label-modern">Promo Code <span class="text-danger">*</span></label>
                    <input type="text" 
                        class="form-control form-control-modern" 
                        id="code" 
                        name="code" 
                        placeholder="Enter promo code (e.g., SAVE20)" 
                        value="<?php echo htmlspecialchars($promoCode); ?>" 
                        required>
                    <small class="text-muted">Unique code for customers to use</small>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 form-group-modern">
                    <label for="message" class="form-label-modern">Message <span class="text-danger">*</span></label>
                    <textarea class="form-control form-control-modern" 
                        id="message" 
                        name="message" 
                        rows="4" 
                        placeholder="Enter promotion message/description" 
                        required><?php echo htmlspecialchars($promoMessage); ?></textarea>
                </div>
            </div>
        </div>
    </div>

    <!-- Discount Information -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-percent text-primary"></i> Discount Information
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group-modern">
                    <label for="type" class="form-label-modern">Discount Type <span class="text-danger">*</span></label>
                    <select class="form-control form-control-modern" id="type" name="type" required>
                        <option value="Percentage" <?php echo ($promoType == 'Percentage') ? 'selected' : ''; ?>>Percentage (%)</option>
                        <option value="Flat" <?php echo ($promoType == 'Flat') ? 'selected' : ''; ?>>Flat Amount ($)</option>
                    </select>
                </div>
                <div class="col-md-6 form-group-modern">
                    <label for="Percentage" class="form-label-modern">Discount Value <span class="text-danger">*</span></label>
                    <input type="number" 
                        step="0.01" 
                        min="0" 
                        class="form-control form-control-modern" 
                        id="Percentage" 
                        name="Percentage" 
                        placeholder="0.00" 
                        value="<?php echo $promoPercentage; ?>" 
                        required>
                    <small class="text-muted" id="discountHint">Enter percentage (e.g., 20 for 20%)</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Date Range -->
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-calendar text-primary"></i> Promotion Period
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group-modern">
                    <label for="startTime" class="form-label-modern">Start Date <span class="text-danger">*</span></label>
                    <input type="date" 
                        class="form-control form-control-modern" 
                        id="startTime" 
                        name="startTime" 
                        value="<?php echo $promoStartTime; ?>" 
                        required>
                </div>
                <div class="col-md-6 form-group-modern">
                    <label for="endTime" class="form-label-modern">End Date <span class="text-danger">*</span></label>
                    <input type="date" 
                        class="form-control form-control-modern" 
                        id="endTime" 
                        name="endTime" 
                        value="<?php echo $promoEndTime; ?>" 
                        required>
                </div>
            </div>
        </div>
    </div>

    <!-- Submit Button -->
    <div class="text-end mb-4">
        <button type="submit" class="btn btn-submit-modern">
            <i class="fa-solid fa-save"></i> <?php echo (isset($promotions)) ? 'Update Promotion' : 'Add Promotion'; ?>
        </button>
    </div>
</form>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    // Update discount hint based on type
    $('#type').on('change', function() {
        var type = $(this).val();
        var hint = $('#discountHint');
        if (type == 'Percentage') {
            hint.text('Enter percentage (e.g., 20 for 20%)');
        } else {
            hint.text('Enter flat amount in dollars (e.g., 10 for $10)');
        }
    });
    
    // Validate end date is after start date
    $('#endTime').on('change', function() {
        var startDate = $('#startTime').val();
        var endDate = $(this).val();
        if (startDate && endDate && endDate < startDate) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Date Range',
                text: 'End date must be after start date'
            });
            $(this).val('');
        }
    });
    
    // Form submission
    $('#promotionForm').on('submit', function(e) {
        var form = $(this);
        var formData = form.serialize();
        var url = form.attr('action');
        var submitBtn = form.find('button[type="submit"]');
        var originalText = submitBtn.html();
        
        submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            success: function(response) {
                submitBtn.prop('disabled', false).html(originalText);
                
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '<?php echo (isset($promotions)) ? 'Promotion updated successfully!' : 'Promotion added successfully!'; ?>',
                    confirmButtonText: 'OK',
                    timer: 2000,
                    timerProgressBar: true
                }).then(function() {
                    window.location.href = '<?php echo base_url("Promotion"); ?>';
                });
            },
            error: function() {
                submitBtn.prop('disabled', false).html(originalText);
                // Fallback to regular form submission
                form.off('submit').submit();
            }
        });
        
        e.preventDefault();
    });
});
</script>
