<style>
.form-header-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.form-card-modern {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.form-card-modern .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.form-card-modern .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
    font-size: 1rem;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-group-modern {
    margin-bottom: 1.5rem;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.4);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}
</style>

<div class="form-header-modern">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-<?php echo (isset($category)) ? 'edit' : 'plus-circle'; ?>"></i> 
                <?php echo (isset($category)) ? 'Edit Subcategory' : 'Add New Subcategory'; ?>
            </h2>
            <p class="mb-0 opacity-75"><?php echo (isset($category)) ? 'Update subcategory information' : 'Create a new subcategory under a main category'; ?></p>
        </div>
        <div>
            <a href="<?php echo base_url('dashboard/subcategories'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to Subcategories
            </a>
        </div>
    </div>
</div>

<?php
$endpoint = isset($category) ? 'updatesubcategory' : 'insertsubcategory';
$subcategoryName = isset($category) && isset($category['name']) ? $category['name'] : '';
$subcategoryId = isset($id) ? $id : '';
$selectedCategoryId = isset($category) && isset($category['categoryId']) ? $category['categoryId'] : '';
?>

<form method="post" id="subcategoryForm" action="<?php echo base_url('dashboard/' . $endpoint); ?>">
    <input type="hidden" name="id" id="id" value="<?php echo $subcategoryId; ?>">
    
    <div class="form-card-modern">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-info-circle text-primary"></i> Subcategory Information
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group-modern">
                    <label for="name" class="form-label-modern">Subcategory Name <span class="text-danger">*</span></label>
                    <input type="text" 
                        class="form-control form-control-modern" 
                        id="name" 
                        name="name" 
                        placeholder="Enter subcategory name" 
                        value="<?php echo htmlspecialchars($subcategoryName); ?>" 
                        required>
                    <small class="text-muted">This will be used to further organize your products</small>
                </div>
                <div class="col-md-6 form-group-modern">
                    <label for="categoryId" class="form-label-modern">Parent Category <span class="text-danger">*</span></label>
                    <select class="form-control form-control-modern" id="categoryId" name="categoryId" required>
                        <option value="">Select Category</option>
                        <?php 
                        if (!empty($categories)) {
                            foreach ($categories as $catId => $cat) {
                                $catName = isset($cat['name']) ? $cat['name'] : (isset($cat['categoryName']) ? $cat['categoryName'] : 'Unknown');
                                $selected = ($catId == $selectedCategoryId) ? 'selected' : '';
                                echo '<option value="' . $catId . '" ' . $selected . '>' . htmlspecialchars($catName) . '</option>';
                            }
                        }
                        ?>
                    </select>
                    <small class="text-muted">Select the main category this subcategory belongs to</small>
                </div>
            </div>
        </div>
    </div>

    <div class="text-end mb-4">
        <button type="submit" class="btn btn-submit-modern">
            <i class="fa-solid fa-save"></i> <?php echo (isset($category)) ? 'Update Subcategory' : 'Add Subcategory'; ?>
        </button>
    </div>
</form>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#subcategoryForm').on('submit', function(e) {
        var form = $(this);
        var formData = form.serialize();
        var url = form.attr('action');
        var submitBtn = form.find('button[type="submit"]');
        var originalText = submitBtn.html();
        
        submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            success: function(response) {
                submitBtn.prop('disabled', false).html(originalText);
                
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '<?php echo (isset($category)) ? 'Subcategory updated successfully!' : 'Subcategory added successfully!'; ?>',
                    confirmButtonText: 'OK',
                    timer: 2000,
                    timerProgressBar: true
                }).then(function() {
                    window.location.href = '<?php echo base_url("dashboard/subcategories"); ?>';
                });
            },
            error: function() {
                submitBtn.prop('disabled', false).html(originalText);
                // Fallback to regular form submission
                form.off('submit').submit();
            }
        });
        
        e.preventDefault();
    });
});
</script>
