<style>
.city-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.city-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.city-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.city-table-card table thead {
    background: #f7fafc;
}

.city-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.city-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.city-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.city-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.action-btn-group {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.action-btn-group .btn {
    flex: 1;
    min-width: 100px;
}
</style>

<!-- Header Section -->
<div class="city-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-city"></i> City Management
            </h2>
            <p class="mb-0 opacity-75">Manage cities, HQ addresses, and delivery zone configurations</p>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?= base_url() . 'dashboard/addcity' ?>" class="btn btn-light btn-modern btn-modern-primary">
                <i class="fa-solid fa-plus"></i> Add City
            </a>
        </div>
    </div>
</div>

<!-- Cities Table -->
<div class="city-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Cities List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="songTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>City Name</th>
                        <th>State</th>
                        <th>Country</th>
                        <th>HQ Address</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($cities)) {
                        $count = 1;
                        foreach ($cities as $id => $city) {
                    ?>
                    <tr>
                        <td><?php echo $count; ?></td>
                        <td>
                            <strong><?php echo isset($city['cityName']) ? $city['cityName'] : ''; ?></strong>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-map-pin"></i>
                                <?php echo isset($city['state']) ? $city['state'] : '-'; ?>
                            </span>
                        </td>
                        <td><?php echo isset($city['country']) ? $city['country'] : '-'; ?></td>
                        <td>
                            <?php if (isset($city['hqAddress']) && $city['hqAddress'] != ''): ?>
                                <small class="text-muted">
                                    <i class="fa-solid fa-building"></i>
                                    <?php 
                                    $hqAddress = $city['hqAddress'];
                                    echo strlen($hqAddress) > 40 ? substr($hqAddress, 0, 40) . '...' : $hqAddress;
                                    ?>
                                </small>
                            <?php else: ?>
                                <span class="text-muted">
                                    <i class="fa-solid fa-exclamation-circle"></i> Not Set
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="action-btn-group">
                                <a href="<?=base_url('dashboard/editcity/'.$id)?>" class="btn btn-sm btn-primary btn-modern">
                                    <i class="fa-solid fa-edit"></i> Edit
                                </a>
                                <a href="<?=base_url('dashboard/cityzones/'.$id)?>" class="btn btn-sm btn-info btn-modern">
                                    <i class="fa-solid fa-cog"></i> Zones
                                </a>
                                <a href="<?=base_url('dashboard/deletecity/'.$id)?>" 
                                   class="btn btn-sm btn-danger btn-modern"
                                   onclick="return confirm('Are you sure you want to delete this city? This action cannot be undone.');">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php 
                        $count++;
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#songTable').DataTable({
        "order": [[ 1, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ cities per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ cities",
            "infoEmpty": "No cities found",
            "infoFiltered": "(filtered from _MAX_ total cities)"
        }
    });
});
</script>
