<style>
.analytics-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.stats-card.primary { border-left-color: #72A565; }
.stats-card.success { border-left-color: #48bb78; }
.stats-card.warning { border-left-color: #ed8936; }
.stats-card.info { border-left-color: #4299e1; }
.stats-card.danger { border-left-color: #f56565; }

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stats-number.success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.analytics-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.analytics-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.analytics-card .card-body {
    padding: 1.5rem;
}

.table-modern {
    width: 100%;
}

.table-modern thead {
    background: #f7fafc;
}

.table-modern thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    padding: 1rem;
    border-bottom: 2px solid #e2e8f0;
}

.table-modern tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.table-modern tbody tr:hover {
    background: #f7fafc;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}
</style>

<!-- Header Section -->
<div class="analytics-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-chart-line"></i> City Analytics - <?php echo htmlspecialchars($city['cityName']); ?>
            </h2>
            <p class="mb-0 opacity-75">Detailed analytics and statistics for this market</p>
        </div>
        <div>
            <a href="<?php echo base_url('dashboard/cities'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to Markets
            </a>
        </div>
    </div>
</div>

<!-- Key Statistics -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stats-card primary">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Orders</h6>
                    <h3 class="stats-number mb-0"><?php echo $analytics['totalOrders']; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-shopping-cart fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card success">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Revenue</h6>
                    <h3 class="stats-number success mb-0">$<?php echo number_format($analytics['totalRevenue'], 2); ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-dollar-sign fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card info">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Avg Order Value</h6>
                    <h3 class="stats-number info mb-0">$<?php echo number_format($analytics['averageOrderValue'], 2); ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-chart-bar fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card warning">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Pending Orders</h6>
                    <h3 class="stats-number warning mb-0"><?php echo $analytics['pendingOrders']; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-clock fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Statistics -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stats-card success">
            <h6 class="text-muted mb-2">Completed Orders</h6>
            <h4 class="mb-0"><?php echo $analytics['completedOrders']; ?></h4>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card danger">
            <h6 class="text-muted mb-2">Cancelled Orders</h6>
            <h4 class="mb-0"><?php echo $analytics['cancelledOrders']; ?></h4>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card info">
            <h6 class="text-muted mb-2">Active Drivers</h6>
            <h4 class="mb-0"><?php echo $analytics['activeDrivers']; ?> / <?php echo $analytics['totalDrivers']; ?></h4>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card warning">
            <h6 class="text-muted mb-2">Active Vendors</h6>
            <h4 class="mb-0"><?php echo $analytics['activeVendors']; ?> / <?php echo $analytics['totalVendors']; ?></h4>
        </div>
    </div>
</div>

<!-- Orders by Status -->
<div class="analytics-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-list"></i> Orders by Status
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-modern">
                <thead>
                    <tr>
                        <th>Status</th>
                        <th class="text-end">Count</th>
                        <th class="text-end">Percentage</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $totalOrders = $analytics['totalOrders'];
                    foreach ($analytics['ordersByStatus'] as $status => $count): 
                        $percentage = $totalOrders > 0 ? ($count / $totalOrders) * 100 : 0;
                    ?>
                    <tr>
                        <td>
                            <span class="badge bg-primary"><?php echo ucfirst($status); ?></span>
                        </td>
                        <td class="text-end"><strong><?php echo $count; ?></strong></td>
                        <td class="text-end"><?php echo number_format($percentage, 1); ?>%</td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Recent Orders -->
<div class="analytics-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-shopping-cart"></i> Recent Orders
        </h5>
    </div>
    <div class="card-body">
        <?php if (!empty($cityOrders)): ?>
        <div class="table-responsive">
            <table class="table table-modern">
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th class="text-end">Amount</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $count = 0;
                    foreach (array_slice($cityOrders, 0, 10, true) as $orderId => $order): 
                        $count++;
                        $orderDate = isset($order['date']) ? date('Y-m-d H:i', $order['date'] / 1000) : 'N/A';
                        $orderAmount = isset($order['totalAmount']) ? floatval($order['totalAmount']) : 0;
                        $orderStatus = isset($order['orderStatus']) ? $order['orderStatus'] : 'pending';
                    ?>
                    <tr>
                        <td><small><?php echo substr($orderId, 0, 12); ?>...</small></td>
                        <td><?php echo $orderDate; ?></td>
                        <td>
                            <span class="badge bg-<?php 
                                echo $orderStatus == 'delivered' ? 'success' : 
                                    ($orderStatus == 'cancelled' ? 'danger' : 'warning'); 
                            ?>">
                                <?php echo ucfirst($orderStatus); ?>
                            </span>
                        </td>
                        <td class="text-end"><strong>$<?php echo number_format($orderAmount, 2); ?></strong></td>
                        <td class="text-center">
                            <a href="<?php echo base_url('orders/view/' . $orderId); ?>" class="btn btn-sm btn-primary">
                                <i class="fa-solid fa-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="text-center mt-3">
            <a href="<?php echo base_url('orders?filter_city=' . $cityId); ?>" class="btn btn-modern btn-modern-primary">
                <i class="fa-solid fa-list"></i> View All Orders
            </a>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="fa-solid fa-shopping-cart fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No Orders Found</h5>
            <p class="text-muted">No orders have been placed in this market yet.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
