<style>
.zone-config-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.zone-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.zone-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.zone-card .card-body {
    padding: 2rem;
}

.zone-table {
    width: 100%;
}

.zone-table thead {
    background: #f7fafc;
}

.zone-table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    padding: 1rem;
    border-bottom: 2px solid #e2e8f0;
}

.zone-table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.zone-table tbody tr:hover {
    background: #f7fafc;
}

.zone-table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.zone-badge {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-block;
}

.zone-badge.zone1 {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.zone-badge.zone2 {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.zone-badge.zone3 {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.zone-badge.zone4 {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.form-control-zone {
    border-radius: 8px;
    border: 2px solid #e2e8f0;
    padding: 0.5rem 0.75rem;
    transition: all 0.3s ease;
}

.form-control-zone:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.4);
    color: white;
}

.rules-list {
    list-style: none;
    padding: 0;
}

.rules-list li {
    padding: 0.75rem 1rem;
    margin-bottom: 0.5rem;
    background: #f7fafc;
    border-left: 4px solid #667eea;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.rules-list li:hover {
    background: #edf2f7;
    transform: translateX(5px);
}

.rules-list li strong {
    color: #667eea;
}
</style>

<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="zone-config-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="mb-2">
                    <i class="fa-solid fa-map-marked-alt"></i> Delivery Zones Configuration
                </h2>
                <p class="mb-0 opacity-75"><?php echo isset($city['cityName']) ? $city['cityName'] : ''; ?> - Configure distance ranges, fees, and minimum orders</p>
            </div>
            <div>
                <a href="<?php echo base_url('dashboard/cities'); ?>" class="btn btn-light btn-modern">
                    <i class="fa-solid fa-arrow-left"></i> Back to Cities
                </a>
            </div>
        </div>
    </div>
    
    <?php
    // Get existing zones or use defaults
    $configuredZones = array();
    if (!empty($zones)) {
        $zoneData = reset($zones);
        $configuredZones = isset($zoneData['zones']) ? $zoneData['zones'] : array();
    }
    
    // Default zones if not configured
    if (empty($configuredZones)) {
        $zones = array(
            'zone1' => array('minDistance' => 0, 'maxDistance' => 12, 'fee' => 3.00, 'minimumOrder' => 25.00),
            'zone2' => array('minDistance' => 12, 'maxDistance' => 20, 'fee' => 6.50, 'minimumOrder' => 25.00, 'storefrontMinimumOrder' => 40.00),
            'zone3' => array('minDistance' => 20, 'maxDistance' => 30, 'fee' => 10.00, 'minimumOrder' => 70.00),
            'zone4' => array('minDistance' => 30, 'maxDistance' => 999999, 'fee' => 15.00, 'minimumOrder' => 125.00)
        );
    } else {
        $zones = $configuredZones;
    }
    ?>
    
    <!-- Zone Configuration Form -->
    <div class="zone-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-sliders-h text-primary"></i> Zone Configuration
            </h5>
        </div>
        <div class="card-body">
            <p class="text-muted mb-4">
                <i class="fa-solid fa-info-circle"></i> Zones are calculated from the city HQ. Configure distance ranges, fees, and minimum orders per zone.
            </p>
            
            <form method="post" action="<?php echo base_url('dashboard/updatecityzones'); ?>">
                <input type="hidden" name="cityId" value="<?php echo $cityId; ?>">
                
                <div class="table-responsive">
                    <table class="zone-table">
                        <thead>
                            <tr>
                                <th>Zone</th>
                                <th>Distance Range (miles)</th>
                                <th>Delivery Fee ($)</th>
                                <th>Minimum Order ($)</th>
                                <th>Storefront Min Order ($)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($zones as $zoneKey => $zone): ?>
                            <tr>
                                <td>
                                    <span class="zone-badge <?php echo $zoneKey; ?>">
                                        <?php echo strtoupper($zoneKey); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="row g-2">
                                        <div class="col-6">
                                            <input type="number" step="0.1" name="<?php echo $zoneKey; ?>_minDistance" 
                                                   class="form-control form-control-zone" value="<?php echo $zone['minDistance']; ?>" required>
                                            <small class="text-muted">Min</small>
                                        </div>
                                        <div class="col-6">
                                            <input type="number" step="0.1" name="<?php echo $zoneKey; ?>_maxDistance" 
                                                   class="form-control form-control-zone" 
                                                   value="<?php echo $zone['maxDistance'] == 999999 ? '' : $zone['maxDistance']; ?>" 
                                                   placeholder="30+">
                                            <small class="text-muted">Max</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <input type="number" step="0.01" name="<?php echo $zoneKey; ?>_fee" 
                                           class="form-control form-control-zone" value="<?php echo $zone['fee']; ?>" required>
                                </td>
                                <td>
                                    <input type="number" step="0.01" name="<?php echo $zoneKey; ?>_minOrder" 
                                           class="form-control form-control-zone" value="<?php echo $zone['minimumOrder']; ?>" required>
                                </td>
                                <td>
                                    <?php if ($zoneKey == 'zone2'): ?>
                                    <input type="number" step="0.01" name="<?php echo $zoneKey; ?>_storefrontMinOrder" 
                                           class="form-control form-control-zone" 
                                           value="<?php echo isset($zone['storefrontMinimumOrder']) ? $zone['storefrontMinimumOrder'] : 40.00; ?>" 
                                           placeholder="40.00">
                                    <small class="text-muted">Zone 2 only</small>
                                    <?php else: ?>
                                    <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <div class="text-end mt-4">
                    <button type="submit" class="btn btn-submit-modern">
                        <i class="fa-solid fa-save"></i> Save Zone Configuration
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Zone Calculation Rules -->
    <div class="zone-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-info-circle text-primary"></i> Zone Calculation Rules
            </h5>
        </div>
        <div class="card-body">
            <ul class="rules-list">
                <li>
                    <strong>Cannabus Inventory Orders:</strong> Distance = HQ → Customer
                </li>
                <li>
                    <strong>Storefront Vendor Orders:</strong> Distance = HQ → Vendor + Vendor → Customer
                </li>
                <li>
                    <strong>Multi-Vendor Orders:</strong> Use farthest vendor from HQ
                </li>
                <li>
                    <strong>Cannabus Inventory + Storefront:</strong> Only storefront distance counts
                </li>
                <li>
                    <strong>Zone 2 Storefront:</strong> Requires $40 minimum (protects against long pickup trips)
                </li>
            </ul>
        </div>
    </div>
</div>
