<style>
.customer-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.customer-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.customer-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.customer-stats-card.primary { border-left-color: #72A565; }
.customer-stats-card.success { border-left-color: #48bb78; }
.customer-stats-card.warning { border-left-color: #ed8936; }
.customer-stats-card.info { border-left-color: #4299e1; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.customer-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.customer-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.customer-table-card table thead {
    background: #f7fafc;
}

.customer-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.customer-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.customer-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.customer-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.btn-modern-warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.btn-modern-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-modern-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.action-dropdown .dropdown-menu {
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    border: none;
    padding: 0.5rem;
}

.action-dropdown .dropdown-item {
    border-radius: 8px;
    padding: 0.75rem 1rem;
    transition: all 0.2s ease;
    margin-bottom: 0.25rem;
}

.action-dropdown .dropdown-item:hover {
    background: #f7fafc;
    transform: translateX(5px);
}

.action-dropdown .dropdown-item i {
    width: 20px;
    text-align: center;
}

.customer-name-link {
    color: #72A565;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.customer-name-link:hover {
    color: #91A134;
    text-decoration: none;
    transform: translateX(5px);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stats-number.success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.stats-number.info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}

.id-image {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    cursor: pointer;
    transition: transform 0.3s ease;
}

.id-image:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.tab-button {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.tab-button.active {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    border-color: transparent;
}

.tab-button:not(.active) {
    background: white;
    color: #72A565;
    border-color: #72A565;
}

.tab-button:not(.active):hover {
    background: #f7fafc;
    transform: translateY(-2px);
}
</style>

<!-- Header Section -->
<div class="customer-management-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fa-solid fa-users"></i> Customer Management
            </h2>
            <p class="mb-0 opacity-75">Manage customers, view loyalty points, and handle customer verification</p>
        </div>
        <div class="col-md-4 text-end">
            <div class="btn-group" role="group">
                <a href="<?php echo base_url('Customer'); ?>" 
                   class="btn tab-button <?php echo (isset($filterType) && $filterType == 'pending') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-clock"></i> Pending
                </a>
                <a href="<?php echo base_url('Customer/approvedcustomer'); ?>" 
                   class="btn tab-button <?php echo (isset($filterType) && $filterType == 'approved') ? 'active' : ''; ?>">
                    <i class="fa-solid fa-check-circle"></i> Approved
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card primary">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Customers</h6>
                    <h3 class="stats-number mb-0"><?php echo isset($stats['totalCustomers']) ? $stats['totalCustomers'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-users fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card success">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">With Loyalty Points</h6>
                    <h3 class="stats-number success mb-0"><?php echo isset($stats['withLoyaltyPoints']) ? $stats['withLoyaltyPoints'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-star fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card info">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">Total Loyalty Points</h6>
                    <h3 class="stats-number info mb-0"><?php echo isset($stats['totalLoyaltyPoints']) ? number_format($stats['totalLoyaltyPoints']) : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-gift fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="customer-stats-card warning">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h6 class="text-muted mb-2">ID Verified</h6>
                    <h3 class="stats-number warning mb-0"><?php echo isset($stats['withIdVerification']) ? $stats['withIdVerification'] : 0; ?></h3>
                </div>
                <div>
                    <i class="fa-solid fa-id-card fa-2x text-muted opacity-50"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<?php if (isset($cities) && !empty($cities)): ?>
<div class="filter-card">
    <div class="row align-items-center">
        <div class="col-md-4">
            <label class="form-label fw-bold text-muted mb-2">
                <i class="fa-solid fa-filter"></i> Filter by City
            </label>
            <select class="form-select" id="filterCity">
                <option value="">All Cities</option>
                <?php foreach ($cities as $cityId => $city): ?>
                    <option value="<?php echo htmlspecialchars($cityId); ?>">
                        <?php echo htmlspecialchars(isset($city['cityName']) ? $city['cityName'] : $cityId); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-bold text-muted mb-2">
                <i class="fa-solid fa-search"></i> Search
            </label>
            <input type="text" class="form-control" id="searchInput" placeholder="Search by name, email, or phone...">
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo base_url('Customer/addcustomer'); ?>" class="btn btn-modern btn-modern-primary mt-4">
                <i class="fa-solid fa-plus"></i> Add Customer
            </a>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Customers Table -->
<div class="customer-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> 
            <?php echo (isset($filterType) && $filterType == 'approved') ? 'Approved' : 'Pending'; ?> Customers List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="customerTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer</th>
                        <th>Contact</th>
                        <th>City</th>
                        <th>ID Verification</th>
                        <th>Loyalty Points</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($customerlist)) {
                        $count = 1;
                        foreach ($customerlist as $id => $user):
                            $fullName = (isset($user['firstName']) ? $user['firstName'] : '') . ' ' . (isset($user['lastName']) ? $user['lastName'] : '');
                            $email = isset($user['email']) ? $user['email'] : '-';
                            $phone = isset($user['phoneNumber']) ? $user['phoneNumber'] : '-';
                            $points = isset($user['points']) ? intval($user['points']) : 0;
                            $isApproved = isset($user['isApproved']) && $user['isApproved'];
                            $cityName = isset($user['cityName']) ? $user['cityName'] : 'Not Assigned';
                            $hasIdFront = isset($user['idFront']) && $user['idFront'] != '';
                            $hasIdBack = isset($user['idBack']) && $user['idBack'] != '';
                    ?>
                    <tr data-city-id="<?php echo isset($user['cityId']) ? htmlspecialchars($user['cityId']) : ''; ?>">
                        <td><?php echo $count; ?></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <?php if (isset($user['image']) && $user['image'] != ''): ?>
                                    <img src="<?php echo htmlspecialchars($user['image']); ?>" 
                                         alt="Customer" 
                                         class="rounded-circle me-2" 
                                         style="width: 40px; height: 40px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="rounded-circle me-2 d-flex align-items-center justify-content-center bg-light" 
                                         style="width: 40px; height: 40px;">
                                        <i class="fa-solid fa-user text-muted"></i>
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <strong class="customer-name-link"><?php echo htmlspecialchars(trim($fullName)); ?></strong>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($email); ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div>
                                <i class="fa-solid fa-phone text-muted"></i> 
                                <span><?php echo htmlspecialchars($phone); ?></span>
                            </div>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-map-marker-alt"></i>
                                <?php echo htmlspecialchars($cityName); ?>
                            </span>
                        </td>
                        <td>
                            <div class="d-flex gap-2">
                                <?php if ($hasIdFront): ?>
                                    <a href="<?php echo htmlspecialchars($user['idFront']); ?>" target="_blank" 
                                       data-bs-toggle="tooltip" title="View Front ID">
                                        <img src="<?php echo htmlspecialchars($user['idFront']); ?>" 
                                             class="id-image" 
                                             alt="Front ID">
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted"><i class="fa-solid fa-times-circle"></i></span>
                                <?php endif; ?>
                                
                                <?php if ($hasIdBack): ?>
                                    <a href="<?php echo htmlspecialchars($user['idBack']); ?>" target="_blank" 
                                       data-bs-toggle="tooltip" title="View Back ID">
                                        <img src="<?php echo htmlspecialchars($user['idBack']); ?>" 
                                             class="id-image" 
                                             alt="Back ID">
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted"><i class="fa-solid fa-times-circle"></i></span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td>
                            <span class="badge-modern badge-warning-modern">
                                <i class="fa-solid fa-star"></i>
                                <?php echo number_format($points); ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($isApproved): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-check-circle"></i> Approved
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-warning-modern">
                                    <i class="fa-solid fa-clock"></i> Pending
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="dropdown action-dropdown">
                                <button class="btn btn-sm btn-modern btn-modern-info" type="button" 
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fa-solid fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <?php if ($isApproved): ?>
                                        <li>
                                            <a class="dropdown-item" 
                                               href="<?php echo base_url('Customer/suspendCustomer/' . $id); ?>"
                                               onclick="return confirm('Are you sure you want to disable this customer?');">
                                                <i class="fa-solid fa-ban text-warning"></i> Disable
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li>
                                            <a class="dropdown-item" 
                                               href="<?php echo base_url('Customer/unSuspendCustomer/' . $id); ?>"
                                               onclick="return confirm('Are you sure you want to approve this customer?');">
                                                <i class="fa-solid fa-check text-success"></i> Approve
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <a class="dropdown-item" 
                                           href="<?php echo base_url('Customer/editcustomers/' . $id); ?>">
                                            <i class="fa-solid fa-edit text-primary"></i> Edit
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <a class="dropdown-item text-danger" 
                                           href="<?php echo base_url('Customer/deleteCustomer/' . $id); ?>"
                                           onclick="return confirm('Are you sure you want to delete this customer? This action cannot be undone.');">
                                            <i class="fa-solid fa-trash"></i> Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php 
                        $count++;
                        endforeach;
                    } else {
                    ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fa-solid fa-users fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No Customers Found</h5>
                            <p class="text-muted">
                                <?php echo (isset($filterType) && $filterType == 'approved') ? 
                                    'No approved customers yet.' : 
                                    'No pending customers at the moment.'; ?>
                            </p>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
var customerTable;

$(document).ready(function() {
    // Initialize DataTables
    customerTable = $('#customerTable').DataTable({
        "order": [[ 1, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ customers per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ customers",
            "infoEmpty": "No customers found",
            "infoFiltered": "(filtered from _MAX_ total customers)"
        }
    });
    
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // City filter - custom filter function
    var cityFilterActive = false;
    var cityFilterFunction = function(settings, data, dataIndex) {
        var cityId = $('#filterCity').val();
        if (cityId === '') {
            return true;
        }
        var row = customerTable.row(dataIndex).node();
        var rowCityId = $(row).attr('data-city-id');
        return rowCityId === cityId;
    };
    
    $('#filterCity').on('change', function() {
        var cityId = $(this).val();
        if (cityId === '') {
            // Remove filter if active
            if (cityFilterActive) {
                var index = $.fn.dataTable.ext.search.indexOf(cityFilterFunction);
                if (index !== -1) {
                    $.fn.dataTable.ext.search.splice(index, 1);
                }
                cityFilterActive = false;
            }
        } else {
            // Add filter if not already added
            if (!cityFilterActive) {
                $.fn.dataTable.ext.search.push(cityFilterFunction);
                cityFilterActive = true;
            }
        }
        customerTable.draw();
    });
    
    // Search filter
    $('#searchInput').on('keyup', function() {
        customerTable.search($(this).val()).draw();
    });
});
</script>
