<style>
.dispute-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.dispute-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.dispute-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.dispute-stats-card.primary { border-left-color: #72A565; }
.dispute-stats-card.warning { border-left-color: #ed8936; }
.dispute-stats-card.danger { border-left-color: #f56565; }
.dispute-stats-card.success { border-left-color: #48bb78; }

.dispute-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.dispute-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.dispute-table-card table thead {
    background: #f7fafc;
}

.dispute-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.dispute-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.dispute-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.dispute-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.5rem 1rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    border: none;
    font-size: 0.875rem;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.btn-modern-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-modern-warning {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}
</style>

<!-- Header Section -->
<div class="dispute-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-gavel"></i> Dispute Management
            </h2>
            <p class="mb-0 opacity-75">Track escalations, responses, and resolution status</p>
        </div>
        <div class="col-md-6 text-end">
            <button type="button" class="btn btn-light btn-modern" data-toggle="modal" data-target="#exampleModal">
                <i class="fa-solid fa-plus"></i> Add Dispute
            </button>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalDisputes = !empty($disputesData) ? count($disputesData) : 0;
$openDisputes = 0;
$resolvedDisputes = 0;

if (!empty($disputesData)) {
    foreach ($disputesData as $dispute) {
        $status = isset($dispute['status']) ? $dispute['status'] : true;
        if ($status && $status !== 'resolved' && $status !== 'closed') {
            $openDisputes++;
        } else {
            $resolvedDisputes++;
        }
    }
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="dispute-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-gavel fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Total Disputes</h6>
                    <h3 class="stats-number mb-0"><?php echo $totalDisputes; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="dispute-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-exclamation-circle fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Open Disputes</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $openDisputes; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="dispute-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-check-circle fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Resolved</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $resolvedDisputes; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="dispute-stats-card danger">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-clock fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Avg Resolution</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">2.5d</h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Disputes Table -->
<div class="dispute-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> All Disputes
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($disputesData)): ?>
        <div class="table-responsive">
            <table class="table table-hover mb-0 datatableexport" id="disputesTable">
                <thead>
                    <tr>
                        <th>Ticket No</th>
                        <th>Customer Name</th>
                        <th>Rider/Driver</th>
                        <th>Reason</th>
                        <th>Date Opened</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($disputesData as $disputeId => $data): 
                        $status = isset($data['status']) ? $data['status'] : true;
                        $isResolved = ($status === false || $status === 'resolved' || $status === 'closed');
                    ?>
                    <tr>
                        <td><strong>#<?php echo isset($data['ticketNo']) ? htmlspecialchars($data['ticketNo']) : $disputeId; ?></strong></td>
                        <td><?php echo isset($data['userName']) ? htmlspecialchars($data['userName']) : 'N/A'; ?></td>
                        <td><?php echo isset($data['driverName']) ? htmlspecialchars($data['driverName']) : 'N/A'; ?></td>
                        <td><?php echo isset($data['reason']) ? htmlspecialchars($data['reason']) : 'N/A'; ?></td>
                        <td><?php echo isset($data['dateOpened']) ? htmlspecialchars($data['dateOpened']) : 'N/A'; ?></td>
                        <td><?php echo isset($data['userEmail']) ? htmlspecialchars($data['userEmail']) : 'N/A'; ?></td>
                        <td>
                            <?php if ($isResolved): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-check-circle"></i> Resolved
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-warning-modern">
                                    <i class="fa-solid fa-clock"></i> Open
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex gap-2 justify-content-center">
                                <a href="<?php echo base_url('Dispute/editDispute/' . $disputeId); ?>" class="btn btn-sm btn-info btn-modern" title="Edit">
                                    <i class="fa-solid fa-edit"></i> Edit
                                </a>
                                <?php if (!$isResolved): ?>
                                    <a href="<?php echo base_url('Dispute/resolveDispute/' . $disputeId); ?>" class="btn btn-sm btn-success btn-modern" title="Resolve">
                                        <i class="fa-solid fa-check"></i> Resolve
                                    </a>
                                <?php endif; ?>
                                <a href="<?php echo base_url('Dispute/deletedispute/' . $disputeId); ?>" 
                                    class="btn btn-sm btn-danger btn-modern" 
                                    title="Delete"
                                    onclick="return confirm('Are you sure you want to delete this dispute?');">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="fa-solid fa-gavel fa-3x text-muted mb-3"></i>
            <p class="text-muted">No disputes found</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form method="post" action="<?php echo base_url('Dispute/addDispute'); ?>">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="exampleModalLabel">
                        <i class="fa-solid fa-plus"></i> New Dispute
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Ticket No<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" disabled value="<?php echo time(); ?>">
                                <input type="hidden" name="ticketNo" value="<?php echo time(); ?>">
                                <input type="hidden" name="status" value="true">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Customer Name<span class="text-danger">*</span></label>
                                <input type="text" name="userName" class="form-control" placeholder="Customer Name" required>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Email<span class="text-danger">*</span></label>
                                <input type="email" name="userEmail" class="form-control" placeholder="Email" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Phone<span class="text-danger">*</span></label>
                                <input type="tel" name="phoneNumber" class="form-control" placeholder="Phone Number" required>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Address<span class="text-danger">*</span></label>
                                <input type="text" name="Address" class="form-control" placeholder="Address" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Rider/Driver Name</label>
                                <input type="text" name="driverName" class="form-control" placeholder="Rider/Driver Name">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Reason<span class="text-danger">*</span></label>
                                <input type="text" name="reason" class="form-control" placeholder="Dispute Reason" required>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Date Opened<span class="text-danger">*</span></label>
                                <input type="date" name="dateOpened" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Date Closed</label>
                                <input type="date" name="dateClosed" class="form-control">
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Staff Member Handling</label>
                                <input type="text" name="staffName" class="form-control" placeholder="Staff Member Name">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary btn-modern">
                        <i class="fa-solid fa-save"></i> Create Dispute
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#disputesTable').DataTable({
        "order": [[ 0, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ disputes per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ disputes",
            "infoEmpty": "No disputes found",
            "infoFiltered": "(filtered from _MAX_ total disputes)"
        }
    });
});
</script>
