<style>
.form-header-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.form-card-modern {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.form-card-modern .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.form-card-modern .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.4);
    color: white;
}

.form-group-modern {
    margin-bottom: 1.5rem;
}

.section-divider {
    border: none;
    height: 2px;
    background: linear-gradient(90deg, transparent, #e2e8f0, transparent);
    margin: 2rem 0;
}
</style>

<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="form-header-modern">
        <h2 class="mb-2">
            <i class="fa-solid fa-user-plus"></i> Add New Driver
        </h2>
        <p class="mb-0 opacity-75">Create a new driver account with city assignment and vehicle information</p>
    </div>
    
    <form method="post" id="add_driver" action="<?php echo base_url() . "drivers/insertdriver"; ?>" enctype="multipart/form-data">
        <!-- Driver Information -->
        <div class="form-card-modern">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-user text-primary"></i> Driver Information
                </h5>
            </div>
            <div class="card-body">
                <input type="hidden" name="d_id" id="d_id" value="<?php echo (isset($driverdetails)) ? $driverdetails[0]['d_id'] : '' ?>">
                
                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">First Name <span class="text-danger">*</span></label>
                        <input type="text" name="d_firstName" id="firstName" class="form-control form-control-modern" placeholder="First Name" 
                            value="<?php echo (isset($driverdetails)) ? $driverdetails[0]['firstName'] : '' ?>" required>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Last Name <span class="text-danger">*</span></label>
                        <input type="text" name="d_lastName" class="form-control form-control-modern" placeholder="Last Name" 
                            value="<?php echo (isset($driverdetails)) ? $driverdetails[0]['lastName'] : '' ?>" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Email <span class="text-danger">*</span></label>
                        <input type="email" name="d_email" class="form-control form-control-modern" placeholder="Email" 
                            value="<?php echo (isset($driverdetails)) ? $driverdetails[0]['email'] : '' ?>" required>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Phone Number <span class="text-danger">*</span></label>
                        <input type="tel" name="d_phoneNumber" class="form-control form-control-modern" placeholder="Phone Number" 
                            value="<?php echo (isset($driverdetails)) ? $driverdetails[0]['phoneNumber'] : '' ?>" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Password <span class="text-danger">*</span></label>
                        <input type="password" name="d_password" class="form-control form-control-modern" placeholder="Password" required>
                        <small class="text-muted">Minimum 6 characters</small>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="cityId" class="form-label-modern">Assign City <span class="text-danger">*</span></label>
                        <select id="cityId" name="cityId" class="form-control form-control-modern" required>
                            <option value="">-- Select City --</option>
                            <?php if (isset($cities) && !empty($cities)): ?>
                                <?php foreach ($cities as $cityId => $city): ?>
                                    <option value="<?php echo $cityId; ?>">
                                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="isApproved" class="form-label-modern">Approve Driver</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="isApproved" name="isApproved" value="1" style="width: 3rem; height: 1.5rem;">
                            <label class="form-check-label" for="isApproved">Approve immediately</label>
                        </div>
                        <small class="text-muted">If checked, driver will be approved and active immediately</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Vehicle Information -->
        <div class="form-card-modern">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-car text-primary"></i> Vehicle Information
                </h5>
            </div>
            <div class="card-body">
                <input type="hidden" name="v_id" id="v_id" value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['v_id'] : '' ?>">

                <div class="row">
                    <div class="col-md-4 form-group-modern">
                        <label class="form-label-modern">Make <span class="text-danger">*</span></label>
                        <input type="text" name="v_make" id="make" class="form-control form-control-modern" placeholder="Make" 
                            value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['make'] : '' ?>" required>
                    </div>
                    <div class="col-md-4 form-group-modern">
                        <label class="form-label-modern">Model <span class="text-danger">*</span></label>
                        <input type="text" name="v_model" id="model" class="form-control form-control-modern" placeholder="Model" 
                            value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['model'] : '' ?>" required>
                    </div>
                    <div class="col-md-4 form-group-modern">
                        <label class="form-label-modern">Color <span class="text-danger">*</span></label>
                        <input type="text" name="v_color" class="form-control form-control-modern" placeholder="Color" 
                            value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['color'] : '' ?>" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Tag Number <span class="text-danger">*</span></label>
                        <input type="text" name="v_tagNumber" class="form-control form-control-modern" placeholder="Tag Number" 
                            value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['tagNumber'] : '' ?>" required>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Driving License <span class="text-danger">*</span></label>
                        <input type="text" name="v_drivingLicense" class="form-control form-control-modern" placeholder="Driving License Number" 
                            value="<?php echo (isset($vehicledetails)) ? $vehicledetails[0]['drivingLicense'] : '' ?>" required>
                    </div>
                </div>

                <hr class="section-divider">

                <h6 class="mb-3">
                    <i class="fa-solid fa-images text-primary"></i> Driver License Images
                </h6>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Photo of Driver's License Front <span class="text-danger">*</span></label>
                        <input type="file" name="v_drivingFrontUrl" class="form-control form-control-modern" accept="image/*" required>
                        <small class="text-muted">Upload front side of driver's license</small>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Photo of Driver's License Back <span class="text-danger">*</span></label>
                        <input type="file" name="v_drivingBackUrl" class="form-control form-control-modern" accept="image/*" required>
                        <small class="text-muted">Upload back side of driver's license</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-end mb-4">
            <input type="hidden" id="created_by" name="v_createdBy" value="<?php echo output($this->session->userdata['session_data']['u_id']); ?>">
            <input type="hidden" id="created_date" name="v_createdDate" value="<?php echo date('Y-m-d h:i:s'); ?>">
            <button type="submit" class="btn btn-submit-modern">
                <i class="fa-solid fa-save"></i> Add Driver
            </button>
            <a href="<?php echo base_url('drivers'); ?>" class="btn btn-secondary btn-modern">
                <i class="fa-solid fa-times"></i> Cancel
            </a>
        </div>
    </form>
</div>
