<style>
.driver-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.driver-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
}

.driver-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.driver-stats-card.primary { border-left-color: #667eea; }
.driver-stats-card.success { border-left-color: #48bb78; }
.driver-stats-card.warning { border-left-color: #ed8936; }
.driver-stats-card.info { border-left-color: #4299e1; }
.driver-stats-card.danger { border-left-color: #f56565; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.driver-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.driver-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.driver-table-card table thead {
    background: #f7fafc;
}

.driver-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.driver-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.driver-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.driver-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    border: none;
    color: white;
}

.action-dropdown .dropdown-menu {
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    border: none;
    padding: 0.5rem;
}

.action-dropdown .dropdown-item {
    border-radius: 8px;
    padding: 0.75rem 1rem;
    transition: all 0.2s ease;
    margin-bottom: 0.25rem;
}

.action-dropdown .dropdown-item:hover {
    background: #f7fafc;
    transform: translateX(5px);
}

.action-dropdown .dropdown-item i {
    width: 20px;
    text-align: center;
}

.driver-name-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.driver-name-link:hover {
    color: #764ba2;
    text-decoration: none;
    transform: translateX(5px);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}

.online-indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 0.5rem;
    animation: pulse 2s infinite;
}

.online-indicator.online {
    background: #48bb78;
    box-shadow: 0 0 0 0 rgba(72, 187, 120, 0.7);
}

.online-indicator.offline {
    background: #a0aec0;
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(72, 187, 120, 0.7);
    }
    70% {
        box-shadow: 0 0 0 10px rgba(72, 187, 120, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(72, 187, 120, 0);
    }
}
</style>

<!-- Header Section -->
<div class="driver-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-car"></i> Driver Management
            </h2>
            <p class="mb-0 opacity-75">Manage all drivers, city assignments, and availability status</p>
        </div>
        <div class="col-md-6 text-end">
            <div class="d-flex justify-content-end gap-2 flex-wrap">
                <a href="<?php echo base_url('drivers'); ?>" class="btn btn-light btn-modern">
                    <i class="fa-solid fa-list"></i> All Drivers
                </a>
                <a href="<?php echo base_url('drivers/approveddrivers'); ?>" class="btn btn-light btn-modern">
                    <i class="fa-solid fa-check-circle"></i> Approved
                </a>
                <a href="<?php echo base_url('drivers/adddrivers'); ?>" class="btn btn-light btn-modern btn-modern-primary">
                    <i class="fa-solid fa-plus"></i> Add Driver
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalDrivers = count($driverslist);
$activeDrivers = 0;
$onlineDrivers = 0;
$driversByCity = array();
foreach ($driverslist as $d => $driver) {
    $isApproved = isset($driver['isApproved']) ? $driver['isApproved'] : false;
    $isActive = isset($driver['isActive']) ? $driver['isActive'] : true;
    if ($isApproved && $isActive) {
        $activeDrivers++;
    }
    
    $isOnline = isset($driver['isOnline']) ? $driver['isOnline'] : false;
    if ($isOnline) {
        $onlineDrivers++;
    }
    
    $cityId = isset($driver['cityId']) ? $driver['cityId'] : 'unassigned';
    if (!isset($driversByCity[$cityId])) {
        $driversByCity[$cityId] = 0;
    }
    $driversByCity[$cityId]++;
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="driver-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-users"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Drivers</p>
                    <h3 class="stats-number mb-0"><?php echo $totalDrivers; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="driver-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);">
                        <i class="fa-solid fa-check-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Active Drivers</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $activeDrivers; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="driver-stats-card info">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);">
                        <i class="fa-solid fa-wifi"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Online Now</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $onlineDrivers; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="driver-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);">
                        <i class="fa-solid fa-city"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Cities Covered</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo count(array_filter($driversByCity, function($k) { return $k != 'unassigned'; }, ARRAY_FILTER_USE_KEY)); ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="d-flex align-items-center mb-3">
        <i class="fa-solid fa-filter text-primary me-2"></i>
        <h5 class="mb-0">Filter Drivers</h5>
    </div>
    <form method="get" action="<?php echo base_url('drivers'); ?>" class="row g-3">
        <div class="col-md-3">
            <label for="filter_city" class="form-label fw-bold">City</label>
            <select class="form-control form-select" id="filter_city" name="filter_city">
                <option value="">All Cities</option>
                <?php foreach ($cities as $cityId => $city): ?>
                    <option value="<?php echo $cityId; ?>" <?php echo (isset($filterCity) && $filterCity == $cityId) ? 'selected' : ''; ?>>
                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label for="filter_status" class="form-label fw-bold">Status</label>
            <select class="form-control form-select" id="filter_status" name="filter_status">
                <option value="">All Status</option>
                <option value="active" <?php echo (isset($filterStatus) && $filterStatus == 'active') ? 'selected' : ''; ?>>Active</option>
                <option value="inactive" <?php echo (isset($filterStatus) && $filterStatus == 'inactive') ? 'selected' : ''; ?>>Inactive</option>
            </select>
        </div>
        <div class="col-md-3">
            <label for="filter_availability" class="form-label fw-bold">Availability</label>
            <select class="form-control form-select" id="filter_availability" name="filter_availability">
                <option value="">All Availability</option>
                <option value="online" <?php echo (isset($filterAvailability) && $filterAvailability == 'online') ? 'selected' : ''; ?>>Online</option>
                <option value="offline" <?php echo (isset($filterAvailability) && $filterAvailability == 'offline') ? 'selected' : ''; ?>>Offline</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-bold">&nbsp;</label>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-modern btn-modern-primary w-100">
                    <i class="fa-solid fa-filter"></i> Apply
                </button>
                <a href="<?php echo base_url('drivers'); ?>" class="btn btn-secondary btn-modern">
                    <i class="fa-solid fa-times"></i>
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Drivers Table -->
<div class="driver-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Drivers List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="drivertable">
                <thead>
                    <tr>
                        <th>Driver</th>
                        <th>Contact</th>
                        <th>City</th>
                        <th>Vehicle</th>
                        <th>Status</th>
                        <th>Availability</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                  
                    <?php foreach ($driverslist as $j => $d): ?>
                        <?php $vehicle = $this->common->readdatadocument("Vehicles", $j);
                        
                      
                        ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 me-3">
                                    <?php if (isset($d['image']) && !empty($d['image'])): ?>
                                        <img src="<?php echo $d['image']; ?>" alt="" class="rounded-circle" style="width: 40px; height: 40px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="rounded-circle bg-gradient-primary d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                            <i class="fa-solid fa-user text-white"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <a href="<?php echo base_url('drivers/viewdriver/') . $j; ?>" class="driver-name-link">
                                        <?php echo isset($d['firstName']) ? $d['firstName'] : ''; ?> <?php echo isset($d['lastName']) ? $d['lastName'] : ''; ?>
                                    </a>
                                    <br><small class="text-muted"><?php echo isset($d['email']) ? $d['email'] : '-'; ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div>
                                <i class="fa-solid fa-phone text-muted me-1"></i>
                                <small><?php echo isset($d['phoneNumber']) ? $d['phoneNumber'] : '-'; ?></small>
                            </div>
                        </td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-city"></i>
                                <?php echo isset($d['cityName']) ? $d['cityName'] : 'Not Assigned'; ?>
                            </span>
                        </td>
                        <td>
                            <?php if (isset($vehicle) && !empty($vehicle)): ?>
                                <small>
                                    <strong><?php echo isset($vehicle['make']) ? $vehicle['make'] : ''; ?> <?php echo isset($vehicle['model']) ? $vehicle['model'] : ''; ?></strong><br>
                                    <span class="text-muted"><?php echo isset($vehicle['tagNumber']) ? $vehicle['tagNumber'] : ''; ?></span>
                                </small>
                            <?php else: ?>
                                <small class="text-muted">No vehicle</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php 
                            $isApproved = isset($d['isApproved']) ? $d['isApproved'] : false;
                            $isActive = isset($d['isActive']) ? $d['isActive'] : true;
                            ?>
                            <?php if ($isApproved && $isActive): ?>
                                <span class="badge-modern badge-success-modern">
                                    <i class="fa-solid fa-check-circle"></i> Active
                                </span>
                            <?php elseif ($isApproved && !$isActive): ?>
                                <span class="badge-modern badge-secondary-modern">
                                    <i class="fa-solid fa-pause-circle"></i> Inactive
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-danger-modern">
                                    <i class="fa-solid fa-clock"></i> Pending
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php 
                            $isOnline = isset($d['isOnline']) ? $d['isOnline'] : false;
                            ?>
                            <?php if ($isOnline): ?>
                                <span class="badge-modern badge-success-modern">
                                    <span class="online-indicator online"></span> Online
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-secondary-modern">
                                    <span class="online-indicator offline"></span> Offline
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="dropdown action-dropdown">
                                <button class="btn btn-sm btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fa-solid fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/viewdriver/') . $j; ?>">
                                            <i class="fa-solid fa-eye text-primary"></i> View Details
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/edit_driver_info/') . $j; ?>">
                                            <i class="fa-solid fa-edit text-info"></i> Edit
                                        </a>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <?php if ($isApproved && $isActive): ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/deactivateDriver/') . $j; ?>">
                                            <i class="fa-solid fa-ban text-warning"></i> Deactivate
                                        </a>
                                    </li>
                                    <?php elseif ($isApproved && !$isActive): ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/activateDriver/') . $j; ?>">
                                            <i class="fa-solid fa-check-circle text-success"></i> Activate
                                        </a>
                                    </li>
                                    <?php else: ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/approveDriver/') . $j; ?>">
                                            <i class="fa-solid fa-check text-success"></i> Approve
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <li><hr class="dropdown-divider"></li>
                                    <?php if ($isOnline): ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/setDriverOffline/') . $j; ?>">
                                            <i class="fa-solid fa-toggle-on text-warning"></i> Set Offline
                                        </a>
                                    </li>
                                    <?php else: ?>
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('drivers/setDriverOnline/') . $j; ?>">
                                            <i class="fa-solid fa-toggle-off text-success"></i> Set Online
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <a class="dropdown-item text-danger" href="<?php echo base_url('drivers/deleteDriver/') . $j; ?>" 
                                           onclick="return confirm('Are you sure you want to delete this driver? This action cannot be undone.');">
                                            <i class="fa-solid fa-trash"></i> Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#drivertable').DataTable({
        "order": [[ 0, "asc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ drivers per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ drivers",
            "infoEmpty": "No drivers found",
            "infoFiltered": "(filtered from _MAX_ total drivers)"
        }
    });
});
</script>
